/* The main module for wave */

#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"
#include "link_types.h"

#include "link_edit_types.h"

Display *dpy;
double xppmm,yppmm;  /* x and y pixels per millimeter */
double WidthMM,HeightMM;

BoxStatus box_status;
BoxData box_data;

LinkStatus link_status;
LinkData link_data;

LinkEditStatus link_edit_status;
LinkEditData link_edit_data;

main(argc,argv)

int argc;
char *argv[];

{
  Window top;
  XWindowAttributes xwa;
  XEvent event;

  /* Open up the connection to the X Server */

  if((dpy = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Could not open server.\n");
    exit(1);
   }

  /* Get some basic information */

  WidthMM = (double) DisplayWidthMM(dpy,DefaultScreen(dpy));
  HeightMM = (double) DisplayHeightMM(dpy,DefaultScreen(dpy));
  xppmm = (double) DisplayWidth(dpy,DefaultScreen(dpy))/WidthMM;
  yppmm = (double) DisplayHeight(dpy,DefaultScreen(dpy))/HeightMM;


  /* initialize box */
  BoxSetUp(&box_data);
  BoxInitialize(&box_status,&box_data);

  /* initialize client */
  LinkSetUp(&link_data);
  LinkInitialize(&link_status,&link_data);

  /* initialize link_edit */
  LinkEditSetUp(&link_edit_data);
  /* Connect clients */
  link_edit_status.link_status = (VOID *) (&link_status);
  link_edit_status.box_status = (VOID *) (&box_status);

  LinkEditInitialize(&link_edit_status,&link_edit_data);

  while(1){

     XNextEvent(dpy,&event);
     top = event.xany.window;

     if(top == link_status.TopWindow ||
          top == link_status.MessageWindow ||
          top == link_status.TitleWindow) {
        LinkEvent(&link_status,&event);
        continue;
       }

     if(top == box_status.TopWindow ||
          top == box_status.MessageWindow ||
          top == box_status.TitleWindow) {

        BoxEvent(&box_status,&event);
     
        /* Check it out */
        if(BoxStateChange((VOID *) (&box_status))) {
           int choice[10],num;
           num = ExtractBoxSelection((VOID *) (&box_status),
                                         choice);
           LinkEditMenuChoice(&link_edit_status,num,choice);
          }
        continue;
       }

    }
}

BoxSetUp(data)

BoxData *data;

{
  data->root = DefaultRootWindow(dpy);
  data->x =  BOX_X_OFFSET * WidthMM;
  data->y = BOX_Y_OFFSET * HeightMM;
  data->width = 166.36; 
  data->height = 191.69; 
  data->border = BOX_BORDER;

  data->title_present = BOX_YES;
  data->message_present = BOX_YES;
  data->urgent_present = BOX_YES;
  data->do_not_map = BOX_NO;

  strcpy(data->title,"Link Editor");
  strcpy(data->message,"Look here for messages.");
  strcpy(data->font,"9x15");

  data->arg = (VOID *) NULL;
}

LinkSetUp(data)

LinkData *data;

{
  data->root = box_status.TopWindow; 
  data->x = 3.169; 
  data->y = 6.856; 
  data->width = 160.022; 
  data->height = 113.379; 
  data->border = LINK_BORDER;

  data->title_present = LINK_NO;
  data->message_present = LINK_YES;
  data->urgent_present = LINK_YES;

  data->xruler = LINK_NO;  /* Show ruler */
  data->yruler = LINK_NO;
  data->xscale = 1.0;
  data->yscale = 1.0;
  strcpy(data->data_font,"6x10");

  strcpy(data->title,"Link Title");
  strcpy(data->message,"Link Message");
  strcpy(data->font,"9x15");

  data->gray = 0.7;
}

LinkEditSetUp(data)
LinkEditData *data;
{
}


