#include <omni_proc.h>

global_init ()
{
  chunk = 3;
}

global_function ()
{
  if (chunk < 3) {
    fprintf (stderr, "Chunk should be set >= 3.\n");
    exit (1);
  }

  B = cos(A);
  C = sin(A);
}

float_function (in, out, pos)
double *in, *out;
int pos;
{
  int i;

  out[0] = B*in[0] + C*in[1];
  out[1] = -C*in[0] + B*in[1];
  out[2] = in[2];
  for (i=3; i<chunk; i++) out[i] = in[i];
}

Usage ()
{
  fprintf(stderr,"Usage: rotate -A angle infile outfile\n");
  fprintf(stderr,"  rotates data angle degrees around z axis.\n");
}
