#include "extern.h"

/* Book-keeping functions */

countnbrs(key)
/* count and store in numnbrs field, the number of neighbors having state key */
int key;
{
	/* now identify points which are totally surrounded */
	/* later we'll assume that their whole circle lies inside */
	int mypos[6][2], gindx, m, num, i, j, indx;
	/* ZZZ: assume boundary circles have NO neighbors: should have buffer zone */
	for (i=0; i<hw; ++i)	DCirc[i].numnbr = 0;
	for (i=0; i<height; i++) {
		for (j=0; j<width; j++) {
			indx = j + i * width;
			if (DCirc[indx].state > 0)	{
				getccindices(i,j,mypos);
				for (num = 0, m=0; m< NUMNBRS; ++m)
					{
					gindx = mypos[m][1]+width*mypos[m][0];
					if ( DCirc[gindx].state & key)  num++;
					}
				DCirc[indx].numnbr = num;
			}
		}
	}
} /* countnbrs */

countcircles()	{
/* Store in numcircles the number of domain circles and holes */
	int i;
	for (numcircles = 0, i=0; i<hw; ++i)	{
		if (DCirc[i].state > 0)	++numcircles;
	}
	numcircles += numholes;
} /* countcircles */

indexcircles()	{
/* Label the cnum flag of the variable radii 
and set in myindex the DCirc indices of the domain circles */
	register int i, vcount, fixindx;

	vcount = 1;
	fixindx = fixradj+fixradi*width;
	for (i=0; i<hw; ++i)		{
		if ((DCirc[i].state > OUTSIDE)
		&& (i!=fixindx)
		&& (i!=fixindx-1))	{
			DCirc[i].cnum = vcount;
			++vcount;
		}
	}
	mynorm = vcount+1;
	myindex = (int*) XtCalloc(mynorm, sizeof(int));
	mycolor = (int *) XtCalloc(mynorm , sizeof(int));
	for (i=0; i<numholes; ++i)	{
		DHole[i].cnum = vcount;
		++vcount;
	}
	maxvars = vcount;
	DCirc[fixindx-1].cnum = vcount;
	DCirc[fixindx].cnum = vcount+1;

	vcount = 0;
	for (i=0; i<hw; ++i)		{
		if (DCirc[i].state > OUTSIDE)	{
			myindex[vcount] = i;
			++vcount;
		}
	}
} /* indexcircles */
