#include	"mapdefs.h"
#include	"stdio.h"
#include	"math.h"
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/cursorfont.h>
#include	<X11/Intrinsic.h>

extern	int		LRATIO;				/* Used in ndrv(); ratio of real to int sizes */
extern	int		bdrymode;			/* Boundary modification mode */
extern	int		normbdry;			/* Number of boundary circles. */
extern	int		maxvars;			/* Maximum number of variable cnum fields. */
extern	int		runcount;			/* count number of converged runs */
extern	int		subdividing;			/* flag to indicate continuation of acceleration */
extern	Bool		massagemode;			/* flag for Thurston boundary modification */
extern	Display		*dpy;				/* display device */
extern	Window		domainwin, rangewin;		/* windows invoked */
extern	GC		gc;				/* graphics context */
extern	Region		myRegion;			/* bounding curves for the circle domain */
extern	int		width, height;			/* dimensions of the circleinfo and plotinfo arrays */
extern	int		hw;				/* (width-1)*(height-1) + 1 */
extern	int		xmin, xmax, ymin, ymax;		/* bounding coordinates for myRegion */
extern	int		numholes;			/* the number of holes in the circle domain */
extern	int		numcircles;			/* the number of circles in the circle domain */
extern	int		fixradi, fixradj;		/* circleinfo indices of a circle of fixed radius */
extern	int		nulli, nullj;			/* circleinfo indices of the nullcircle */
extern	double		fillrad;			/* filling radius */
extern	double		maxkappa;			/* Maximum |curvature| */
extern	circleinfo	*DCirc, *DHole, *RCirc, *RHole;		/* info of domain and range packings */
extern	edgeinfo	*myedge;			/* angle information on edges for prescribed angle intersections */
extern	plotinfo	*DPlot, *RPlot;			/* info of domain and range screen plots */
extern	XPoint		myRgnPoint[1000];		/* points determining the bounding curves for the circle domain */
extern	int		normRgn;			/* the number of points in myRgnPoint */
extern	int		*mycolor;			/* array of color pixel indices assigned to circles */
extern	int		*myindex;			/* indices of nonzero circle entries */
extern	int		mynorm;				/* length of myindex */
extern	circleinfo	*GCirc, *GHole;			/* circle info used in making a better initial guess on a finer mesh */
extern	int		oldwidth, oldheight;		/* dimensions of the circleinfo arrays before halving radius */

extern		Bool		nullok();		/* Checks whether nullpoint is acceptable */
extern		Bool		inside();		/* Checks whether a certain point is interior in the packing */
extern		Bool		goodbdry();		/* Checks whether the boundary of the circle domain has been determined correctly for triangulation */
extern		double		getxangle();		/* return angle assigned to a certain edge */
	
extern	int		N;		/* the order of the linear system in the newton step */
extern	double		*curvature;		/* vector of curvature values */

extern	rowpartial	*myrow;			/* vector of partial derivatives of the curvature function; used in getkappa() */
extern	double 		*phi, *d0phi, *d1phi;	/* summands of curvature and partial derivatives of curvature; used in getkappa() */
extern	int		*mynum;			/* neighboring cnum indices; passed by getvalues() to getkappa() */
extern	double 		*z;			/* neighboring radii; passed by getvalues() to getkappa() */

/* the following variables are used in the smpak subroutine NDRV */

extern	int		*R, *C, *IC;	/* orderings on the Partial matrix; default to : i'th entry = i */
extern	int		*IA;		/* delimit rows in JA and A; size = N+1 */
extern	int		*JA;		/* column indices of nonzero entries in Partial */
extern	double		*A;		/* nonzero entries in Partial */
extern	int		*ISP;		/* integer working storage; dimension = LRATIO*NSP */
extern	double		*RSP;		/* work storage; ISP and RSP should be equivalenced (?) */
extern	int		IAindex, IAsum, JAindex;

extern 	int		drawdomain_flag;

extern	void		ndrv_(), nsf_(), nnf_();	/* Sparse matrix solvers */
