        SUBROUTINE NNTC
     *     (N, R, C, IL, JL, IJL, L, D, IU, JU, IJU, U, Z, B, TMP)        CD1056
C                                                                         CD1057
C       INPUT VARIABLES:   N, R, C, IL, JL, IJL, L, D, IU, JU, IJU, U, B  CD1058
C       OUTPUT VARIABLES:  Z                                              CD1059
C                                                                         CD1060
C       PARAMETERS USED INTERNALLY:                                       CD1061
C FIA   \ TMP   - TEMPORARY VECTOR WHICH GETS RESULT OF SOLVING UT Y = B  CD1062
C       \           SIZE = N.                                             CD1063
C                                                                         CD1064
C  INTERNAL VARIABLES:                                                    CD1065
C    JMIN, JMAX - INDICES OF THE FIRST AND LAST POSITIONS IN A ROW OF     CD1066
C      U OR L  TO BE USED.                                                CD1067
C                                                                         CD1068
        INTEGER R(1), C(1), IL(1), JL(1), IJL(1), IU(1), JU(1), IJU(1)    CD1069
C       REAL L(1), D(1), U(1), B(1), Z(1), TMP(1), TMPK,SUM               CD1070
        DOUBLE PRECISION L(1), D(1), U(1), B(1), Z(1), TMP(1), TMPK,SUM   CD1071
C                                                                         CD1072
C  ******  SET TMP TO REORDERED B  *************************************  CD1073
        DO 1 K=1,N                                                        CD1074
   1      TMP(K) = B(C(K))                                                CD1075
C  ******  SOLVE  UT Y = B  BY FORWARD SUBSTITUTION  *******************  CD1076
        DO 3 K=1,N                                                        CD1077
          JMIN = IU(K)                                                    CD1078
          JMAX = IU(K+1) - 1                                              CD1079
          TMPK = -TMP(K)                                                  CD1080
          IF (JMIN .GT. JMAX) GO TO 3                                     CD1081
          MU = IJU(K) - JMIN                                              CD1082
          DO 2 J=JMIN,JMAX                                                CD1083
   2        TMP(JU(MU+J)) = TMP(JU(MU+J)) + TMPK * U(J)                   CD1084
   3      CONTINUE                                                        CD1085
C  ******  SOLVE  LT X = Y  BY BACK SUBSTITUTION  **********************  CD1086
        K = N                                                             CD1087
        DO 6 I=1,N                                                        CD1088
          SUM = -TMP(K)                                                   CD1089
          JMIN = IL(K)                                                    CD1090
          JMAX = IL(K+1) - 1                                              CD1091
          IF (JMIN .GT. JMAX) GO TO 5                                     CD1092
          ML = IJL(K) - JMIN                                              CD1093
          DO 4 J=JMIN,JMAX                                                CD1094
   4        SUM = SUM + L(J) * TMP(JL(ML+J))                              CD1095
   5      TMP(K) = -SUM * D(K)                                            CD1096
          Z(R(K)) = TMP(K)                                                CD1097
          K = K - 1                                                       CD1098
   6      CONTINUE                                                        CD1099
        RETURN                                                            CD1100
        END                                                               CD1101
