        SUBROUTINE  SNF
     *     (N, P,IP, IA,JA,A, D, IJU,JU,IU,U,UMAX, IL, JL, FLAG)          SD 490
C                                                                         SD 491
C  ADDITIONAL PARAMETERS                                                  SD 492
C                                                                         SD 493
C    IL    - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           SD 494
C                                                                         SD 495
C    JL    - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           SD 496
C                                                                         SD 497
C                                                                         SD 498
C  DEFINITIONS OF INTERNAL PARAMETERS (DURING K-TH STAGE OF ELIMINATION)  SD 499
C                                                                         SD 500
C    (D(I),I=K,N) CONTAINS THE K-TH ROW OF U (EXPANDED)                   SD 501
C                                                                         SD 502
C    IL(I) POINTS TO THE FIRST NONZERO ELEMENT IN COLUMNS K,...,N OF      SD 503
C      ROW I OF U                                                         SD 504
C                                                                         SD 505
C    JL CONTAINS LISTS OF ROWS TO BE ADDED TO UNELIMINATED ROWS --        SD 506
C      I GE K => JL(I) IS THE FIRST ROW TO BE ADDED TO ROW I              SD 507
C      I LT K => JL(I) IS THE ROW FOLLOWING ROW I IN SOME LIST OF ROWS    SD 508
C      IN EITHER CASE, JL(I) = 0 INDICATES THE END OF A LIST              SD 509
C                                                                         SD 510
C-----------------------------------------------------------------------  SD 511
C                                                                         SD 512
        INTEGER  P(1), IP(1),  IA(1), JA(1),  IJU(1), JU(1), IU(1),       SD 513
     *     UMAX,  IL(1),  JL(1),  FLAG,  VJ                               SD 514
C       REAL  A(1),  D(1), U(1),  DK, UKIDI                               SD 515
        DOUBLE PRECISION  A(1),  D(1), U(1),  DK, UKIDI                   SD 516
C                                                                         SD 517
C----CHECK FOR SUFFICIENT STORAGE FOR U                                   SD 518
        IF (IU(N+1)-1 .GT. UMAX)  GO TO 107                               SD 519
C                                                                         SD 520
C----INITIALIZATION                                                       SD 521
        DO 1 K=1,N                                                        SD 522
          D(K) = 0                                                        SD 523
   1      JL(K) = 0                                                       SD 524
C                                                                         SD 525
C----FOR EACH ROW K                                                       SD 526
        DO 11 K=1,N                                                       SD 527
C                                                                         SD 528
C------INITIALIZE K-TH ROW WITH ELEMENTS NONZERO IN ROW P(K) OF M         SD 529
   3      JMIN = IA(P(K))                                                 SD 530
          JMAX = IA(P(K)+1) - 1                                           SD 531
          IF (JMIN.GT.JMAX) GO TO 5                                       SD 532
          DO 4 J=JMIN,JMAX                                                SD 533
            VJ = IP(JA(J))                                                SD 534
            IF (K.LE.VJ)  D(VJ) = A(J)                                    SD 535
   4        CONTINUE                                                      SD 536
C                                                                         SD 537
C------MODIFY K-TH ROW BY ADDING IN THOSE ROWS I WITH U(I,K) NE 0         SD 538
C------FOR EACH ROW I TO BE ADDED IN                                      SD 539
   5      DK = D(K)                                                       SD 540
          I = JL(K)                                                       SD 541
   6      IF (I.EQ.0)  GO TO 9                                            SD 542
            NEXTI = JL(I)                                                 SD 543
C                                                                         SD 544
C--------COMPUTE MULTIPLIER AND UPDATE DIAGONAL ELEMENT                   SD 545
            ILI = IL(I)                                                   SD 546
            UKIDI = - U(ILI) * D(I)                                       SD 547
            DK = DK + UKIDI * U(ILI)                                      SD 548
            U(ILI) = UKIDI                                                SD 549
C                                                                         SD 550
C--------ADD MULTIPLE OF ROW I TO K-TH ROW ...                            SD 551
            JMIN = ILI     + 1                                            SD 552
            JMAX = IU(I+1) - 1                                            SD 553
            IF (JMIN.GT.JMAX)  GO TO 8                                    SD 554
              MU = IJU(I) - IU(I)                                         SD 555
              DO 7 J=JMIN,JMAX                                            SD 556
   7            D(JU(MU+J)) = D(JU(MU+J)) + UKIDI * U(J)                  SD 557
C                                                                         SD 558
C--------... AND ADD I TO ROW LIST FOR NEXT NONZERO ENTRY                 SD 559
              IL(I) = JMIN                                                SD 560
              J = JU(MU+JMIN)                                             SD 561
              JL(I) = JL(J)                                               SD 562
              JL(J) = I                                                   SD 563
C                                                                         SD 564
   8        I = NEXTI                                                     SD 565
            GO TO 6                                                       SD 566
C                                                                         SD 567
C------CHECK FOR ZERO PIVOT AND SAVE DIAGONAL ELEMENT                     SD 568
   9      IF (DK.EQ.0)  GO TO 108                                         SD 569
          D(K) = 1 / DK                                                   SD 570
C                                                                         SD 571
C------SAVE NONZERO ENTRIES IN K-TH ROW OF U ...                          SD 572
          JMIN = IU(K)                                                    SD 573
          JMAX = IU(K+1) - 1                                              SD 574
          IF (JMIN.GT.JMAX)  GO TO 11                                     SD 575
            MU = IJU(K) - JMIN                                            SD 576
            DO 10 J=JMIN,JMAX                                             SD 577
              JUMUJ = JU(MU+J)                                            SD 578
              U(J) = D(JUMUJ)                                             SD 579
  10          D(JUMUJ) = 0                                                SD 580
C                                                                         SD 581
C------... AND ADD K TO ROW LIST FOR FIRST NONZERO ENTRY IN K-TH ROW      SD 582
            IL(K) = JMIN                                                  SD 583
            I = JU(MU+JMIN)                                               SD 584
            JL(K) = JL(I)                                                 SD 585
            JL(I) = K                                                     SD 586
  11      CONTINUE                                                        SD 587
C                                                                         SD 588
        FLAG = 0                                                          SD 589
        RETURN                                                            SD 590
C                                                                         SD 591
C ** ERROR -- INSUFFICIENT STORAGE FOR U                                  SD 592
 107    FLAG = 7*N + 1                                                    SD 593
        RETURN                                                            SD 594
C ** ERROR -- ZERO PIVOT                                                  SD 595
 108    FLAG = 8*N + K                                                    SD 596
        RETURN                                                            SD 597
        END                                                               SD 598
