        SUBROUTINE  SRO
     *     (N, IP, IA,JA,A, Q, R, DFLAG)                                  OD 603
C                                                                         OD 604
C  DESCRIPTION                                                            OD 605
C                                                                         OD 606
C    THE NONZERO ENTRIES OF THE MATRIX M ARE ASSUMED TO BE STORED         OD 607
C    SYMMETRICALLY IN (IA,JA,A) FORMAT (I.E., NOT BOTH M(I,J) AND M(J,I)  OD 608
C    ARE STORED IF I NE J).                                               OD 609
C                                                                         OD 610
C    SRO DOES NOT REARRANGE THE ORDER OF THE ROWS, BUT DOES MOVE          OD 611
C    NONZEROES FROM ONE ROW TO ANOTHER TO ENSURE THAT IF M(I,J) WILL BE   OD 612
C    IN THE UPPER TRIANGLE OF M WITH RESPECT TO THE NEW ORDERING, THEN    OD 613
C    M(I,J) IS STORED IN ROW I (AND THUS M(J,I) IS NOT STORED);  WHEREAS  OD 614
C    IF M(I,J) WILL BE IN THE STRICT LOWER TRIANGLE OF M, THEN M(J,I) IS  OD 615
C    STORED IN ROW J (AND THUS M(I,J) IS NOT STORED).                     OD 616
C                                                                         OD 617
C                                                                         OD 618
C  ADDITIONAL PARAMETERS                                                  OD 619
C                                                                         OD 620
C    Q     - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           OD 621
C                                                                         OD 622
C    R     - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = NUMBER OF   OD 623
C            NONZERO ENTRIES IN THE UPPER TRIANGLE OF M                   OD 624
C                                                                         OD 625
C    DFLAG - LOGICAL VARIABLE;  IF DFLAG = .TRUE., THEN STORE NONZERO     OD 626
C            DIAGONAL ELEMENTS AT THE BEGINNING OF THE ROW                OD 627
C                                                                         OD 628
C-----------------------------------------------------------------------  OD 629
C                                                                         OD 630
        INTEGER  IP(1),  IA(1), JA(1),  Q(1), R(1)                        OD 631
C       REAL  A(1),  AK                                                   OD 632
        DOUBLE PRECISION  A(1),  AK                                       OD 633
        LOGICAL  DFLAG                                                    OD 634
C                                                                         OD 635
C                                                                         OD 636
C--PHASE 1 -- FIND ROW IN WHICH TO STORE EACH NONZERO                     OD 637
C----INITIALIZE COUNT OF NONZEROES TO BE STORED IN EACH ROW               OD 638
        DO 1 I=1,N                                                        OD 639
  1       Q(I) = 0                                                        OD 640
C                                                                         OD 641
C----FOR EACH NONZERO ELEMENT A(J)                                        OD 642
        DO 3 I=1,N                                                        OD 643
          JMIN = IA(I)                                                    OD 644
          JMAX = IA(I+1) - 1                                              OD 645
          IF (JMIN.GT.JMAX)  GO TO 3                                      OD 646
          DO 2 J=JMIN,JMAX                                                OD 647
C                                                                         OD 648
C--------FIND ROW (=R(J)) AND COLUMN (=JA(J)) IN WHICH TO STORE A(J) ...  OD 649
            K = JA(J)                                                     OD 650
            IF (IP(K).LT.IP(I))  JA(J) = I                                OD 651
            IF (IP(K).GE.IP(I))  K = I                                    OD 652
            R(J) = K                                                      OD 653
C                                                                         OD 654
C--------... AND INCREMENT COUNT OF NONZEROES (=Q(R(J)) IN THAT ROW       OD 655
  2         Q(K) = Q(K) + 1                                               OD 656
  3       CONTINUE                                                        OD 657
C                                                                         OD 658
C                                                                         OD 659
C--PHASE 2 -- FIND NEW IA AND PERMUTATION TO APPLY TO (JA,A)              OD 660
C----DETERMINE POINTERS TO DELIMIT ROWS IN PERMUTED (JA,A)                OD 661
        DO 4 I=1,N                                                        OD 662
          IA(I+1) = IA(I) + Q(I)                                          OD 663
  4       Q(I) = IA(I+1)                                                  OD 664
C                                                                         OD 665
C----DETERMINE WHERE EACH (JA(J),A(J)) IS STORED IN PERMUTED (JA,A)       OD 666
C----FOR EACH NONZERO ELEMENT (IN REVERSE ORDER)                          OD 667
        ILAST = 0                                                         OD 668
        JMIN = IA(1)                                                      OD 669
        JMAX = IA(N+1) - 1                                                OD 670
        J = JMAX                                                          OD 671
        DO 6 JDUMMY=JMIN,JMAX                                             OD 672
          I = R(J)                                                        OD 673
          IF (.NOT.DFLAG .OR. JA(J).NE.I .OR. I.EQ.ILAST)  GO TO 5        OD 674
C                                                                         OD 675
C------IF DFLAG, THEN PUT DIAGONAL NONZERO AT BEGINNING OF ROW            OD 676
            R(J) = IA(I)                                                  OD 677
            ILAST = I                                                     OD 678
            GO TO 6                                                       OD 679
C                                                                         OD 680
C------PUT (OFF-DIAGONAL) NONZERO IN LAST UNUSED LOCATION IN ROW          OD 681
  5         Q(I) = Q(I) - 1                                               OD 682
            R(J) = Q(I)                                                   OD 683
C                                                                         OD 684
  6       J = J-1                                                         OD 685
C                                                                         OD 686
C                                                                         OD 687
C--PHASE 3 -- PERMUTE (JA,A) TO UPPER TRIANGULAR FORM (WRT NEW ORDERING)  OD 688
        DO 8 J=JMIN,JMAX                                                  OD 689
  7       IF (R(J).EQ.J)  GO TO 8                                         OD 690
            K = R(J)                                                      OD 691
            R(J) = R(K)                                                   OD 692
            R(K) = K                                                      OD 693
            JAK = JA(K)                                                   OD 694
            JA(K) = JA(J)                                                 OD 695
            JA(J) = JAK                                                   OD 696
            AK = A(K)                                                     OD 697
            A(K) = A(J)                                                   OD 698
            A(J) = AK                                                     OD 699
            GO TO 7                                                       OD 700
  8       CONTINUE                                                        OD 701
C                                                                         OD 702
        RETURN                                                            OD 703
        END                                                               OD 704
