        SUBROUTINE  TRK
     *     (N, R,IC, IA,JA,A, Z, B, IJU,JU,IU,U,MAX,                      TD 304
     *      Q, IM, ROW, TMP, FLAG, ESP, LRATIO)                           TD 305
C                                                                         TD 306
C       INPUT VARIABLES:   N, R,IC, IA,JA,A, B, MAX, LRATIO               TD 307
C       OUTPUT VARIABLES:  Z, FLAG, ESP                                   TD 308
C                                                                         TD 309
C       PARAMETERS USED INTERNALLY:                                       TD 310
C NIA   \ Q     - SUPPOSE M' IS THE RESULT OF REORDERING M;  IF           TD 311
C       \           PROCESSING OF THE KTH ROW OF M' (HENCE THE KTH ROWS   TD 312
C       \           OF L AND U) IS BEING DONE, THEN Q(J) IS INITIALLY     TD 313
C       \           NONZERO IF M'(K,J) IS NONZERO;  SINCE VALUES NEED     TD 314
C       \           NOT BE STORED, EACH ENTRY POINTS TO THE NEXT          TD 315
C       \           NONZERO;  FOR EXAMPLE, IF  N=9  AND THE 5TH ROW OF    TD 316
C       \           M' IS                                                 TD 317
C       \                   0 X X 0 X 0 0 X 0,                            TD 318
C       \           THEN Q WILL INITIALLY BE                              TD 319
C       \                   A 3 5 A 8 A A 10 A 2        (A - ARBITRARY);  TD 320
C       \           Q(N+1) POINTS TO THE FIRST NONZERO IN THE ROW AND     TD 321
C       \           THE LAST NONZERO POINTS TO  N+1;  AS THE ALGORITHM    TD 322
C       \           PROCEEDS, OTHER ELEMENTS OF Q ARE INSERTED IN THE     TD 323
C       \           LIST BECAUSE OF FILLIN.                               TD 324
C       \           SIZE = N+1.                                           TD 325
C NIA   \ IM  - AT EACH STEP IN THE FACTORIZATION, IM(I) IS THE LAST      TD 326
C       \         ELEMENT OF THE ITH ROW OF U WHICH NEEDS TO BE           TD 327
C       \         CONSIDERED IN COMPUTING FILLIN.                         TD 328
C       \         SIZE = N.                                               TD 329
C FIA   \ ROW - HOLDS INTERMEDIATE VALUES IN CALCULATION OF U.            TD 330
C       \         SIZE = N.                                               TD 331
C FIA   \ TMP - HOLDS NEW RIGHT-HAND SIDE B' FOR SOLUTION OF THE          TD 332
C       \         EQUATION  UX = B'.                                      TD 333
C       \         SIZE = N.                                               TD 334
C                                                                         TD 335
        INTEGER  R(1), IC(1),  IA(1), JA(1),  IJU(1), JU(1), IU(1),       TD 336
     *     Q(1),  IM(1),  FLAG,  ESP,  VJ, QM                             TD 337
C       REAL  A(1), Z(1), B(1),  U(1),  ROW(1), TMP(1), SUM, AKI, DK      TD 338
        DOUBLE PRECISION  A(1),Z(1),B(1),U(1),ROW(1),TMP(1),SUM,AKI,DK    TD 339
C                                                                         TD 340
C  ******  INITIALIZE  *************************************************  TD 341
        JUMIN = 1                                                         TD 342
        JUMAX = 0                                                         TD 343
        IU(1) = MAX                                                       TD 344
C                                                                         TD 345
C  ******  FOR EACH ROW  ***********************************************  TD 346
        DO 20 K=1,N                                                       TD 347
C  ******  INITIALIZE Q AND ROW TO THE KTH ROW OF REORDERED A  *********  TD 348
          LUK = 0                                                         TD 349
          Q(N+1) = N+1                                                    TD 350
          JMIN = IA(R(K))                                                 TD 351
          JMAX = IA(R(K)+1) - 1                                           TD 352
          IF (JMIN.GT.JMAX)  GO TO 101                                    TD 353
          DO 2 J=JMIN,JMAX                                                TD 354
            VJ = IC(JA(J))                                                TD 355
            QM = N+1                                                      TD 356
   1        M = QM                                                        TD 357
            QM = Q(M)                                                     TD 358
            IF (QM.LT.VJ)  GO TO 1                                        TD 359
            IF (QM.EQ.VJ)  GO TO 102                                      TD 360
              LUK = LUK+1                                                 TD 361
              Q(M) = VJ                                                   TD 362
              Q(VJ) = QM                                                  TD 363
              ROW(VJ) = A(J)                                              TD 364
   2        CONTINUE                                                      TD 365
C                                                                         TD 366
C  ******  LINK THROUGH Q  *********************************************  TD 367
          LMAX = 0                                                        TD 368
          IJU(K) = JUMAX                                                  TD 369
          I = N+1                                                         TD 370
   3      I = Q(I)                                                        TD 371
          LUK = LUK-1                                                     TD 372
          IF (I.GE.K)  GO TO 8                                            TD 373
            QM = I                                                        TD 374
            LUI = 0                                                       TD 375
            JMIN = IJU(I)                                                 TD 376
            JMAX = IM(I)                                                  TD 377
            IF (JMIN.GT.JMAX)  GO TO 7                                    TD 378
C  ******  AND FIND NONZERO STRUCTURE OF KTH ROW OF L AND U  ***********  TD 379
              DO 5 J=JMIN,JMAX                                            TD 380
                VJ = JU(J)                                                TD 381
                IF (VJ.GT.K)  LUI = LUI+1                                 TD 382
   4            M = QM                                                    TD 383
                QM = Q(M)                                                 TD 384
                IF (QM.LT.VJ)  GO TO 4                                    TD 385
                IF (QM.EQ.VJ)  GO TO 5                                    TD 386
                  LUK = LUK+1                                             TD 387
                  Q(M) = VJ                                               TD 388
                  Q(VJ) = QM                                              TD 389
                  ROW(VJ) = 0                                             TD 390
                  QM = VJ                                                 TD 391
   5            CONTINUE                                                  TD 392
C  ******  ADJUST IJU AND IM  ******************************************  TD 393
              JTMP = JMAX - LUI                                           TD 394
              IF (LUI.LE.LMAX)  GO TO 6                                   TD 395
                LMAX = LUI                                                TD 396
                IJU(K) = JTMP+1                                           TD 397
   6          IF (JTMP.LT.JMIN)  GO TO 7                                  TD 398
                IF (JU(JTMP).EQ.K)  IM(I) = JTMP                          TD 399
   7        GO TO 3                                                       TD 400
C                                                                         TD 401
C  ******  SEE IF JU STORAGE CAN BE COMPRESSED  ************************  TD 402
   8      IF (I.NE.K)  GO TO 105                                          TD 403
          IF (LUK.EQ.LMAX)  GO TO 14                                      TD 404
            I = Q(K)                                                      TD 405
            IF (JUMIN.GT.JUMAX)  GO TO 12                                 TD 406
              DO 9 JMIN=JUMIN,JUMAX                                       TD 407
                IF (JU(JMIN)-I)  9, 10, 12                                TD 408
   9            CONTINUE                                                  TD 409
              GO TO 12                                                    TD 410
  10          IJU(K) = JMIN                                               TD 411
              DO 11 J=JMIN,JUMAX                                          TD 412
                IF (JU(J).NE.I)  GO TO 12                                 TD 413
                I = Q(I)                                                  TD 414
                IF (I.GT.N)  GO TO 14                                     TD 415
  11            CONTINUE                                                  TD 416
              JUMAX = JMIN - 1                                            TD 417
C  ******  STORE POINTERS IN JU  ***************************************  TD 418
  12        I = K                                                         TD 419
            JUMIN = JUMAX +  1                                            TD 420
            JUMAX = JUMAX + LUK                                           TD 421
            IF (JUMAX.GT.LRATIO*(IU(K)-1)+1)  GO TO 112                   TD 422
            DO 13 J=JUMIN,JUMAX                                           TD 423
              I = Q(I)                                                    TD 424
  13          JU(J) = I                                                   TD 425
            IJU(K) = JUMIN                                                TD 426
  14      IU(K+1) = IU(K) - LUK                                           TD 427
          IF (JUMAX.GT.LRATIO*(IU(K+1)-1)+1)  GO TO 112                   TD 428
          IM(K) = IJU(K) + LUK - 1                                        TD 429
C                                                                         TD 430
C  ******  CALCULATE NUMERICAL VALUES FOR KTH ROW  *********************  TD 431
          SUM = B(R(K))                                                   TD 432
          I = N+1                                                         TD 433
  15      I = Q(I)                                                        TD 434
          IF (I.GE.K)  GO TO 18                                           TD 435
            AKI = - ROW(I)                                                TD 436
            SUM = SUM + AKI * TMP(I)                                      TD 437
            JMIN = IU(I+1) + 1                                            TD 438
            JMAX = IU(I)                                                  TD 439
            IF (JMIN.GT.JMAX)  GO TO 17                                   TD 440
            MU = IJU(I) - JMIN                                            TD 441
            DO 16 J=JMIN,JMAX                                             TD 442
  16          ROW(JU(MU+J)) = ROW(JU(MU+J)) + AKI * U(J)                  TD 443
  17        GO TO 15                                                      TD 444
C  ******  STORE VALUES IN TMP AND U  **********************************  TD 445
  18      IF (ROW(K).EQ.0)  GO TO 108                                     TD 446
          DK = 1 / ROW(K)                                                 TD 447
          TMP(K) = SUM * DK                                               TD 448
          JMIN = IU(K+1) + 1                                              TD 449
          JMAX = IU(K)                                                    TD 450
          IF (JMIN.GT.JMAX)  GO TO 20                                     TD 451
          MU = IJU(K) - JMIN                                              TD 452
          DO 19 J=JMIN,JMAX                                               TD 453
  19        U(J) = ROW(JU(MU+J)) * DK                                     TD 454
  20      CONTINUE                                                        TD 455
C                                                                         TD 456
C  ******  SOLVE  UX = TMP  BY BACK SUBSTITUTION  **********************  TD 457
        K = N                                                             TD 458
        DO 23 I=1,N                                                       TD 459
          SUM = TMP(K)                                                    TD 460
          JMIN = IU(K+1) + 1                                              TD 461
          JMAX = IU(K)                                                    TD 462
          IF (JMIN.GT.JMAX)  GO TO 22                                     TD 463
          MU = IJU(K) - JMIN                                              TD 464
          DO 21 J=JMIN,JMAX                                               TD 465
  21        SUM = SUM - U(J) * TMP(JU(MU+J))                              TD 466
  22      TMP(K) = SUM                                                    TD 467
  23      K = K-1                                                         TD 468
        DO 24 K=1,N                                                       TD 469
  24      Z(K) = TMP(IC(K))                                               TD 470
C                                                                         TD 471
        FLAG = 0                                                          TD 472
        ESP = IU(N+1) - 1 - (JUMAX - 1)/LRATIO                            TD 473
        RETURN                                                            TD 474
C                                                                         TD 475
C ** ERROR:  NULL ROW IN A                                                TD 476
 101    FLAG = N + R(K)                                                   TD 477
        RETURN                                                            TD 478
C ** ERROR:  DUPLICATE ENTRY IN A                                         TD 479
 102    FLAG = 2*N + R(K)                                                 TD 480
        RETURN                                                            TD 481
C ** ERROR:  NULL PIVOT                                                   TD 482
 105    FLAG = 5*N + K                                                    TD 483
        RETURN                                                            TD 484
C ** ERROR:  ZERO PIVOT                                                   TD 485
 108    FLAG = 8*N + K                                                    TD 486
        RETURN                                                            TD 487
C ** ERROR:  INSUFFICIENT STORAGE FOR JU AND U                            TD 488
 112    FLAG = 12*N + K                                                   TD 489
        RETURN                                                            TD 490
        END                                                               TD 491
