/* Copyright 1988 John M. Sullivan.  See main program for details. */
/* Typedef for queue--we keep head,tail pointers, add to tail */

#define def_q(type)		\
typedef				\
struct CONCAT(type,_q_entry)	\
{				\
    struct CONCAT(type,_q_entry) *next;		\
    type data;			\
}				\
* CONCAT(type,_q_entry);	\
				\
struct CONCAT(q_of_,type)	\
{				\
    CONCAT(type,_q_entry) head;\
    CONCAT(type,_q_entry) tail;\
} ;

/* make q empty */
#define empty(q) (q.head = q.tail = NULL)

/* test if q is non-empty */
#define non_empty(q) (q.head)

/* dequeue an item into f */
#define deq(q,f,type) {				\
		    register CONCAT(type,_q_entry) _q_;		\
		    if (_q_ = q.head)		\
		    {				\
			f = _q_->data;		\
			q.head = _q_->next;	\
			if (!q.head) q.tail=0;	\
			mem_free(_q_);		\
		    }				\
		    else			\
			f = NULL;		\
		 }

/* put item onto q */
#define enq(q,f,type) (q.tail = (non_empty(q)?	\
	(q.tail->next=mem_alloc(1,CONCAT(type,_q_entry))) \
	: (q.head = mem_alloc(1,CONCAT(type,_q_entry)))),  \
			q.tail->next = NULL, q.tail->data = f)

/* put item in middle */
#define enq_after(q,qe,new,type) {		\
		register CONCAT(type,_q_entry) _q_;		\
		_q_ = mem_alloc(1,CONCAT(type,_q_entry));	\
		_q_->data = new;		\
		_q_->next = qe->next;		\
		qe->next = _q_;			\
		if (q.tail == qe) q.tail = _q_;	\
		}
