/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "standard.h"
string Progname;
#ifdef DEBUG
int Debug_Level=0;
#endif

error(va_alist)
va_dcl
{
	va_list ap;
	string fmt;

	va_start(ap);
	if (fmt = va_arg(ap, string))
		(void) fprintf(stderr, "%s: Error: ", Progname);
	else
		fmt = va_arg(ap, string);

	(void) _doprnt(fmt, ap, stderr);
	va_end(ap);

	(void) fprintf(stderr, "\n");

	exit(1);
}

/*VARARGS*/
warning(va_alist)
va_dcl
{
	va_list ap;
	string fmt;

	va_start(ap);
	if (fmt = va_arg(ap, string))
		(void) fprintf(stderr, "%s: Warning: ", Progname);
	else
		fmt = va_arg(ap, string);

	(void) _doprnt(fmt, ap, stderr);
	va_end(ap);

	(void) fprintf(stderr, "\n");
}

char *
myalloc(n)
int n;
{
    register char * new;
    if (!(new = malloc((unsigned)n)))
	error("Out of memory");
    return new;
}

int Flag('z'+1);

handle_flags(argcp,argvp,flagset)
string *argvp[];
int *argcp;
string flagset;
{
    string arg,set;
    char f;

    Progname = **argvp;
    for(set=flagset; *set; set++)
    {
	if (*set < 'a' || *set > 'z')
	    error("Can't search for flag '%c'",*set);
	Flag(*set) = FALSE;
    }
    while (--*argcp && (*++*argvp)[0] == '-' && *(arg=(**argvp)+1))
    {
	while(f = *arg++)
	{
	    for(set=flagset; *set; set++)
		if (f == *set)
		    break;
	    if (!*set)
		error("Unknown flag '-%c'",f);
	    if (isdigit(*arg))
		Flag(f) = strtol(arg,&arg,10);
	    else
		--Flag(f);
	}
    }
}
