/* $Id: confirmer.c,v 2.3 89/09/20 17:01:24 mbp Exp $
 *
 * confirmer.c: confirmer procedures
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include <stdio.h>
#include "gr.h"
#include "internal.h"

#define STANDARD_MESSAGE_MAX_LENGTH 29
#define STANDARD_PANEL_WIDTH 290
#define STANDARD_PANEL_HEIGHT 77
#define STANDARD_MESSAGE_X 44
#define STANDARD_MESSAGE_Y 16

Frame			GR_confirmer_frame;
Panel			GR_confirmer_panel;
static Panel_item	confirmer_message;
static Panel_item	yes_image, yes_word, no_image, no_word;

static Cursor confirmer_cursor;

static void confirmer_event_proc();

static short confirmer_array[] = {
#include "images/confirmer.image"
};
mpr_static(confirmer_pr, 16, 16, 1, confirmer_array);

/*-----------------------------------------------------------------------
 * Function:	GR_initialize_confirmer
 * Description:	initialize the confirmer window
 * Args:	(none)
 * Notes:	Does not display anything - just sets things up
 */
int
GR_initialize_confirmer()
{
  confirmer_cursor =
    cursor_create(CURSOR_IMAGE, &confirmer_pr, 0);

  GR_confirmer_frame =
    window_create(GR_base_frame, FRAME,
		  FRAME_SHOW_LABEL, FALSE,
		  WIN_SHOW, FALSE,
		  WIN_CURSOR, confirmer_cursor,
		  0);
  if (GR_confirmer_frame == NULL) return(1);
  
  GR_confirmer_panel =
    window_create(GR_confirmer_frame, PANEL,
		  WIN_X, 0,
		  WIN_Y, 0,
		  WIN_WIDTH, STANDARD_PANEL_WIDTH,
		  WIN_HEIGHT, STANDARD_PANEL_HEIGHT,
		  WIN_FONT, GR_bold_font,
		  PANEL_BACKGROUND_PROC, confirmer_event_proc,
		  PANEL_EVENT_PROC, confirmer_event_proc,
		  WIN_CURSOR, confirmer_cursor,
		  0);
  if (GR_confirmer_panel == NULL) return(1);
  
  confirmer_message =
    panel_create_item(GR_confirmer_panel, PANEL_MESSAGE, 
		      PANEL_ITEM_X, STANDARD_MESSAGE_X,
		      PANEL_ITEM_Y, STANDARD_MESSAGE_Y,
		      PANEL_LABEL_STRING, "",
		      0);
  
  yes_image =
    panel_create_item(GR_confirmer_panel, PANEL_MESSAGE, 
			  PANEL_ITEM_X, 62,
			  PANEL_ITEM_Y, 49,
			  PANEL_LABEL_IMAGE, GR_mouse_image_pr_ptr(0),
			  0);

  yes_word =
    panel_create_item(GR_confirmer_panel, PANEL_MESSAGE, 
			  PANEL_ITEM_X, 80,
			  PANEL_ITEM_Y, 49,
			  PANEL_LABEL_STRING, "Yes",
			  0);
  
  no_image =
    panel_create_item(GR_confirmer_panel, PANEL_MESSAGE, 
			  PANEL_ITEM_X, 192,
			  PANEL_ITEM_Y, 49,
			  PANEL_LABEL_IMAGE, GR_mouse_image_pr_ptr(2),
			  0);

  no_word =
    panel_create_item(GR_confirmer_panel, PANEL_MESSAGE, 
			  PANEL_ITEM_X, 210,
			  PANEL_ITEM_Y, 49,
			  PANEL_LABEL_STRING, "No",
			  0);

  standardize_confirmer();
  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	GR_user_confirm
 * Description:	display message in confirmer panel and get response
 * 		from user
 * Args  IN:	s: message to be displayed
 * Returns:	1 for YES, 0 for NO
 * Notes:	This procedure blocks.
 *
 *    original version is is confirm.orig during testing of this version
 */
int
GR_user_confirm(s)
char *s;
{
  int answer, msglen, width;
  struct pr_subregion bound;
  Cursor cursor;

  /* Write message centered in confirmer frame, and resize if necessary */
  msglen = strlen(s);
  pf_textbound(&bound, msglen, GR_bold_font, s);
  if (msglen > STANDARD_MESSAGE_MAX_LENGTH) {
    /* message is too long for standard size, so resize the panel */
    width = bound.size.x + 20;
    window_set(GR_confirmer_panel,
	       WIN_WIDTH, width,
	       WIN_HEIGHT, STANDARD_PANEL_HEIGHT,
	       0);
    panel_set(confirmer_message,
	      PANEL_ITEM_X, 10,
	      PANEL_LABEL_STRING, s,
	      0);
    set_yes_no_position();
    window_fit(GR_confirmer_frame);
  }
  else {
    /* message will fit in standard confirmer size; so center it */
    panel_set(confirmer_message,
	      PANEL_ITEM_X, (STANDARD_PANEL_WIDTH-bound.size.x)/2,
	      PANEL_LABEL_STRING, s,
	      0);
  }
  center_window(GR_confirmer_frame, 0, 0, GR_base_frame);

  /* Beep and get user's answer */
  GR_hold_error_message(1);
  window_bell(GR_base_frame);
  answer = (int)window_loop(GR_confirmer_frame);

  /* Return confirmer window to standard size, in case it was resized */
  standardize_confirmer();

  return(answer);
}

/*-----------------------------------------------------------------------
 * Function:	confirmer_event_proc
 * Description:	process an event which happened while waiting for user's
 *		  answer
 * Args  IN:	item: the item which received the event
 *		*event: the event
 */
static void
confirmer_event_proc( item, event )
Panel_item item;
Event *event;
{
  switch (event_id(event)) {
  case MS_LEFT:
    window_return(1);
    break;
  case MS_RIGHT:
    window_return(0);
    break;
  default:
    break;
  }
}

/*-----------------------------------------------------------------------
 * Function:	center_window
 * Description:	center one window wrt another
 * Args  IN:	inner_window: handle of "inner" window
 *		x_offset, y_offset: added to x,y coords of centered window
 *		outer_window: handle of "outer" window
 * Notes:	This calls window_set to reset the WIN_X,WIN_Y attributes
 *		of the inner window.
 */
static int
center_window(inner_window, x_offset, y_offset, outer_window )
Window inner_window, outer_window;
int x_offset, y_offset;
{
  int inner_w, inner_h, outer_w, outer_h;
  int inner_x, inner_y;

  inner_w = (int) window_get( inner_window, WIN_WIDTH );
  inner_h = (int) window_get( inner_window, WIN_HEIGHT );
  outer_w = (int) window_get( outer_window, WIN_WIDTH );
  outer_h = (int) window_get( outer_window, WIN_HEIGHT );
  inner_x = x_offset + (outer_w - inner_w) / 2;
  inner_y = y_offset + (outer_h - inner_h) / 2;
  window_set( inner_window, WIN_X, inner_x, WIN_Y, inner_y, 0 );
}

/*-----------------------------------------------------------------------
 * Function:	set_yes_no_position
 * Description:	Set the horizontal positions of the "yes" and "no"
 *		  images in the confirmer panel
 * Args:	(none)
 * Notes:	These are set to about 1/3 (for "yes") and 2/3 (for "no")
 *		of the width of the panel.
 */
static int
set_yes_no_position()
{
  int width, yes_x, no_x;

  width = (int)window_get(GR_confirmer_panel, WIN_WIDTH);
  yes_x = (width-60)/3;
  no_x = 2*yes_x + 30;

  panel_set(yes_image, PANEL_LABEL_X, yes_x, 0);
  panel_set(yes_word, PANEL_LABEL_X, yes_x+26, 0);
  panel_set(no_image, PANEL_LABEL_X, no_x, 0);
  panel_set(no_word, PANEL_LABEL_X, no_x+26, 0);
}

/*-----------------------------------------------------------------------
 * Function:	standardize_confirmer
 * Description:	reset the sizes of the confirmer panel and window
 *		  to their initial ("standard") size.
 * Args:	(none)
 */
static int
standardize_confirmer()
{
  window_set(GR_confirmer_panel, WIN_WIDTH, STANDARD_PANEL_WIDTH, 0);
  window_set(GR_confirmer_panel, WIN_HEIGHT, STANDARD_PANEL_HEIGHT, 0);
  panel_set(confirmer_message, PANEL_ITEM_X, STANDARD_MESSAGE_X, 0);
  panel_set(confirmer_message, PANEL_ITEM_Y, STANDARD_MESSAGE_Y, 0);
  set_yes_no_position();
  window_fit(GR_confirmer_frame);
}

