./" $Id: viewwld.tpl,v 1.7 89/09/20 18:27:56 mbp Exp $
./"
./" viewwld.man: manual page for viewwld
./"
./" by Mark B. Phillips
./" 
./" BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
./" 
./" This is a "template" for the viewwld manual page.  Before
./" formatting to make the actual manual page, this file should be
./" edited to change the following strings to whatever is
./" appropriate:
./" 
./" MANSECTION_VALUE:
./"	extension (section numer) for man page
./" SAMPLEDIR_VALUE:
./"	directory containing sample files house.vec and lorenz.vec
./" HELPDIR_VALUE:
./"	directory containing help file viewwld.help
./" PSDIR_VALUE:
./"	directory containing PostScript files gr_header.ps and
./"   gr_trailer.ps.
./"
./" This can be done with a sed command, and is normally done by the
./" viewwld makefile during installation, or by the explicit command
./" 'make viewwld.<n>', where <n> is the number you give for MANEXT in
./" the Makefile.
./" 
./" EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
.TH VIEWWLD MANSECTION_VALUE "September 13, 1989"
.SH NAME
viewwld - view a 3-dimensional world of vectors
.SH SYNOPSIS
.nf
viewwld [-o ofile] [-x x1 x2] [-y y1 y2] [-z z1 z2] file
.SH DESCRIPTION
.LP
.I Viewwld
(pronounced "view world") is a program for viewing 3-dimensional line
drawings, or "worlds" of line segments and points.
.I file
may be either an ascii input file or a "world" file written by a
previous invocation of
.I viewwld
with the -o option (See the
.B OPTIONS
section below.)

If
.I file
is an ascii input file, it should contain a world description
consisting lines of the form
.sp
.nf
.in +2
x y z m
.in -2
.sp
.fi
(x,y,z) are the coordinates of a point in 3-space (these can be
integers or floating point numbers in either decimal or scientific
notation). m is either 0, 1, or 2, and it determines what is done with
(x,y,z).  m=0 means "move" to the point (x,y,z) without drawing a line,
m=1 means draw a line from the last point to (x,y,z), and m=2 means
draw a point (a dot) at (x,y,z).  (In all three cases the current point
is left at (x,y,z).)  The four numbers on the line should be separated
from each other by spaces, tabs, or commas.  The first line of the file
should not have m=1.  Blank lines in the file are ignored.  Comments
may be introduced with the '%' character;
.I viewwld
ignores everything between '%' and the end of the line.  Except for
comments and blank lines, each line of the file should contain exactly
4 numbers.

Before displaying the world, 
.I viewwld
makes a pass through
.I file
to determine the coordinate system.  It uses a coordinate system that
is approximately 10% larger than the range spanned by the data in the
file.  (You can override this choice of coordinate system with the -x,
-y, and -z options; see the
.B OPTIONS
section below.)

If
.I file
is a world file previously created with the -o option, rather than an
ascii file, 
.I viewwld
simply reads and displays it.  This is much faster than re-reading the
original ascii data file.

After displaying a world, 
.I viewwld
allows you to view it from various
angles interactively.  This is done by pressing buttons in its view
control panel.  To get more information about how to do this, press the
"Help" button in the upper right corner of the frame (this is the
button with the large question mark on it).

.I Viewwld
also has a menu which allows you to do such things as toggle
the bounding box on or off and re-read or write a file.  The menu is
available via the right mouse button with the cursor over the drawing
canvas.  The "Help" button gives further documentation.

.SH OPTIONS
.TP 1i
.B -o ofile
Write, with name
.I ofile,
a file containing a "compiled" version of the world.  This file can be
given to later invocations of viewwld as the input file.
.TP
.B -x x1 x2
specify the x (first coordinate) limits of the coordinate system used
in creating the picture.  
.I x1
is the lower limit, and
.I x2
is the upper limit.
.TP
.B -y y1 y2
specify the y (second coordinate) limits of the coordinate system used
in creating the picture.  
.I y1
is the lower limit, and
.I y2
is the upper limit.
.TP
.B -z z1 z2
specify the z (third coordinate) limits of the coordinate system used
in creating the picture.  
.I z1
is the lower limit, and
.I z2
is the upper limit.

.SH NOTES

Any combination of the -x, -y, and -z options may be used; for each
of these options which is not present, 
.I viewwld
chooses the range for
the corresponding coordinate to be approximately 10% larger than the
data in
.I file.

The -x, -y, and -z options may be used only when
.I file
is an ascii input file.  Once a world file has been created its
coordinate system cannot be changed.

World files written with the -o option contain binary data; don't try
to edit them manually.

.SH "ENVIRONMENT VARIABLES"
Upon startup, 
.I viewwld
checks to see if the following environment
variables have been defined:
.sp
.in +2
.I VIEWWLD_LIB
.br
.I GR_LIB
.br
.I GR_SPOOL
.in -2
.sp
You can alter some things about the way 
.I viewwld
works by setting these variables.

First of all, 
.I viewwld
needs access to certain files when it is run.  If the copy of
.I viewwld
which you are running was compiled on your computer, then the location
of these files should have been specified when
.I viewwld
was compiled, and you don't need to worry about them.  If you are
running a copy that was compiled elsewhere, however, you will need to
make sure you also have copies of these files, and you tell
.I viewwld
their location through environment variables.  If any of the
environment variables mentioned below has a value,
.I viewwld
takes that value to be the name of a directory, and looks for the
associated file or files in that directory before looking for them in
the "hardwired" locations.

.in +4
.ti -2
viewwld.help: 
.I Viewwld
looks for this file in the directory specified by the environment
variable VIEWWLD_LIB.
.ti -2
gr_header.ps, gr_trailer.ps: 
.I Viewwld
looks for these files in the directory specified by the environment
variable GR_LIB.
.in -4

Secondly, when printing out PostScript files, 
.I viewwld
checks to see if the environment variable GR_SPOOL has a value.  If it
does,
.I viewwld
takes that value to be a command (consisting of one or more words
separated by whitespace) which will send a PostScript file to a
printer.  The command should take one argument, which is the name of
the PostScript file to be printed.

.SH FILES
.in +2
.ti -2
SAMPLEDIR_VALUEhouse.vec: sample vector file containing a simple drawing of
a house
.ti -2
SAMPLEDIR_VALUElorenz.vec: sample vector file containing a trajectory of the
Lorenz equations
.ti -2
HELPDIR_VALUEviewwld.help: file which is displayed in "Help" window
.ti -2
PSDIR_VALUEgr_header.ps, PSDIR_VALUEgr_trailer.ps: header and trailer files for
PostScript output

.in -2

.SH "EXAMPLES"
.in +2
.ti -2
\'viewwld house.vec\'
.br
This reads and displays the ascii vector file \'house.vec\'
.ti -2
\'viewwld -o house.wld house.vec\'
.br
This reads and displays the ascii vector file 'house.vec', and writes
the world file \'house.wld\'
.ti -2
\'viewwld house.wld\'
this displays the world file 'house.wld'
.in -2

.SH DEFAULTS DATABASE
.I viewwld
reads certain parameter values from the SunView defaults database each
time it is started.  You can specify your own customized values for
these parameters in the .defaults file in your home directory.

Depending on how 
.I viewwld
is installed on your system, you may be able
to use defaultsedit(1) to specify these values.  If the category \'LGD\'
is present in the \'Category\' cycle in defaultsedit, you can use it
to customize 
.I viewwld
parameters.

If the \'LGD\' category is not present when you run defaultsedit, you
can customize 
.I viewwld
parameters by entering them in the \.defaults file in your home
directory.  For each parameter that you want to customize, simply
include a line in your .defaults file containing the name of the the
parameter followed by its value.  The parameters which you can
customize are:

.in +4
.ti -2
/LGD/RotationAngle		
.br
The initial value (0 - 360 degrees) for the \'Rotation Angle\' slider.
Default: 12.

.ti -2
/LGD/ZoomFactor		
.br
Initial value for Zoom Factor slider.  Must be one of 1.0, 1.1, 1.2,
1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, or 2.0.  Default: 1.5

.ti -2
/LGD/PerspectiveFactor	
.br
Initial value for Perspective Factor slider.  Must be one of 1.0, 1.1, 1.2,
1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, or 2.0.  Default: 1.5

.ti -2
/LGD/DrawingMode		
.br
Initial value for Drawing Mode cycle.  Must be either \'Batch\' or
\'Continuous\'.  Default: Batch.

.ti -2
/LGD/PanFactor		
.br
Factor by which rotation angle is multiplied in computing pan angle.
Can be any real number.  Default: 0.1.

.ti -2
/LGD/PointList
.br
List of pixels to draw when plotting points.  This should be a list of
pairs of integers, where each pair represents the location of a pixel
relative to the point to be plotted.  For example, 0,0 represents the
pixel at the point itself, 1,0 represents the next pixel to the right,
etc.  The integers in the list must be separated from each other by
spaces and/or commas.  The entire list, including the spaces and
commas, must be no more than 80 characters long.  Default: 0,0, 1,0,
-1,0, 0,1, 0,-1.

.in -4

.SH "BUGS AND CAVEATS"

.I Viewwld
may have trouble interpreting certain forms of scientific notation
which have been generated by FORTRAN programs.  Specifically, the
valid format for numbers in the vectfile is: an optional sign, then a
string of digits optionally containing a decimal point, then an
optional e or E followed by an optional sign or space, followed by an
integer.

.I Viewwld
performs no validity checking on the data which specify the
viewing transformation, and does not clip out points of the world
which are "behind" the eye.  Bizarre pictures can result if the eye
point is moved in front of (i.e. towards the focus point) some of the
vectors in the world.

If the data in your vectfile span a region in space in which one
dimension is several orders of magnitude smaller than another, then

.I Viewwld
may not do a good job of picking an initial viewpoint.  If the initial
picture you see when the
.I viewwld
window appears doesn't make sense, try backing off from it by clicking
the "Perspective" button several times.  This will decrease the amount
of perspective distortion in the viewing projection, and should clear
things up.  Alternately, you can force
.I viewwld
to use a more uniformly shaped range of coordinates by specifying them
explicitly via the -x, -y, and -z options.

.SH VERSION
This is version 1.6 of September 13, 1989.

.SH COMMENTS
This program is currently under development, and I welcome any
comments or suggestions about it.

.SH "Author"
Mark B. Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.sp1
Copyright (C) 1989 by Mark B. Phillips
.sp1
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Mark B. Phillips or
the University of Maryland not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.  This software is provided "as is" without express
or implied warranty.
.sp
PostScript is a trademark of Adobe System, Incorporated.
