/* copyright 1987 by Phil Andrews, Pittsburgh Supercomputing Center */
/* module for the Peritek specific functions */
/* this whole thing is very VMS specific and should only be linked under VMS */
#include stdio
#include "defs.h"
#define byte_size 8
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */

#define max_entries 2048	/* max indexed entries */
#define max_d_val 255		/* max direct colour value */
/* macro to convert from real to integer colour value */
#define int_col(r_col) ((int) ((r_col) * max_d_val + 0.49999))

/* the peritek is a relatively dumb device with no concept of states;
   it is expected to run for lang periods in an automated manner. Thus
   robustness is precedent over speed */

static int state_level;

/* grab a cgm unsigned integer at general precision */
static unsigned int cgm_guint(dat_ptr, precision)
unsigned char *dat_ptr;
int precision;
{
unsigned int  ret, no_chars;
	ret = *dat_ptr;
	for (no_chars = precision / byte_size; no_chars > 1; --no_chars) 
	    ret = (ret << byte_size) | (*++dat_ptr & 255);

	return(ret);
}
/* begin the peritek */
pk_begin(comment, file_name, prog_name)
char *comment, *file_name, *prog_name;
{
	++state_level;
	if (state_level > 0) return(1);	
/* 	vcxint(0, 0);		/* assume already initialised device */
	vcxsel(0, 0);		/* but need to map memory */
	return(1);
}
/* end the metafile */
pk_end()
{
	--state_level;
	return(1);
}
/* start a page */
pk_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no,
    xsize, ysize)
char *pic_name;
float rotation;
int xoffset, yoffset, page_no;
float rb, gb, bb;	/* background colour values */
int xsize, ysize;
{
int r, g, b, i, col_entries;

	if (pc2->c_s_mode == d_c_mode) {
	    /* fake direct colour with a simple colour_table */
	    r = int_col(rb);
	    g = int_col(gb);
	    b = int_col(bb);
	    for (i=0; i<=max_d_val; ++i) cmap(0, i, i, i, i);
	    /* now set the background colour */
	    if ((r == g) && (g == b)) {	/* all the same */
		gcntl(1, 1, 1, 0, 0);
		clrgr(r);
	    } else {
		gcntl(1, 0, 0, 0, 0);	/* red */
		clrgr(r);
		gcntl(0, 1, 0, 0, 0);	/* green */
		clrgr(g);
		gcntl(0, 0, 1, 0, 0);	/* blue */
		clrgr(b);
		gcntl(1, 1, 1, 0, 0);	/* everything on */
	    }
	    if (state_level > 0) return(1);
	} else /* indexed colour */
	if (pc2->c_s_mode == i_c_mode) {
	    /* set up the CGM default color maps */
	    col_entries = (pc1->max_c_index > max_entries) ? 
		max_entries : pc1->max_c_index;
	    for (i=0; i<col_entries; ++i) {
	        r = int_col(*(pc5->ctab + i * 3));
	        g = int_col(*(pc5->ctab + i * 3 + 1));
	        b = int_col(*(pc5->ctab + i * 3 + 2));
	        cmap(0, i, r, g, b);
	    }
	    gcntl(1, 1, 1, 0, 0);
	    if (state_level > 0) return(1);
	    clrgr(0);			/* clear to index 0 */
	}
	/* set other attributes */
	setpm(0);	/* replace mode for lines and points */
	setcpm(0);	/* replace mode for characters */
	setfm(0);	/* replace mode for fills */
	
	return(1);
}


/* set text on a peritek device */
pk_text(x, y, final, buffer)
int x, y, final;
char *buffer;
{
char *c_ptr;
int retwidth, retheight, base, nchar, xmag, ymag;

	/* take care of the colour */
	if (pc2->c_s_mode == i_c_mode){
	    setcpv(pc5->text_colour.ind, pc5->text_colour.ind, pc5->text_colour.ind);
	} else 
	if (pc2->c_s_mode == d_c_mode) {
	    setcpv(int_col(pc5->text_colour.red), int_col(pc5->text_colour.green),
		int_col(pc5->text_colour.blue));
	}

	/* take care of the size */
	chseti(&retwidth, &retheight, &base, &nchar);
	xmag = 0.5 + pc5->c_height / retheight;
	xmag = (xmag >= 1) ? xmag : 1;
	ymag = xmag;
	chgmag(xmag, ymag);
	chseti(&retwidth, &retheight, &base, &nchar);

	/* take care of positioning */
	switch (pc5->text_align.hor) {
case normal_h:		break;
case left_h:		break;
case center_h:		x -= (xmag * retwidth * strlen(buffer)) / 2; break;
case right_h:		x -= (xmag * retwidth * strlen(buffer)); break;
case cont_h:		break;
}
	switch (pc5->text_align.ver) {
case normal_v:		break;
case top_v:		y -= ymag * retheight; break;
case cap_v:		y -= ymag * retheight * 0.9; break;
case half_v:		y -= ymag * retheight * 0.5; break;
case base_v:		break;
case bottom_v:		y -= ymag * retheight * 0.1; break;
case cont_v:		break;
}
	move(x, y);
	strout(buffer);

	return(1);
}
/* function to set a series of markers */
pk_pmarker(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
int retwidth, retheight, base, nchar, xmag, ymag, i, x_adjust = 0,y_adjust = 0;

	chrsel(0);	/* select the character set */

	/* take care of the colour */
	if (pc2->c_s_mode == i_c_mode){
	    setcpv(pc5->mk_colour.ind, pc5->mk_colour.ind, pc5->mk_colour.ind);
	} else 
	if (pc2->c_s_mode == d_c_mode) {
	    setcpv(int_col(pc5->mk_colour.red), int_col(pc5->mk_colour.green),
		int_col(pc5->mk_colour.blue));
	}

	/* take care of the size */
	chseti(&retwidth, &retheight, &base, &nchar);
	xmag = 0.5 +  pc5->mk_size.i / retheight;
	xmag = (xmag >= 1) ? xmag : 1;
	ymag = xmag;
	if (xmag > 1) {
	    chgmag(xmag, ymag);
	    chseti(&retwidth, &retheight, &base, &nchar);
	}

	switch (pc5->mk_type) {
case 1 : x_adjust = - 0.35 * xmag * retwidth; 
		y_adjust = - 0.2 * ymag * retheight; break;
case 2 : x_adjust = - 0.35 * xmag * retwidth; 
		y_adjust = - 0.45 * ymag * retheight; break;
case 3 : x_adjust = - 0.35 * xmag * retwidth; 
		y_adjust = - 0.45 * ymag * retheight; break;
case 4 : x_adjust = - 0.35 * xmag * retwidth; 
		y_adjust = - 0.375 * ymag * retheight; break;
case 5 : x_adjust = - 0.35 * xmag * retwidth; 
		y_adjust = - 0.375 * ymag * retheight; break;
default: fprintf(stderr, "illegal marker type ! = %d\n", pc5->mk_type);
	   x_adjust = - xmag * retwidth / 2; y_adjust = - ymag * retheight / 2; 
}

	for (i=0;i<no_pairs;++i) {
	    move(x1_ptr[i] + x_adjust, y1_ptr[i] + y_adjust);
	    chrout(c_mark[pc5->mk_type]);
	}
	return(1);
}
/* set a polygon */
pk_pgon(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
int tot_pairs, *new_x, *new_y, i;
char * allocate_mem();

	switch (pc5->int_style) {
	case hollow :	setft(0); break;
	case solid_i :	if (pc2->c_s_mode == i_c_mode) 
			    setfc(pc5->fill_colour.ind, pc5->fill_colour.ind,
				pc5->fill_colour.ind);
			else if (pc2->c_s_mode == d_c_mode)
			    setfc(int_col(pc5->fill_colour.red), 
				int_col(pc5->fill_colour.green), 
				int_col(pc5->fill_colour.blue));
			setft(1); break;
	case pattern :	setft(2); break;
	case hatch :	break;
	case empty :	break;
	}
	poly(no_pairs, x1_ptr, y1_ptr);

	/* now check the edge */
	if (pc5->edge_vis == off) return(1);	/* no edge */

	/* set the edge colour */
	if (pc2->c_s_mode == i_c_mode){
	    setpv(pc5->edge_colour.ind, pc5->edge_colour.ind,
		pc5->edge_colour.ind);
	} else 
	if (pc2->c_s_mode == d_c_mode) {
	    setpv(int_col(pc5->edge_colour.red), 
		int_col(pc5->edge_colour.green), 
		int_col(pc5->edge_colour.blue));
	}
	tot_pairs = no_pairs + 1;
	new_x = (int *) allocate_mem(tot_pairs * sizeof(int), 0);
	new_y = (int *) allocate_mem(tot_pairs * sizeof(int), 0);
	if (new_x && new_y) {
	    for (i=0; i<no_pairs; ++i) {
	    new_x[i] = x1_ptr[i];
	    new_y[i] = y1_ptr[i];
	    }
	    new_x[i] = x1_ptr[0];
	    new_y[i] = y1_ptr[0];
	    plot(tot_pairs, new_x, new_y);
	    free(new_x);
	    free(new_y);
	}
	return(1);
}
	
/* do a cell array */
pk_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
int *cp;	/* first corner */
int *cq;	/* the diagonal to cp p*/
int *cr;	/* first row is from cp to cr */
int nx;		/* number of elements in x rows (i.e., parallel to cp-cr) */
int ny;		/* number of rows */
int col_prec;	/* the colour precision (how many possible colour values */
unsigned char *dat_ptr;	/* pointer to the body of information */
int rep_mode;	/* the representation mode; 0, run length encoded, 1 normal */
int no_bytes;	/* number of data bytes */
{
enum cs_enum c_s_mode;	/* the colour selection mode, indexed or direct */
unsigned char *new_ptr = NULL, *store_ptr = NULL, *invert_ptr = NULL;
unsigned int new_bytes, i, j, row_size, c_size, new_size;
char *pk_ptr, *allocate_mem(), *c_ptr, *char_ptr;
int step_size, x1, y1;
float rmax_col;
static unsigned char bit1_flag[byte_size] = {128, 64, 32, 16, 8, 4, 2, 1};

	step_size = col_prec / 8;
	/* lets see what we have */
	c_s_mode = pc2->c_s_mode;	/* start with this, may change */
	switch (c_s_mode) {
case d_c_mode:	c_size = 3 * col_prec; break;
case i_c_mode:	c_size = col_prec; break;
default:	fprintf(stderr, "illegal colour selection mode ! (%d)\n",
		    (int) c_s_mode); break;
	}
	/* now get the row size in bytes allowing for rounding */
	row_size = (nx * c_size + byte_size - 1) / byte_size;	/* check */
	row_size = (row_size % 2) ? row_size + 1 : row_size; 	/* round up */

	/* expand a compressed raster */
	if (rep_mode == 0) {
	    new_ptr = allocate_mem(ny * row_size, 1);
	    if (!new_ptr) return(2);
	    (void) c_expand(dat_ptr, nx, ny, row_size, c_size, new_ptr);
	    dat_ptr = new_ptr;	/* carry on as before */
	}
	/* now we may have to invert it */
	if (cq[1] >= cp[1]) {	/* upright */
	    x1 = cp[0];
	    y1 = cp[1];
	} else {	/* q below p */
	    if (invert_ptr = allocate_mem(ny * row_size, 1)) {
		for (i = 0; i < ny; ++i)
		    for (j = 0; j < row_size; ++j)
			*(invert_ptr + i * row_size + j) = 
			    *(dat_ptr + (ny - 1 - i) * row_size + j);
		dat_ptr = invert_ptr;
	    }
	    x1 = cq[0] + (cp[0] - cr[0]);
	    y1 = cq[1] + (cp[1] - cr[1]);
	}


	setdst(0, x1, y1, (nx % 2) ? nx + 1 : nx, ny);	/* where it's going */

	/* indexed mode first */
	if (pc2->c_s_mode == i_c_mode) {
	    new_size = (nx % 2) ? nx + 1 : nx;
	    if (col_prec == 8) {	/* well set up for Peritek */
		pk_ptr = dat_ptr;
	    } else if (col_prec > 8) {	/* cut it down to size */
		if (!(pk_ptr = store_ptr = allocate_mem(new_size * ny, 1))) 
		    return(2);
		for(i=0; i < ny * new_size; ++i)
		    *(pk_ptr + i) = *(dat_ptr + i*step_size);
	    } else if (col_prec == 1) {
		row_size = (nx + byte_size - 1) / byte_size;
		row_size = (row_size % 2) ? row_size + 1 : row_size;
		if (!(pk_ptr = store_ptr = 
		    allocate_mem(new_size * ny, 1))) return(2);
		for (i=0; i<ny; ++i) {
		    for(j=0; j < nx; ++j)
			*(pk_ptr + i * new_size + j) = 
			    *(dat_ptr + (j / byte_size)) &
			    bit1_flag[j % byte_size] ? 1 : 0;
		    dat_ptr += row_size;
		}
	    }
	    setsrc(pk_ptr, 0, 0);	/* where it's coming from */
	    gcntl(1,0,0,0,0);	    /* get the first plane */
	    rstrop();
	    gcntl(0,1,0,0,0);	    /* get the second plane */
	    rstrop();
	    gcntl(0,0,1,0,0);	    /* get the third plane */
	    rstrop();
	}
/* now the direct mode */

	else if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
	    if (!(c_ptr = malloc(nx * ny))) return(2);
	    if (col_prec == 8) {	/* well set up */
		gcntl(1,0,0,0,0);	    /* get the first plane */
		char_ptr = dat_ptr;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = *char_ptr;
		    char_ptr += 3;
	        }
	        setsrc(c_ptr, 0, 0);	/* where it's coming from */
	        rstrop();
	        gcntl(0,1,0,0,0);	    /* get the second plane */
	        char_ptr = dat_ptr + 1;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = *char_ptr;
		    char_ptr += 3;
	        }
		setsrc(c_ptr, 0, 0);	/* where it's coming from */
		rstrop();
		gcntl(0,0,1,0,0);	    /* get the third plane */
		char_ptr = dat_ptr + 2;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = *char_ptr;
		    char_ptr += 3;
		}
		setsrc(c_ptr, 0, 0);	/* where it's coming from */
		rstrop();
	    }
/* take care of the ickier cases */

	    else {			/* have to munge it
		rmax_col = (1 << col_prec) - 1;
		gcntl(1,0,0,0,0);		/* get the first plane */
		char_ptr = dat_ptr;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = (cgm_guint(char_ptr, col_prec) * max_d_val)
			/ rmax_col;
		    char_ptr += 3 * step_size;
		}
		setsrc(c_ptr, 0, 0);	/* where it's coming from */
		rstrop();
		gcntl(0,1,0,0,0);	    /* get the second plane */
		char_ptr = dat_ptr + step_size;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = (cgm_guint(char_ptr, col_prec) * max_d_val)
			/ rmax_col;
		    char_ptr += 3 * step_size;
		}
		setsrc(c_ptr, 0, 0);	/* where it's coming from */
		rstrop();
		gcntl(0,0,1,0,0);	    /* get the third plane */
		char_ptr = dat_ptr + 2 * step_size;
		for (i = 0; i < nx * ny; ++i) {
		    *(c_ptr + i) = (cgm_guint(char_ptr, col_prec) * max_d_val)
			/ rmax_col;
		    char_ptr += 3 * step_size;
		}
		setsrc(c_ptr, 0, 0);	/* where it's coming from */
		rstrop();
	    }
	    free(c_ptr);
	}
	gcntl(1,1,1,0,0);		/* back to all planes active */
	if (new_ptr) free(new_ptr);
	if (store_ptr) free(store_ptr);
	if (invert_ptr) free(invert_ptr);
	return(1);
}

/* plot a set of lines */
pk_pline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
	/* set the line colour */
	if (pc2->c_s_mode == i_c_mode){
	    setpv(pc5->line_colour.ind, pc5->line_colour.ind,
		pc5->line_colour.ind);
	} else 
	if (pc2->c_s_mode == d_c_mode) {
	    setpv(int_col(pc5->line_colour.red), 
		int_col(pc5->line_colour.green), 
		int_col(pc5->line_colour.blue));
	}

	plot(no_pairs, x1_ptr, y1_ptr);
	return(1);
}
/* plot a set of lines between alternate points */
pk_dpline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
int i;

	if ( no_pairs <= 1 ) return(1);

	/* set the line colour */
	if (pc2->c_s_mode == i_c_mode){
	    setpv(pc5->line_colour.ind, pc5->line_colour.ind,
		pc5->line_colour.ind);
	} else 
	if (pc2->c_s_mode == d_c_mode) {
	    setpv(int_col(pc5->line_colour.red), 
		int_col(pc5->line_colour.green), 
		int_col(pc5->line_colour.blue));
	}

	for (i=0; i < no_pairs ; i+=2) {
	    plot(2, x1_ptr + i, y1_ptr + i);
	}
	return(1);
}
/* do all of the colour setting here */
/* get a colour table here */
pk_ctab(beg_index, no_entries, ctab)
int beg_index, 	/* beginning index */
no_entries; 	/* number of entries to add starting at beg_index */
float *ctab;	/* direct colour array, *(ctab + i*3) is the red
		   entry for the i'th index, followed by g and b */
{
int i;
	ctab += 3 * beg_index;
	for (i=0; i<no_entries; ++i) {
	    cmap(0, i + beg_index, int_col(*ctab), int_col(*(ctab+1)),
		int_col(*(ctab+2)));
	    ctab += 3;
	}

	return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the uis module */
void pk_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	gprim, attr, escfun, extfun, ctrl, pargc, argv)

struct one_opt 		*opt;	/* the command line options, in only */
struct info_struct *dev_info;	/* device info to fill out, out only */
struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
struct control_struct	*c3;	/* the class 3 elements, in only */
struct attrib_struct	*c5;	/* the class 5 elements, in only */
int (*delim[])();	/* delimiter functions */
int (*mfdesc[])();	/* metafile descriptor functions */
int (*pdesc[])();	/* page descriptor functions */
int (*mfctrl[])();	/* controller functions */
int (*gprim[])();	/* graphical primitives */
int (*attr[])();	/* the attribute functions */
int (*escfun[])();	/* the escape functions */
int (*extfun[])();	/* the external functions */
int (*ctrl[])();	/* controller functions */
int *pargc;			/* argc pointer */
char **argv;			/* argv */	
{
int base, nchar;

	/* store the command line argument pointer */
	popt = opt;
	/* store the device info pointer */
	dptr = dev_info;
	/* store the CGM data structure pointers */
	pc1 = c1;
	pc2 = c2;
	pc3 = c3;
	pc5 = c5;

	chrsel(0);	/* select the character set */

	/* fill out the device info structure */
	dev_info->pxl_in 	= 50;		/* arbitrary decision */
	dev_info->ypxl_in 	= dev_info->pxl_in;
	dev_info->x_size 	= 10.24;
	dev_info->y_size 	= 10.24;
	dev_info->x_offset	= 0.0;	/* fix later if necessary */
	dev_info->y_offset	= 0.0;
	chseti(&dev_info->c_width, &dev_info->c_height, &base, &nchar);
	dev_info->d_l_width	= 1;				
	dev_info->d_e_width	= 1;				
	dev_info->d_m_size	= dev_info->c_height;	/* marker size */
	*dev_info->out_name	= '\0';		/* no output file */
	dev_info->capability	= 0 /* + stroke_text + char_text + string_text + 
				    h_center + v_center */ ;

	/* now fill out the function pointer arrays for CGM */
	/* the delimiter functions */
	delim[(int) B_Mf] 	= pk_begin;
	delim[(int) B_Pic_Body]	= pk_bpage;
	delim[(int) E_Mf] 	= pk_end;

	/* the graphical primitives */
	gprim[(int) PolyLine]	= pk_pline;
	gprim[(int) Dis_Poly]	= pk_dpline;
	gprim[(int) PolyMarker]	= pk_pmarker;
	gprim[(int) Text]	= pk_text;
	gprim[(int) Polygon]	= pk_pgon;
	gprim[(int) Cell_Array]	= pk_carray;

	/* the attributes */
	attr[(int) ColTab] 	= pk_ctab;

	state_level = -1;

	return;
}
