'\"t
.if t .TH IMFORMATS 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMFORMATS 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
imformats - List information on image file formats
.SH SYNOPSIS
\fBimformats\fR [\fIoptions\fR]
.SH DESCRIPTION
\fBimformats\fR displays a list of the image file formats supported
by the SDSC image tools (such as \fBimconv\fR(1IM)) and the underlying
SDSC image library \fBlibim.a\fR (see \fBimintro\fR(3IM)). 
.SH OPTIONS
With no options given, \fBimformats\fR prints to \fBstdout\fR a list of
supported image file formats.  For instance:
.RS +0.5i
.sp 1
\fBimformats\fR
.RE
.LP
The above command displays:
.LP
.RS +0.5i
.TS
l l.
Format	Description
-------	----------------------------------------------
gif	CompuServe Graphics Image Format File
hdf	Hierarchical Data Format File
icon	Sun Icon and Cursor file
iff	Sun TAAC Image File Format
mpnt	Apple Macintosh MacPaint file
pbm	Portable Bit Map file
pcx	ZSoft IBM PC Paintbrush file
pgm	Portable Grayscale Map file
pic	PIXAR PICture file
pict	Apple Macintosh QuickDraw/PICT file
pix	Alias PIXel image file
pnm	Portable aNy Map file
ppm	Portable Pixel Map file
ps	PostScript image file
ras	Sun RASterfile
rgb	Silicon Graphics RGB image file
rla	Wavefront raster image file
rle	Utah Runlength-encoded image file
rpbm	Raw Portable Bit Map file
rpgm	Raw Portable Grayscale Map file
rpnm	Raw Portable aNy Map file
rppm	Raw Portable Pixel Map file
synu	Synu image file
tiff	Tagged Image File
x	Stardent AVS X image file
xbm	X11 Bit Map file
xwd	X Window Dump image file
.TE
.RE
.LP
To restrict the table to one or more formats, list the names of
the formats on the command line, as in the following:
.RS +0.5i
.sp
.if t .bp
\fBimformats -ras -tiff -hdf\fR
.RE
.LP
which displays:
.LP
.RS +0.5i
.TS
l l.
Format	Description
-------	----------------------------------
ras	Sun Rasterfile
tiff	Tagged Image File Format
hdf	Hierarchical Data File
.TE
.RE
.LP
Information on file formats is displayed in the order you specify on
the command line.
.LP
The \fB-long\fR option elaborates on the list by including information on the
format's creator or vendor, other common names for the format, and a
summary of the supported format variants for read and write operations.
For instance, to find out more about support for TIFF files, enter the
following: 
.RS +0.5i
.sp
\fBimformats -tiff -long\fR
.RE
.LP
which displays:
.LP
.RS +0.5i
tiff    Tagged image file
.RS +0.5i
a.k.a.:    tif
.br
Creator:   Aldus, Microsoft, and NeXT
.br
Read support:
.RS +0.2i
1-, 4-, 8-, and 32-bit color index images.  24-bit RGB and 32-bit
RGB+alpha images.  Standard (uncompressed), Mac Packbits, and 
Lempel-Ziv & Welsh compression.
.RE
Write support:
.RS +0.2i
1-, 8-, and 32-bit color index images.  24-bit RGB and 32-bit
RGB+alpha images.  Standard (uncompressed), Mac Packbits, and 
Lempel-Ziv & Welsh compression.
.RE
.RE
.RE
.LP
If you specify \fB-long\fR twice, you receive
a detailed list of the variants of
the file format that can be read and written.  For instance:
.RS +0.5i
.sp
\fBimformats -tiff -long -long\fR
.RE
.LP
displays:
.LP
.RS +0.5i
tiff    Tagged image file
.RS +0.5i
a.k.a.:    tif
.br
Creator:   Aldus, Microsoft, and NeXT
.br
Read support:
.RS +0.2i
.TS
l l l l l l l.
Type	#chan	#bits	CLT?	Alpha?	Compression	Interleaving
-----	-----	-----	----	------	-----------	------------
index	1	1	no	no	none	none
index	1	4	no	no	none	none
index	1	8	no	no	none	none
index	1	8	no	no	none	none
index	1	8	yes	no	none	none
index	1	32	no	no	none	none
index	1	32	yes	no	none	none
rgb	3	8	no	no	none	none
rgb	3	8	no	yes	none	none
index	1	1	no	no	PackBits	none
index	1	4	no	no	PackBits	none
index	1	8	no	no	PackBits	none
index	1	8	no	no	PackBits	none
index	1	8	yes	no	PackBits	none
index	1	32	no	no	PackBits	none
index	1	32	yes	no	PackBits	none
rgb	3	8	no	no	PackBits	none
rgb	3	8	no	yes	PackBits	none
index	1	1	no	no	LZW	none
index	1	4	no	no	LZW	none
index	1	8	no	no	LZW	none
index	1	8	no	no	LZW	none
index	1	8	yes	no	LZW	none
index	1	32	no	no	LZW	none
index	1	32	yes	no	LZW	none
rgb	3	8	no	no	LZW	none
rgb	3	8	no	yes	LZW	none
.TE
.RE
Write support:
.RS +0.2i
.TS
l l l l l l l.
Type	#chan	#bits	CLT?	Alpha?	Compression	Interleaving
-----	-----	-----	----	------	-----------	------------
index	1	1	no	no	LZW	none
index	1	1	no	no	PackBits	none
index	1	1	no	no	none	none
index	1	8	yes	no	LZW	none
index	1	8	yes	no	PackBits	none
index	1	8	yes	no	none	none
index	1	8	no	no	LZW	none
index	1	8	no	no	PackBits	none
index	1	8	no	no	none	none
rgb	3	8	no	yes	none	none
rgb	3	8	no	yes	PackBits	none
rgb	3	8	no	yes	LZW	none
rgb	3	8	no	no	LZW	none
rgb	3	8	no	no	PackBits	none
rgb	3	8	no	no	none	none
.TE
.RE
.RE
.RE
.LP
The double \fB-long\fR output is a dump of internal tables listing
what each format can and cannot handle.  These tables are ordered in a
way that makes sense to \fBimformats\fR and the SDSC image library,
but not necessarily to human beings. 
.LP
\fBimformats\fR also recognizes the following standard SDSC options:
.LP
\fB-feedback\fR
.RS +0.5i
Create a software feedback (bug report) form in the file
\fBimformats\fB.fbk.0\fR. 
.RE
.LP
\fB-fullhelp\fR
.RS +0.5i
Display a detailed list of the arguments and how to use
\fBimformats\fR. 
.RE
.LP
\fB-help\fR
.RS +0.5i
Display an abbreviated list of the arguments and how to use
\fBimformats\fR. 
.RE
.LP
\fB-register\fR
.RS +0.5i
Create a software user registration form in the file
\fBimformats\fB.reg.0\fR. 
.RE
.LP
\fB-version\fR
.RS +0.5i
Display the version number and copyright for \fBimformats\fR.
.RE
.LP
All options can be abbreviated to the first few unique characters.
.SH NOTES
Because of the length of \fBimformat\fR's output, we recommend you 
pipe the output of \fBimformats\fR into
a screen pager like \fBmore\fR(1) or \fBless\fR(1).
.LP
The \fBFormat\fR and \fBDescription\fR
column headings only appear if information
on more than one format is displayed.
.SH "SEE ALSO"
\fBimconv\fR(1IM), \fBimcopy\fR(1IM), \fBimfile\fR(1IM), \fBimflip\fR(1IM),
\fBimgray\fR(1IM), \fBimmono\fR(1IM), \fBimpaste\fR(1IM), \fBimscale\fR(1IM)
.sp 1
For information on the SDSC image library, see \fBimintro\fR(3IM).
.sp 1
For information on the individual image file formats, see 
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR 
.br
