'\"T
.if t .TH IMCUR 3IM "August 19, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMCUR 3IM "August 19, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imcur \- Microsoft Windows CUR file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "cur", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "cur", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "cur", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "cur", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBcur\fR image files are generated by programs running in the
Microsoft Windows 3.0, and later, environments.  This environment
commonly runs on IBM PC's and compatibles.
.LP
\fBcur\fR image
files store one or more cursors used by Windows programs.
Bitmap images and icons are instead stored in the \fBbmp\fR and \fBico\fR
Windows formats.  See \fBimbmp\fR (3IM) and \fBimico\fR (3IM) for
details on these formats.
.SH "FILE RECOGNITION"
Microsoft Windows \fBcur\fR files are recognized by the following
filename suffix:  .cur.
.SH NOTES
SDSC image library support of the 
Microsoft Windows \fBcur\fR format does not require
use of any Windows libraries and contains no proprietary code.  
Microsoft Windows \fBcur\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Microsoft Windows CUR files"
The SDSC image library reads multiple non-compressed, pixel packed
1-bit color indexed cursor images as \fBIMVFBINDEX8\fR VFB's with
alpha channels and CLT's.  A cursor's XOR mask is read in as the
main image.  The associated AND mask is read in as an alpha channel
for the same VFB.
.SS "Writing Microsoft Windows CUR files"
Image library \fBIMVFBMONO\fR VFBs are written to non-compressed,
pixel packed 1-bit \fBcur\fR files.  The mono-channel of the VFB
is written as the cursor's XOR mask.  The VFB's alpha channel is
written as the AND mask.
.LP
Other image library VFB types are converted to \fBIMVFBMONO\fR VFBs 
with alpha channels prior to being written out.  See the
\fBImFileWrite\fR(3IM) \fBman\fP page for details.
.SS "AND and XOR masks"
A \fBcur\fR image file contains multiple cursors.  Each cursor is
composed of two separate images, an AND mask and an XOR mask.  Microsoft
Windows uses these masks to generate a displayed cursor as follows:
.RS 0.5i
.LP
Windows first does a bitwise AND operation on the display pixels using the
AND mask.  This preserves or removes existing color pixels.  Afterwards,
Windows does a bitwise XOR operation on the display using the XOR
mask.  This sets the final color of each cursor pixel.
.RE
.LP
The AND mask is typically used to create a hole on the screen into which
to paint the colors specified by the XOR mask.  This use of the AND mask
is similar to a standard image alpha channel and is why the SDSC Image
Tools read the AND mask into a VFB's alpha channel, and place the XOR mask
in the VFB's color index channel.
.LP
For example, the following AND and XOR masks form an up-and-left-pointing
arrow cursor.
.sp
.if n .ig END
.(z
.TS
tab(:) center;
 c s s s s s s s lw(.5i) c s s s s s s s
|c s s s s s s s|lw(.5i)|c s s s s s s s|
|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.5i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|.
_::_
AND mask::XOR mask
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:1:1:1:1:1::1:1:1:0:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:1:1:0:0:1:1:1::1:0:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:0:0:1:1::0:0:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:0:0:1::0:0:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:1:0:0::0:0:0:0:0:0:1:1
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:1:1:0::0:0:0:0:0:0:0:1
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
.TE
.)z
.sp
.(z
.TS
tab(:) allbox center;
c s s s s s s s
lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i).
Resulting Cursor
W:W:W:W: : : :
W:W:W: : : : :
W:W:W:W: : : :
W: : :W:W: : :
 : : : :W:W: :
 : : : : :W:W:
 : : : : : :W:W
 : : : : : : :W
.TE
.)z
.END
.if t .ig END
.TS
tab(:) center;
c s s s s s s s lw(.1i) c s s s s s s s
c s s s s s s s lw(.1i) c s s s s s s s 
l l l l l l l l lw(.1i) l l l l l l l l.
_::_
AND mask::XOR mask
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:1:1:1:1:1::1:1:1:0:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:1:1:0:0:1:1:1::1:0:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:0:0:1:1::0:0:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:0:0:1::0:0:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:1:0:0::0:0:0:0:0:0:1:1
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
1:1:1:1:1:1:1:0::0:0:0:0:0:0:0:1
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
.TE
.)z
.sp
.(z
.TS
tab(:) center;
c s s s s s s s
c s s s s s s s
l l l l l l l l.
_
Resulting Cursor
_:_:_:_:_:_:_:_
W:W:W:W: : : :
_:_:_:_:_:_:_:_
W:W:W: : : : :
_:_:_:_:_:_:_:_
W:W:W:W: : : :
_:_:_:_:_:_:_:_
W: : :W:W: : :
_:_:_:_:_:_:_:_
 : : : :W:W: :
_:_:_:_:_:_:_:_
 : : : : :W:W:
_:_:_:_:_:_:_:_
 : : : : : :W:W
_:_:_:_:_:_:_:_
 : : : : : : :W
_:_:_:_:_:_:_:_
.TE
.)z
.END
.SS
The following table shows bit mask results:
.sp
.sp
.ne 1.5i
.TS
tab(:) center;
l l l.
AND mask:XOR mask:Resulting Pixel
_:_:_
0:0:Black
0:1:White
1:0:Transparent
1:1:Inverted
.sp
.sp
.TE
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Microsoft Windows \fBcur\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Image depth not supported
IMEMAGIC	Bad magic number in header
IMEPLANES	Unknown image plane configuration
IMECLTLENGTH	Bad CLT length
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIMicrosoft Windows Programmer's Reference Volumes 3 and 4\fR, Microsoft, Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimbmp\fR(3IM),
\fBimcat\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimico\fR(3IM),
\fBimsplit\fR(3IM)
.SH AUTHOR
Toan-Vinh Le
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
