'\"et
.if t .TH IMPIC 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMPIC 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
impic \- PIXAR PIC file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "pic", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "pic", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "pic", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "pic", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBpic\fR image files are generated by PIXAR programming software,
such as \fBChapVolumes\fR and
\fBChapReyes\fR, the PIXAR Image Runtime Library called \fBPirl\fR,
and the PIXAR rendering tool \fBRenderMan\fR.
See the PIXAR documentation set for details on how to use these 
applications and tools.
.LP
PIXAR's \fBpic\fR file format is sometimes referred to as PICIO in PIXAR
documentation.  \fBpic\fR and PICIO mean the same thing.
.LP
PIXAR's \fBxpic\fR is not the same as \fBpic\fR and is \fInot\fR supported by
the SDSC image library.
.LP
\fINote:\fR  PIXAR's \fBRenderMan\fR always saves its image files with .pic
filename suffixes.  However, depending upon output
defaults, \fBRenderMan\fR can generate .pic files with PICIO (same as \fBpic\fR)
data or TIFF data.  .pic files with TIFF data will confuse the
SDSC image library.  For you to avoid generating this type of file, 
we recommend that you configure
\fBRenderMan\fR defaults to generate .pic files with PICIO data. 
.SH "FILE RECOGNITION"
PIXAR \fBpic\fR files are recognized by the following filename
suffixes:  .pic, .picio, and .pixar.
.SH NOTES
SDSC image library support of the PIXAR \fBpic\fR format does not require
use of PIXAR's tools, libraries, or hardware and 
contains no proprietary code.  PIXAR \fBpic\fR format handling is 
available on any machine for which the SDSC image 
library is available.
.SS "Reading PIXAR image files"
The SDSC image library can read PIXAR \fBpic\fR files 
and map them to VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBDepth/color	Type of compression	Mapped to VFB\fR
8-bit R	Dump and encoded	IMVFBINDEX8 without CLT
12-bit R	Dump and encoded	IMVFBINDEX16 without CLT
24-bit RGB	Dump and encoded	IMVFBRGB without CLT
36-bit RGB	Dump and encoded	IMVFBRGB without CLT
32-bit RGB-Alpha	Dump and encoded	(IMVFBRGB | IMVFBALPHA) without CLT
48-bit RGB-Alpha	Dump and encoded	(IMVFBRGB | IMVFBALPHA) without CLT
.TE
.if t .in -0.5i
.if n .in -5
.LP
Single-channel images in 8- and 12-bit depths store the channel's data as
the red image channel.  The \fBpic\fR code treats such images 
as grayscale images without
color lookup tables (CLTs). 
.LP
Dump format images are stored uncompressed; encoded format images
are stored using a variant of run-length-encoded (RLE) compression.
.LP
A PIXAR \fBpic\fR image can be represented in files as a series of tiles,
each one containing a part of the image.  Such image tiling
is \fInot\fR supported by the SDSC image library.
.LP
\fINote:\fR  RGB images with 12-bit data channels (i.e., 36-bit RGB and 
48-bit RGB-Alpha) are reduced to 8-bit data channels when read in.
.SS "Writing PIXAR image files"
SDSC image library VFBs are written to \fBpic\fR files as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBMapped from VFB	Depth/color	Type of compression\fR
IMVFBINDEX8	8-bit R	dump and encoded 
IMVFBINDEX16	8-bit R	dump and encoded
IMVFBRGB	24-bit RGB	dump and encoded
(IMVFBRGB | IMVFBALPHA)	32-bit RGB-Alpha	dump and encoded
.TE
.if t .in -0.5i
.if n .in -5
.LP
None of the output formats supports storing a CLT
with the image in the file.
.LP
Other image library VFB types, or VFBs with CLTs,
are converted to one of the above types prior
to being written out.  See the \fBImFileWrite\fR(3IM) man page for
details.
.LP
In SDSC image library terminology, dump files are uncompressed;
encoded files use a variant of run-length-encoded (RLE) compression.
.LP
RGB and RGB-Alpha images are always stored non-interlaced
(i.e., RGBRGBRGB...).  Scanline- and plane-interlaced modes are not
supported.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
PIXAR \fBpic\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMAGIC	Bad magic number in image file
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Unknown image type, mode, or multiple tiles 
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR,
PIXAR \fBpic\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIPIXAR Image Computer Programmer's Manual\fR, PIXAR.
.LP
\fIPIXAR Image Computer ChapLibraries User's Guide\fR, PIXAR.
.LP
\fIThe RenderMan Companion\fR, Steve Upstill, PIXAR.
.SH SEE ALSO
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Jim McLeod
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
