'\"t
.if t .TH IMRGB 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMRGB 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imrgb \- Silicon Graphics RGB file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "rgb", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "rgb", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "rgb", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "rgb", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBrgb\fR image files are generated by Silicon Graphics, Inc., software
such as \fBicut\fR(1) and \fBsnapshot\fR(1).
See the Silicon Graphics documentation for information on how to use these 
and other Silicon Graphics programs.
.SH "FILE RECOGNITION"
Silicon Graphics \fBrgb\fR files are recognized by the following
filename suffixes:  .rgb, .iris, and .sgi.
.SH NOTES
SDSC image library support of the 
Silicon Graphics \fBrgb\fR format does not require
use of any Silicon Graphics library or hardware
and contains no proprietary code.  
Silicon Graphics \fBrgb\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Silicon Graphics RGB files"
The SDSC image library reads 
uncompressed and runlength-encoded (RLE) 8-bit grayscale and 24-bit RGB
Silicon Graphics \fBrgb\fR images and stores them as \fBIMVFBRGB\fR VFBs without
CLTs.
.SS "Writing Silicon Graphics RGB files"
Image library \fBIMVFBRGB\fR VFBs are written 
to uncompressed or runlength-encoded 8-bit grayscale and 24-bit RGB 
Silicon Graphics \fBrgb\fR files.
Noninterlaced and plane-interlaced modes are not available in the
Silicon Graphics \fBrgb\fR format.
.LP
Other image library VFB types are converted to \fBIMVFBRGB\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Silicon Graphics \fBrgb\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Image depth not supported
IMEMAGIC	Bad magic number in header
IMEMALLOC	Cannot allocate enough memory
IMEPLANES	Number of bytes per plane not supported
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Silicon Graphics \fBrgb\fR file writing returns the following error codes:
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Image depth not supported
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fISilicon Graphics RGB Specification\fR, Silicon Graphics Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Jesus Ferrer, T. Todd Elvins, and Toan-Vinh Le
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
