#!/usr/bin/perl
#========================================================================
#
# Program Name: kzoom - creates a zoom image with a grid highlighting the pixels
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

@INC = (@INC, '/usr/khoros2.0/support/lib');
require "khoros.pl";
require "kutils.pl";

$whatis = 'creates a zoom image with a grid highlighting the pixels';
@ksrcconf_args  = (
        '[i]',     'Input',      'Input image',
        '[zoom]',  'Zoom Factor',  'zoom factor',
        '[o]',  'Output',  'Zoomed output image'
);

# initialize Khoros perl lib
&khoros'initialize("DIP",$whatis,@ksrcconf_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Put your code here
# ------------------------------------------------------------------------
$TMPDIR = $ENV{'TMPDIR'} || '/usr/tmp';
$i = $khoros'argval{"i"};
$o = $khoros'argval{"o"};
$factor = $khoros'argval{"zoom"};

$command = "kfileinfo -i $i -f $TMPDIR/kzoom1$$";
#system( "echo $command");
system( $command);

open(FILE, "$TMPDIR/kzoom1$$");
while(<FILE>)
{
$width  = $1 if /Width =\s*(\d+),/;
$height = $1 if /Height =\s*(\d+),/;
$type   = $1 if /Data Type:.*\((\d+)\)/;
}
close FILE;

$ow     = $width  * $factor;
$oh     = $height * $factor;
#print "$width $factor $ow $type";
#exit(1);

$command = "kresample -i $i -wmag $factor -hmag $factor -o  $TMPDIR/kzoom1$$";
#system( "echo $command");
system( $command);

$command ="vgpwl -r $oh -s 1 -c $ow -m 255 -xp $factor -yp $factor -xw 1 -yw 1 -t float -o $TMPDIR/kzoom2$$";
#system( "echo $command");
system( $command);

$command ="karith2 -min -i1 $TMPDIR/kzoom2$$ -o $TMPDIR/kzoom3$$ -real 255";
#system( "echo $command");
system( $command);

if ($type == 1){
  $command = "kconvert -i $TMPDIR/kzoom3$$ -type 1 -o $TMPDIR/kzoom2$$ -val";
}
else
{
  $command = "kconvert -i $TMPDIR/kzoom3$$ -type 3 -o $TMPDIR/kzoom2$$ -val";
}
#system( "echo $command");
system( $command);

$command = "kbitwise -xor -i1 $TMPDIR/kzoom1$$ -i2 $TMPDIR/kzoom2$$ -o $o";
#system( "echo $command");
system( $command);

system("/bin/rm -f $TMPDIR/kzoom1$$ $TMPDIR/kzoom2$$ $TMPDIR/kzoom3$$");
