 /*
  * Khoros: $Id: dlg.h,v 1.2 1992/03/20 22:34:34 dkhoros Exp $
  */

 /*
  * $Log: dlg.h,v $
 * Revision 1.2  1992/03/20  22:34:34  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>> File Name: dlg.h
 >>>>
 >>>>   Purpose: this file contains the structures dlgimage, dlgnode,
 >>>>            dlgline, and dlgarea which are used with DLG data.
 >>>>
 >>>>    Author: Per Lysne  8/14/90
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dlg_h_
#define _dlg_h_

struct dlgimage {
    char 	name[73];	/* description of area covered by data       */
    char	cart_unit[41];	/* name of the map and state designator      */
    char 	source_date[11];/* year of original source material          */
    char        date_qual[2];   /* qualifier for revision date.              */
    int 	orig_scale;	/* scale of original source material         */
    char	sect_ind[4];	/* sectional indicator			     */
    char 	line_3[81];	/* this info is not used                     */
    int		level_code;	/* DLG level code                            */
    int 	plani_code;	/* defines ground plainimetric ref. system   */
    int 	plani_zone;	/* gives zone of area covered in ref. sys.   */
    int 	plani_units;	/* gives the units used in ground ref. sys.  */
    double	resolution;	/* true ground distancce of one file unit    */
    int		trans_param;	/* # of file to map transformation params.   */
    int		misc_records;	/* this info not used                        */
    int		num_sides;	/* number of sides bounding data area        */
    int 	num_categories;	/* number of data categories in the file     */
    double	projection[15];	/* map projection params.                    */
    double	int_projection[4];/* file to map projection params.          */

    double	corners[4][4];	/* coords. of corners of area covered        */

    struct dlgcategory {
        char	name[21];	/* name of the category                      */
        int	form_code;	/* attribute format code 0=major/minor pairs */
        int	num_nodes;	/* number of nodes referenced in this cat.   */
        int	act_nodes;	/* actual number of nodes in this category   */
        int 	nta_link;	/* 1=node to area link records are present   */
        int 	ntl_link;	/* 1=node to line link records are present   */
        int 	num_areas;	/* number of areas referenced in this cat.   */
        int 	act_areas;	/* actual number of areas in this category   */
        int 	atn_link;	/* 1=area to node link records are present   */
        int 	atl_link;	/* 1=area to line link records are present   */
        int 	area_list;	/* 1=area list-coord. lists are present      */
        int 	num_lines;	/* number of lines referenced in this cat.   */
        int 	act_lines;	/* actual number of lines in this category   */
        int 	line_list;	/* 1=line coord. lists are present           */
        struct dlgnode **nodes;	/* array of pointers to node records         */
        struct dlgline **lines; /* array of pointers to line records         */
        struct dlgarea **areas;	/* array of pointers to area records         */
    } categories[32];		/* up to 32 categories per dlg file          */
};


struct dlgnode {
    double 	x_coordinate;	/* x coordinate of this node                 */
    double 	y_coordinate;   /* y coordinate of this node                 */
    int		numsegments;	/* number of lines intersecting this node    */
    int		numattributes;	/* number of attributes listed for this node */
    int		*segments;	/* lines intersecting this node              */
    int         *majorattributes;/* major attributes listed for this node    */
    int         *minorattributes;/* minor attributes listed for this node    */
};


struct dlgline {
    int		linenum;	/* starting node of this line                */
    int		startnode;	/* starting node of this line                */
    int		endnode;	/* ending node of this line                  */
    int		leftarea;	/* area to the left of direction of travel   */
    int		rightarea;	/* area to the right of direction of travel  */
    int		numcoordinates;	/* number of coordinate pairs for this line  */
    int		numattributes;	/* number of attributes describing this line */
    double	*x_coordinates; /* x element of coordinate pairs             */
    double	*y_coordinates; /* y element of coordinate pairs             */
    int		*majorattributes;/* major attributes for this line           */
    int		*minorattributes;/* minor attributes for this line           */
};


struct dlgarea {
    double 	x_coordinate;	/* x coordinate of representative point      */
    double 	y_coordinate;	/* y coordinate of representative point      */
    int		numsegments;	/* number of segments bounding the area      */
    int		numattributes;  /* number of attributes list for this area   */
    int		numislands;	/* number of islands in this area            */
    int		*segments;	/* lines bounding this area                  */
    int		*majorattributes;/* major attributes listed for this area    */
    int		*minorattributes;/* minor attributes listed for this area    */
};


/* defines for four corners of area covered */
#define SW 		0
#define NW 		1
#define NE 		2
#define SE 		3
#define LATITUDE 	0
#define LONGITUDE 	1
#define INTERNAL_X 	2
#define INTERNAL_Y 	3

#endif
/* do not add after this point */
