 /*
  * Khoros: $Id: config.c,v 1.2 1991/12/18 09:58:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: config.c,v 1.2 1991/12/18 09:58:14 dkhoros Exp $";
#endif

 /*
  * $Log: config.c,v $
 * Revision 1.2  1991/12/18  09:58:14  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "ghost.h"
#include "vinclude.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>  	File Name: config.c                           <<<<
   >>>>                                                       <<<<
   >>>>     	Routines To Read Config Files    	      <<<<
   >>>>                                                       <<<<
   >>>>         gr_read_configfile()			      <<<<
   >>>>         gr_read_path()			      	      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */



/************************************************************
*
*  Routine Name: gr_read_configfile
*
*      Purpose: This routine gets path info from the config file -
*		if it can't get path for any of the files, it will
*		set the pathname to the local "." directory.
*		Prompts the user to be sure all paths are set correctly,
*		and will exit the program if the user does not respond "y".
*
*        Input: filename - full path to config file 
*
*	Output: cpath - string with pathname for .c file
*		hpath - string with pathname for .h file
*		lpath - string with pathname for l.c file
*		man1path - string with pathname for .1 file
*		man3path - string with pathname for .3 file
*		progpath - string with pathname for .prog file
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_read_configfile(filename, config_keys, num, config_paths)
char  *filename;
char **config_keys;
int    num;
char **config_paths;
{
     char *fullpath, *gr_read_path();
     FILE *config_file;
     int   i;

    /*
     *  Open configuration file
     */
     fullpath = vfullpath(filename, NULL, NULL);
     if (!(config_file = fopen(fullpath, "r")))
     {
         fprintf(stderr,"Error: Unable to open '%s' to read config file\n",
                          filename);
	 for (i = 0; i < num; i++)
	     config_paths[i] =  NULL;
	 return(FALSE);
     }

     for (i = 0; i < num; i++)
	config_paths[i] = gr_read_path(config_file, config_keys[i]);

     return(TRUE);
}


/************************************************************
*
*  Routine Name: char *gr_read_path()
*
*      Purpose: This routine gets a single path from the config file 
*	        based on the config key passed in.
*
*        Input: config_file - open stream to config file
*		config_key  - key that will mark the desired path.
*
*		for example, in the config file might be the line:
*		pane: KHOROS_HOME/repos/cantata/subforms/map/map.pane
*		the config_key is "pane", and the output should be
*		"KHOROS_HOME/repos/cantata/subforms/map/map.pane"
*
*       Output: the correct path from the config file if successful,
*		NULL if gr_read_path() fails.
*
*    Called by: gr_read_configfile()
*
*   Written By: Danielle Argiro
*
*************************************************************/

char *gr_read_path(config_file, config_key)
FILE *config_file;
char *config_key;
{
	int i, index, found;
	char buffer[MaxLineLength];
	char *path;

	/*
	 *   look for the config key passed in, and
 	 *   return null if we can't find it 
	 */
        found = FALSE;
	rewind(config_file);
    	while (!found) 
	{
	    /* get a line from the config file */
            if (fgets(buffer, MaxLineLength, config_file) == NULL) 
	        return (NULL);

	    /*  ignore any leading blanks or tabs */
	    i = 0;  while ((buffer[i] == ' ') || (buffer[i]=='\t'))  i++;

	    /* see if we've found our config key */
            if (VStrncmp(&buffer[i], config_key, VStrlen(config_key)) == 0) 
                 found = TRUE;

        }

	/* 
	 * the path appears after any tabs or blanks, and after the 
	 * config key itself, which will be followed by a colon.  Need
	 * to skip by all these items before copying any text into our path.
	 *
	 * note: no need to expand tildas now; that will be done later, when
	 *       the path found is actually used to get information for
	 *	 ghostreader.
	 */

	path = VStrcpy(&buffer[i + VStrlen(config_key) +1]);

	/*  
	 * need to ignore any blanks or tabs that may follow "key:" 
	 */
	index = 0;  while ((path[index] == ' ') || (path[index]=='\t')) index++;
	/*  
	 * also need to cut off any trailing blanks and 
	 * the <cr> at end of path string
	 */  
	i = index;  
	while ((path[i] != ' ') && (path[i]!='\t') && (path[i] != '\n')) i++;
	path[i] = '\0';
	return(&path[index]);
}


/************************************************************
*
*  Routine Name: gw_check_config_paths()
*
*      Purpose:  Makes sure that all necessary config files
*		 are present
*
*        Input: program - 1 for ghostwriter, 2 for ghostreader
*		config_paths - array of paths returned by  gr_read_configfile
*		lib - TRUE if using lib
*		man3 - TRUE if using man3
*
*       Output: TRUE if the config_path[] array is ok, FALSE otherwise
*
*    Called by: lwriter, lreader
*
*   Written By: Danielle Argiro
*
*************************************************************/
int gw_check_config_paths(program, config_paths, lib, man3)
int  program;
char *config_paths[];
int lib, man3;
{
/*
	char *name;

	if (program == 1)
	    name = VStrcpy("ghostwriter:\n");
	else name = VStrcpy("ghostreader:\n");
*/

	if (config_paths[PANEPATH] == NULL)
        {
           fprintf(stderr,"Error: Cannot generate code without the path for\n");
           fprintf(stderr, "the *.pane file in the config file!\n");
           return(FALSE);
        }
        if (config_paths[PROGPATH] == NULL)
        {
           fprintf(stderr,"Error: Cannot generate code without the path for\n");
           fprintf(stderr, "the *.prog file in the config file!\n");
           return(FALSE);
        }
        if (config_paths[CPATH] == NULL)
        {
           fprintf(stderr,"Error: Cannot generate code without the path for\n");
           fprintf(stderr, "the *.c file in the config file!\n");
           return(FALSE);
        }
        if (config_paths[HPATH] == NULL)
        {
           fprintf(stderr,"Error: Cannot generate code without the path for\n");
           fprintf(stderr, "the *.h file in the config file!\n");
           return(FALSE);
        }
        if (config_paths[MAN1PATH] == NULL)
        {
           fprintf(stderr,"Error: Cannot generate code without the path for\n");
           fprintf(stderr, "the *.1 file in the config file!\n");
           return(FALSE);
        }
	if (lib)
	{
            if (config_paths[LPATH] == NULL)
            {
            	fprintf(stderr,
                        "Error: Cannot generate code without the path for\n");
            	fprintf(stderr, "the l*.c file in the config file!\n");
            	return(FALSE);
            }
	}
	if (man3)
	{
            if (config_paths[MAN3PATH] == NULL)
            {
            	fprintf(stderr, 
                       "Error: Cannot generate code without the path for\n");
            	fprintf(stderr, "the *.3 file in the config file!\n");
            	return(FALSE);
            }
	}
	return(TRUE);
}
