 /*
  * Khoros: $Id: proper_loc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: proper_loc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: proper_loc.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	proper_loc.c
# 
# AUTHORS:	Tom Sauer, John Rasure
#               Modified from code done origianlly by Marcelo Teran
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module proper_loc_type().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sat Jun  2 23:59:07 MDT 1990
# 
# ROUTINES:	proper_loc_type()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	proper_loc_type()
*
*     PURPOSE:	Check to see if a viff file or structure has the proper
*               location type, currently either implied or explicit.
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		type - desired location type.
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
proper_loc_type(prog,image,type,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long type;
int exit_flag;
{
    if( image->location_type != type ){
      if (exit_flag == TRUE) {
         (void) fprintf(stderr, "\nError in program %s: \n",prog);
         switch(type){
            case VFF_LOC_IMPLICIT :
               (void) fprintf(stderr, 
"The viff data location type should be VFF_LOC_IMPLICIT\n");
               (void) fprintf(stderr, 
"Implicit data means that the actual locations of the data points are not\n");
               (void) fprintf(stderr, 
"specified with the data.  This data file probably contains actual locations.\n");
               exit(1);
               break;
            case VFF_LOC_EXPLICIT :
               (void) fprintf(stderr, 
"The viff data location type should be VFF_LOC_EXPLICIT\n");
               (void) fprintf(stderr, 
"Explicit data means that actual positions are given for the data points.\n");
               (void) fprintf(stderr, 
"This data may have implied positions.\n");
               exit(1);
               break;
            default :
               (void) fprintf(stderr, "viff data location type is unknown.\n");
               exit(1);
               break;
	 }
      }
      else return(0);
   }
return(1);
}
