 /*
  * Khoros: $Id: ck_bnds_int.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ck_bnds_int.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: ck_bnds_int.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Check Bounds on an Integer Argument 

	source filename:			check_bounds_int.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	stat = check_bounds_int(iarg,imax,imin)

	int stat,iarg,imax,imin;

	description
	-----------

	  Checks to see if iarg is within the specified bounds.
	If not a -1 is returned , otherwise a 0 is returned.
	If imax == imin then,
		if imax = -2 iarg is checked for a value < 0
			(returns stat of -3 if not)
		if imax = -1 iarg is checked for a value <= 0
			(returns stat of -2 if not)
		if imax = 1 iarg is checked for a value >= 0
			(returns stat of 1 if not)
		if imax = 2 iarg is checked for a value > 0
			(returns stat of 2 if not)
		otherwise no checking is done

******************************************************************/

check_bounds_int(iarg,imax,imin)

int iarg,imax,imin;

{
    if (imax<imin ) return(0);		/* checking suppressed in this case */

    if (imax == imin) {

	switch (imax) {

	    case -2 :
		if (iarg < 0)
		    return(0);
		else
		    return(-3);
		break;

	    case -1 :
		if (iarg <= 0)
		    return(0);
		else
		    return(-2);
		break;

	    case 1 :
		if (iarg >= 0)
		    return(0);
		else
		    return(1);
		break;

	    case 2 :
		if (iarg > 0)
		    return(0);
		else
		    return(2);
		break;

	    default :			/* imin == imax == anything else */
		return(0);

	}
    }
    else if ( (iarg>=imin) && (iarg<=imax) )
	return(0);

    return(-1);
}
