#! /bin/csh -f

##### initialize variables #####

if (! $?KHOROS_HOME ) then
   echo ""
   echo "Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0
endif

##### get arguments off the command line #####

if ($#argv > 0) then
   if ("$argv[1]" == "-U") then
     goto usage
   else if ("$argv[1]" == "-V") then
     goto version
   endif
endif

#   end of command line stuff
#   Start of the real code

set include_list = ""
set define_list = ""

if (! $?KHOROS_TOOLBOX) then
   setenv KHOROS_TOOLBOX $KHOROS_HOME/repos/Toolboxes
endif

if ($?KHOROS_TOOLBOX) then
     set define_list = ( `cat $KHOROS_TOOLBOX | awk -F: '{ printf "-D%s=%s  ", $1,$2 }' ` )

     set include_list = ( `cat $KHOROS_TOOLBOX | awk -F: '{ printf "-I%s/repos/config/imake_conf  ", $2 }' ` )
     set define_list  =  `eval echo $define_list`
     set include_list =  `eval echo $include_list`

endif


if ( $#argv == 0 ) then
# 	To preserve TOPDIR & CURDIR, let a `make Makefile' do it.
   if ( -e Makefile ) then
      make Makefile 
   else
      imake \
	-DKHOROS_TEMPLATE=\"Khoros.tmpl\" \
	-DKHOROS_HOME=$KHOROS_HOME \
	$define_list \
	-T$KHOROS_HOME/repos/config/imake_conf/Khoros.tmpl \
	-I$KHOROS_HOME/repos/config/imake_conf \
        -I$KHOROS_HOME/repos/config/imake_tmpls \
	$include_list \
	-DUseInstalled \
	-DTOPDIR=$KHOROS_HOME/src
   endif
   make depend
# Mostly likely called from a `make Makefile'
else
   imake \
	-DKHOROS_TEMPLATE=\"Khoros.tmpl\" \
	-DKHOROS_HOME=$KHOROS_HOME \
	$define_list \
	-T$KHOROS_HOME/repos/config/imake_conf/Khoros.tmpl \
	-I$KHOROS_HOME/repos/config/imake_conf \
        -I$KHOROS_HOME/repos/config/imake_tmpls \
	$include_list \
	$*
endif
exit 0

###
###    the usage statement 
###

usage:
    echo ""
    echo "makemake: [any valid imake options]"
    echo ""
    echo "   Update or Create Makefiles from Imakefiles. "
    echo ""
    echo ""
    echo "where: "
    echo "       [-V]   gives the version for makemake"
    echo "	 [-U]   gives the usage for makemake"
    echo ""
    exit 0

version:
    source $KHOROS_HOME/repos/config/scripts/script_version
    set VERSION = $KHOROS_VERSION
    set RELEASE = $KHOROS_RELEASE
    echo ""
    echo "makemake:  Khoros Release: Version $VERSION.$RELEASE"
    echo ""
    unset KHOROS_VERSION
    unset KHOROS_RELEASE
    exit 0

