 /*
  * Khoros: $Id: ldcpad.c,v 1.2 1992/03/20 23:25:20 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldcpad.c,v 1.2 1992/03/20 23:25:20 dkhoros Exp $";
#endif

 /*
  * $Log: ldcpad.c,v $
 * Revision 1.2  1992/03/20  23:25:20  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldcpad.c
 >>>>
 >>>>      Program Name: dcpad
 >>>>
 >>>> Date Last Updated: Mon Feb 17 23:28:52 1992 
 >>>>
 >>>>          Routines: ldcpad - the library call for dcpad
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/*
** ldcpad allocates and zeroes memory of length*data_length bytes and
** copies the existing image data into it at an offset equal to
** offset*data_length
*/
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldcpad - library call for dcpad
*
* Purpose:
*    
*    1D Constant Pad.
*    
*    

* Input:
*    
*    image          pointer to image to be padded.
*    
*    length         desired length of the data set.
*    
*    offset         desired offset of existing data into padded data.
*    
*    rc             real part of padding constant.
*    
*    ic             imaginary part of padding constant
*    
*    procdir        direction of processing: 0 indicates  vector  pro-
*                   cessing, 1 indicates band oriented processing.
*    
*    

* Output:
*    
*    image          pointer to image after padding.
*    
*    Return value:  0 on normal return, 1 if an error occured.
*    
*    

*
* Written By: Jeremy Worley, Donna Koechner, Ramiro Jordan
*    
*    Jeremy Worley Mon Feb 17 23:26:34 MST 1992
*                                            return  type  on   ldcpad
*                                            changed from implicit int
*                                            to explicit int.
*    
*    

****************************************************************/


/* -library_def */
int ldcpad ( image, length, offset, rc,ic,procdir )

int length, offset,procdir;
float rc,ic;
struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
  float **temp1;  /* output of dload_vector */
  float **tempus;  /* padded data */
  char **dload_vector();
  int dunload_vector();
  int type=1;
  int numvects,dimension,i,j;


  if(image->data_storage_type == VFF_TYP_COMPLEX)type=2;

/*
** dload_vector changes data to the standard processing format
*/

  if(procdir!=0 && procdir!=1){
     fprintf(stderr,"ldcpad:  Illegal process direction specified.\n");
     return(0);
  }

  temp1 = (float **)dload_vector(image,&numvects,&dimension,procdir);
  if(temp1==NULL){
     fprintf(stderr,"ldcpad:  Unable to load vector.\n");
     return(0);
  }

/*
** check some of the arguments for errors
*/

  if(image==NULL){
     fprintf(stderr,"ldcpad:  cannot manipulate a NULL image.\n");
     return(0);
  }else if(dimension+offset>length){
     fprintf(stderr,"ldcpad:  signal length is too small.\n");
     return(0);
  }

  tempus = (float **)malloc(numvects*sizeof(float));
  if(tempus==NULL){
     fprintf(stderr,"ldcpad:  Unable to load vector.\n");
     return(0);
  }

/*
** pad each signal in the ensemble
*/

  for(i=0;i<numvects;i++){
      tempus[i] = (float *)(malloc(type*length*sizeof(float)));
      if(tempus[i]==NULL){
         fprintf(stderr,"ldcpad:  Unable to load vector.\n");
         return(0);
      }

      if(type==1){
         for(j=0;j<offset;j++)tempus[i][j]=rc;
         for(j=offset+dimension;j<length;j++)tempus[i][j]=rc;
      }else{
         for(j=0;j<2*offset;j+=2){
             tempus[i][j]=rc;
             tempus[i][j+1]=ic;
         }
         for(j=2*(offset+dimension);j<2*length;j+=2){
             tempus[i][j]=rc;
             tempus[i][j+1]=ic;
         }
      }

/*
** now copy the data into the array
*/

      for(j=offset*type;j<type*(offset+dimension);j++)
          tempus[i][j] = temp1[i][j-offset*type];
  }

/*
** return ensemble of bands to "original" format
*/

  if(!dunload_vector((char **)tempus,image,image->data_storage_type,
                numvects,length,procdir)){
     fprintf(stderr,"ldcpad:  Unable to unload vector.\n");
     return(0);
  }

/*
** standard return
*/

  return(1);
}
/* -library_code_end */
