 /*
  * Khoros: $Id: ldextract.c,v 1.2 1992/03/20 23:25:26 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldextract.c,v 1.2 1992/03/20 23:25:26 dkhoros Exp $";
#endif

 /*
  * $Log: ldextract.c,v $
 * Revision 1.2  1992/03/20  23:25:26  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldextract.c
 >>>>
 >>>>      Program Name: dextract
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:00:10 1992 
 >>>>
 >>>>          Routines: ldextract - the library call for dextract
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldextract - library call for dextract
*
* Purpose:
*    
*    Extracts 1-D Subsignal(s)
*    
*    

* Input:
*    
*    image          (struct xvimage) Input/output  image  file  struc-
*                   ture.
*    
*    start          (int)  Specifies the  offset  into  the  data  set
*                   where the first point of the output sequence is.
*    
*    end_flg        (int) Flag set to one  if  extracting  to  end  of
*                   file.
*    
*    length         (int) If end_flg = 0, specifies length  of  output
*                   sequence.
*    
*    process_dir    (int) Direction of processing 0=vect, 1= band.
*    
*    

* Output:
*    
*    image          (struct xvimage) Input/output  image  file  struc-
*                   ture.
*    
*    

*
* Written By: Donna Koechner
*    
*    12 Mar 1991 12:43 MST Jeremy Worley
*                                  set image->startx to indicate start
*                                  of subimage.
*    
*    19 Feb 1992 08:58 MST Jeremy Worley
*                                  explicitly    declared     function
*                                  dunload_vector().
*    
*    

****************************************************************/


/* -library_def */
int
ldextract(image, start, end_flg, length, process_dir)

struct xvimage  *image;
int             start,       /* starting point for extracted signal */
                end_flg,     /* flag set to one if extracting to end of file */
                length,      /* if end_flg = 0, length of output sequence */
                process_dir; /* direction of processing 0=vect, 1= band */

/* -library_def_end */

/* -library_code */
{
  int           num_vects,
                dimension,
                i, j,
                arith;          /* complex/real scale factor 1=real, 2=cmplx */

  float         **data,         /* data array */
                **extract;      /* extracted data array */

  char          **dload_vector();
  int           propertype(),dunload_vector();

  if( ! (propertype("ldextract",image,VFF_TYP_FLOAT,FALSE)) && 
      ! (propertype("ldextract",image,VFF_TYP_COMPLEX,FALSE)) ) {
      fprintf(stderr,"ldextract: data type must be float or complex.\n");
      return(0);
  }

  arith = 1;
  if (image->data_storage_type == VFF_TYP_COMPLEX)
  {
    arith = 2;
  }

 /*
  * load vector array
  */
  if( ( data= (float **) dload_vector(image, &num_vects, &dimension, 
              process_dir)) == NULL)
  {
    (void)fprintf(stderr,"ldextract: dload_vector failed\n");
    return(0);
  }

 /*
  * If the starting point is past the end of the sequence, return error.
  */
  if (start >= dimension)
  {
    (void)fprintf(stderr,"ldextract: starting point greater than length");
    (void)fprintf(stderr," of input sequence\n");
    (void)fprintf(stderr,"input sequence length = %d, starting point = %d\n",
                  dimension, start);
    return(0);
  }
  
 /*
  * If end_flg is true, calculate the length.  Otherwise use length passed in.
  */
  if(end_flg == TRUE)
  {
    length = dimension-start;
  }

  if (length > (dimension-start) )
  {
    (void)fprintf(stderr,"ldextract:  specified length of output ");
    (void)fprintf(stderr,"sequence too long.\n");
    (void)fprintf(stderr,"vector length = %d, start = %d, length = %d.\n",
                  dimension, start, length);
    return(0);
  }

 /*
  * Allocate a new array for the extracted data.
  */
  if ( (extract = (float **) (malloc ((unsigned int) num_vects *
        sizeof(float))) ) == NULL)
  {
    (void) fprintf(stderr,"ldextract: Cannot allocate for extracted array.\n");
    return(0);
  }
  for (i=0; i<num_vects; i++)
  {
    if ((extract[i] = (float *) (malloc ((unsigned int) length * arith *
         sizeof(float) ))) == NULL)
    {
      (void)fprintf(stderr,"ldextract: Cannot alloc for extracted array.\n");
      return(0);
    }
  }

 /* 
  * Extract Subsignal for all vectors.
  */
  length *= arith;
  start *= arith;
  for (i=0; i<num_vects; i++)
  {
    for (j=0; j<length; j++)
    {
      extract[i][j] = data[i][j+start];
    }
  }

 /*
  * divide final length by 2 if complex data when dvector changes!
  */
  length /= arith;

 /*
  * Load data back into VFF format
  */
  if (!dunload_vector((char **)extract, image, image->data_storage_type, 
                      num_vects, length, process_dir) )
  {
    (void)fprintf(stderr,"ldextract: dunload_vector failed\n");
    return(0);
  }

  for (i=0; i<num_vects; i++)
  {
    free((char*)data[i]);
    free((char*)extract[i]);
  }
  free((char**)data);
  free((char**)extract);

/*
** set startx in image to indicate where the subsignal started.
*/

  image->startx = (long)start;

  return(1);

}  /* end of ldextract */
/* -library_code_end */
