 /*
  * Khoros: $Id: dfiltlp.h,v 1.3 1992/03/20 23:23:31 dkhoros Exp $
  */

 /*
  * $Log: dfiltlp.h,v $
 * Revision 1.3  1992/03/20  23:23:31  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfiltlp.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Mon Mar  9 20:19:05 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dfiltlp_h_
#define _dfiltlp_h_

#include "vinclude.h"


/* -include_includes */
#include "vpoly.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dfiltlp Argument Structure
*
****************************************************************/

typedef struct _dfiltlp  {

/*
 *  resulting output file (ascii polynomial file) (Required outfile)
 */
char	*o_file;	/* resulting output file (ascii polynomial file) FILENAME */
int	 o_flag;	/* resulting output file (ascii polynomial file) FLAG */

/*
 *  sampling frequency in hertz (Optional float)
 */
float	 h_float;	/* sampling frequency in hertz FLOAT */
int	 h_flag;   	/* sampling frequency in hertz FLAG */

/*
 *  digital cutoff frequency in hertz (Optional float)
 */
float	 f1_float;	/* digital cutoff frequency in hertz FLOAT */
int	 f1_flag;   	/* digital cutoff frequency in hertz FLAG */

/*
 *  digital rejection frequency in hertz (Optional float)
 */
float	 f2_float;	/* digital rejection frequency in hertz FLOAT */
int	 f2_flag;   	/* digital rejection frequency in hertz FLAG */

/*
 *  gain at passband edge  (Optional float)
 */
float	 tc_float;	/* gain at passband edge  FLOAT */
int	 tc_flag;   	/* gain at passband edge  FLAG */

/*
 *  gain at stopband edge  (Optional float)
 */
float	 tr_float;	/* gain at stopband edge  FLOAT */
int	 tr_flag;   	/* gain at stopband edge  FLAG */

/*
 * filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) (Optional integer toggle - )
 */
int	 c_toggle;		/* filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) INT TOGGLE */
int	 c_flag;		/* filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) FLAG */

}  dfiltlp_struct;

dfiltlp_struct *dfiltlp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define COEFS_PER_STAGE 6
#define ORDERS_PER_STAGE 2
#define MAXPOLYS 1
#define MAXTERMS 600
#define MAXSTAGES 100
#define STRMAX 100
/* -include_macros_end */

#endif
