 /*
  * Khoros: $Id: mlde.c,v 1.2 1992/03/20 23:45:54 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mlde.c,v 1.2 1992/03/20 23:45:54 dkhoros Exp $";
#endif

 /*
  * $Log: mlde.c,v $
 * Revision 1.2  1992/03/20  23:45:54  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mlde.c
 >>>>
 >>>>      Program Name: mlde
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	solves a system of linear ODE's
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:51:29 1992
 >>>>
 >>>>          Routines: main- the main program for mlde
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "mlde.h"


/****************************************************************
 *
 * Routine Name:  main program for mlde
 *
 *       Input:  
 *      -i1  coefficient matrix 
 *      -i2  constant driving term vector 
 *      -i3  initial value vector 
 *      -o  numerical solution file 
 *
 *
 *      [-t0] initial time 
 *      [-tf] final time 
 *      [-h] time step 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image1, *image2, *image3, *createimage();
float t0,tf,h;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image1 = readimage(mlde->i1_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image1,1,TRUE);

  if((image2 = readimage(mlde->i2_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image2,1,TRUE);

  if((image3 = readimage(mlde->i3_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image3,1,TRUE);
  (void)match_num_bands(program,image1,image2,TRUE);
  (void)match_num_bands(program,image1,image3,TRUE);

  tf = mlde->tf_float;
  t0 = mlde->t0_float;
  h  = mlde->h_float;

/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmlde(image1,image2,image3,t0,tf,h)) {
     (void)fprintf(stderr, "%s: lmlde failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
     writeimage(mlde->o_file,image1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for mlde 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "mlde :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tsolves a system of linear ODE's\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  coefficient matrix  (infile)\n");
	fprintf(stderr,"\t-i2  constant driving term vector  (infile)\n");
	fprintf(stderr,"\t-i3  initial value vector  (infile)\n");
	fprintf(stderr,"\t-o  numerical solution file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t0]  initial time (float) [0]\n");
	fprintf(stderr,"\t[-tf]  final time (float) [1]\n");
	fprintf(stderr,"\t[-h]  time step (float) [0.1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for mlde\n");
	fprintf(stderr, "\t[-U] Gives the usage for mlde\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called mlde.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses mlde.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for mlde
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) coefficient matrix \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) constant driving term vector \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) initial value vector \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) numerical solution file \n        {outfile}: "; 
char	*t0_pstr = 
	"\nEnter: (t0) initial time \n        {float [0.000000] }: "; 
char	*tf_pstr = 
	"\nEnter: (tf) final time \n        {float [1.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) time step \n        {float [0.100000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "mlde", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "mlde.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "mlde: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "mlde.ans");
		}

	     }

	}

	/*
	 * allocate the mlde structure
	 */
	mlde = (mlde_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (mlde_struct));

	/*
	 * get required arguments for mlde
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(mlde->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(mlde->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlde->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    mlde->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(mlde->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mlde->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(mlde->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlde->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    mlde->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(mlde->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mlde->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(mlde->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlde->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    mlde->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(mlde->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mlde->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(mlde->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlde->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    mlde->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(mlde->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for mlde
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	mlde->t0_flag = vget_float(fid, prompt_flag,
	"-t0", t0_pstr, &(mlde->t0_float),
	0.000000, 0.000000, 0.000000);

	mlde->tf_flag = vget_float(fid, prompt_flag,
	"-tf", tf_pstr, &(mlde->tf_float),
	1.000000, 0.000000, 0.000000);

	mlde->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(mlde->h_float),
	0.100000, 0.000000, 0.000000);


}



