 /*
  * Khoros: $Id: lvbilinco.c,v 1.2 1991/10/02 00:03:27 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvbilinco.c,v 1.2 1991/10/02 00:03:27 khoros Exp $";
#endif

 /*
  * $Log: lvbilinco.c,v $
 * Revision 1.2  1991/10/02  00:03:27  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvbilinco.c
 >>>>
 >>>>      Program Name: vbilinco
 >>>>
 >>>> Date Last Updated: Fri Jul 19 15:08:04 1991 
 >>>>
 >>>>          Routines: lvbilinco - the library call for vbilinco
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvbilinco - library call for vbilinco
*
* Purpose:
*    
* Input:
*    
* Output:
*    
*
* Written By: Scott Wilson
*    
****************************************************************/


/* -library_def */
int
lvbilinco(x,y,xp,yp,xc,yc,nobs)
float *x,*y,*xp,*yp,*xc,*yc;
int nobs;
/* -library_def_end */

/* -library_code */
{
  double *p,*ox,*oy,inner();
  double m[4][4];
  double bx[4],by[4];
  float tmp;
  int ipvt[4];
  int lda,n,info,job;
  int i;

  /* Build the VanDermonde matrix P and load the observation vectors too */
  p = (double *)malloc(4*nobs*sizeof(double));
  ox = (double *)malloc(nobs*sizeof(double));
  oy = (double *)malloc(nobs*sizeof(double));
  for (i=0; i<nobs; i++)
    {
      p[0*nobs+i] = 1.0;
      p[1*nobs+i] = x[i];
      p[2*nobs+i] = x[i]*y[i];
      p[3*nobs+i] = y[i];
      ox[i] = xp[i];
      oy[i] = yp[i];
    }

  /* Construct the normal matrix by forming P'P */
  m[0][0] = inner(p+0*nobs,p+0*nobs,nobs); 
  m[0][1] = inner(p+0*nobs,p+1*nobs,nobs); 
  m[0][2] = inner(p+0*nobs,p+2*nobs,nobs); 
  m[0][3] = inner(p+0*nobs,p+3*nobs,nobs); 
  m[1][0] = inner(p+1*nobs,p+0*nobs,nobs); 
  m[1][1] = inner(p+1*nobs,p+1*nobs,nobs); 
  m[1][2] = inner(p+1*nobs,p+2*nobs,nobs); 
  m[1][3] = inner(p+1*nobs,p+3*nobs,nobs); 
  m[2][0] = inner(p+2*nobs,p+0*nobs,nobs); 
  m[2][1] = inner(p+2*nobs,p+1*nobs,nobs); 
  m[2][2] = inner(p+2*nobs,p+2*nobs,nobs); 
  m[2][3] = inner(p+2*nobs,p+3*nobs,nobs); 
  m[3][0] = inner(p+3*nobs,p+0*nobs,nobs); 
  m[3][1] = inner(p+3*nobs,p+1*nobs,nobs); 
  m[3][2] = inner(p+3*nobs,p+2*nobs,nobs); 
  m[3][3] = inner(p+3*nobs,p+3*nobs,nobs); 

  /* Obtain the transformed observation vectors bx = p'ox and by=p'oy */
  bx[0] = inner(p+0*nobs,ox,nobs);
  bx[1] = inner(p+1*nobs,ox,nobs);
  bx[2] = inner(p+2*nobs,ox,nobs);
  bx[3] = inner(p+3*nobs,ox,nobs);
  by[0] = inner(p+0*nobs,oy,nobs);
  by[1] = inner(p+1*nobs,oy,nobs);
  by[2] = inner(p+2*nobs,oy,nobs);
  by[3] = inner(p+3*nobs,oy,nobs);

  /* Free the malloc'd space */
  free(p);
  free(ox);
  free(oy);

  /* Set up the LINPACK parameters */
  lda = 4;
  n = 4; 
  job = 0;

  /* Call DGEFA to get the LU decomposition of M */
  dgefa_(m,&lda,&n,ipvt,&info);

  /* Check for singular matrix */
  if (info != 0)
    {
      fprintf(stderr,"lvbilinco: matrix is singular\n");
      return(0);
    }

  /* Use DGESL to back-solve the triangular system for the coefficients */
  dgesl_(m,&lda,&n,ipvt,bx,&job);
  dgesl_(m,&lda,&n,ipvt,by,&job);

  /* Copy the computed coefficients back to thier homes */
  for (i=0; i<4; i++)
    {
      xc[i] = bx[i];
      yc[i] = by[i];
    }
   /* Re-arrange the coefficients so that vwarp will like them */
  tmp = xc[2];
  xc[2] = xc[3];
  xc[3] = tmp;
  tmp = yc[2];
  yc[2] = yc[3];
  yc[3] = tmp;


  return(1);
}
/* -library_code_end */
