 /*
  * Khoros: $Id: vbilinco.c,v 1.1 1991/05/10 15:52:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vbilinco.c,v 1.1 1991/05/10 15:52:12 khoros Exp $";
#endif

 /*
  * $Log: vbilinco.c,v $
 * Revision 1.1  1991/05/10  15:52:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbilinco.c
 >>>>
 >>>>      Program Name: vbilinco
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute bilinear geometric warp coefficients
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:20:23 1991
 >>>>
 >>>>          Routines: main- the main program for vbilinco
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vbilinco.h"


/****************************************************************
 *
 * Routine Name:  main program for vbilinco
 *
 *       Input:  
 *          -i1  Source tie point image 
 *          -i2  Target tie point image 
 *          -o1  X vwarp coefficients image 
 *          -o2  Y vwarp coefficients image 
 *
 *
 *          [-o3] Tiepoint Error Image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *source,*target,*readimage(),*error,*createimage();
        float *x,*y,*xp,*yp,xc[4],yc[4],*f,*g,*e,xhat,yhat;
        int i,n;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        /* Read the input images (really the tie point coordinates) */
        source = readimage(vbilinco->i1_file);
        if (source == NULL) exit(1);
        target = readimage(vbilinco->i2_file);
        if (target == NULL) exit(1);

        CHECKINPUT(program,source,target);  /* Verify input images */

        /* Check the type and size of both input images. They should be
        VFF_TYP_FLOAT and N rows by 2 columns. */
        if (source->row_size != 2 )
          fprintf(stderr,"vbilinco: source tiepoint image should be 2 rows, N columns\n");
        if (target->row_size != 2 )
          fprintf(stderr,"vbilinco: target tiepoint image should be 2 rows, N columns\n");

        /* Load the input coordinates into thier respective arrays */
        n = source->col_size;
        f = (float *)(source->imagedata);
        g = (float *)(target->imagedata);
        x =  (float *)malloc(n*sizeof(float));
        xp = (float *)malloc(n*sizeof(float));
        y =  (float *)malloc(n*sizeof(float));
        yp = (float *)malloc(n*sizeof(float));
        for (i=0; i<n; i++)
          {
            x[i]  = *f++; y[i]  = *f++;
            xp[i] = *g++; yp[i] = *g++;
          }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvbilinco(x,y,xp,yp,xc,yc,n))
    {
        (void) fprintf(stderr, "lvbilinco Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* Now build an image for the X and Y coefficients */
        /* Assume the colormap stuff is OK */
        source->col_size      = 2;
        source->row_size      = 2;
        source->data_storage_type    = VFF_TYP_FLOAT;
        source->num_of_images    = 1;
        source->num_data_bands    = 1;
        source->map_scheme    = VFF_MS_NONE;
        source->location_type    = VFF_LOC_IMPLICIT;
        source->startx        = VFF_NOTSUB;
        source->starty        = VFF_NOTSUB;

        /* Now write out the coefficient images */
        source->imagedata = (char *)xc;
        writeimage(vbilinco->o1_file,source);
        source->imagedata = (char *)yc;
        writeimage(vbilinco->o2_file,source);

        /* See if the error image is wanted and make it if so */
        if (vbilinco->o3_file != NULL)
          {
            error = createimage(n,2,
                                VFF_TYP_FLOAT,
                                1,1,
                                "vbilinco tiepoint errors",
                                0,0,
                                VFF_MS_NONE,VFF_MAPTYP_NONE,
                                VFF_LOC_IMPLICIT,0);
            e = (float *)(error->imagedata);
            for (i=0; i<n; i++)
              {
                xhat = xc[0]+xc[1]*x[i]+xc[3]*x[i]*y[i]+xc[2]*y[i];
                yhat = yc[0]+yc[1]*x[i]+yc[3]*x[i]*y[i]+yc[2]*y[i];
                *e++ = xp[i]-xhat;
                *e++ = yp[i]-yhat;
              }
            writeimage(vbilinco->o3_file,error); 
          }

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vbilinco 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vbilinco :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute bilinear geometric warp coefficients\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Source tie point image  (infile)\n");
	fprintf(stderr,"\t-i2  Target tie point image  (infile)\n");
	fprintf(stderr,"\t-o1  X vwarp coefficients image  (outfile)\n");
	fprintf(stderr,"\t-o2  Y vwarp coefficients image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o3]  Tiepoint Error Image (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vbilinco\n");
	fprintf(stderr, "\t[-U] Gives the usage for vbilinco\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vbilinco.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vbilinco.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vbilinco
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Source tie point image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Target tie point image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) X vwarp coefficients image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) Y vwarp coefficients image \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) Tiepoint Error Image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vbilinco", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vbilinco.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vbilinco: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vbilinco.ans");
		}

	     }

	}

	/*
	 * allocate the vbilinco structure
	 */
	vbilinco = (vbilinco_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vbilinco_struct));

	/*
	 * get required arguments for vbilinco
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vbilinco->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vbilinco->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbilinco->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vbilinco->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vbilinco->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbilinco->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vbilinco->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbilinco->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vbilinco->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vbilinco->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbilinco->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vbilinco->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbilinco->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vbilinco->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vbilinco->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbilinco->o2_flag = vget_outfile(fid, prompt_flag,
			"-o2", o2_pstr, &(vbilinco->o2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbilinco->o2_flag))
		{
		    fprintf(stderr, "\t\to2 is required, please re-enter: \n");
		    vbilinco->o2_flag = vget_outfile(fid, prompt_flag,
		    "-o2", o2_pstr, &(vbilinco->o2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vbilinco
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vbilinco->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vbilinco->o3_file))
;


}



