 /*
  * Khoros: $Id: lvabs.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvabs.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvabs.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvabs.c
 >>>>
 >>>>      Program Name: vabs
 >>>>
 >>>> Date Last Updated: Thu Mar 28 10:30:52 1991 
 >>>>
 >>>>          Routines: lvabs - the library call for vabs
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvabs - library call for vabs
*
* Purpose:
*    
*    Computes the absolute value of an image.
*    
*    
* Input:
*    
*         1.  img -- xvimage structure
*    
*    
* Output:
*    
*         1.  img -- xvimage structure img is used for both the  input
*         xvimage  structure  and the output result xvimage structure.
*         This is done to save space, but you must be careful  not  to
*         overwrite important data.
*    
*         lvabs returns a zero upon failure.
*    
*    
*
* Written By: Pascal ADAM 
****************************************************************/


/* -library_def */
int
lvabs(img)
struct xvimage *img;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i;
    short  *s;
    float  *f;
    unsigned char *c;

    /* Normal operation count */
    k = img->row_size*img->col_size * img->num_data_bands;          

    switch (img->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvabs: Don't know how to compute the absolute value of a BIT image\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c = (unsigned char *)(img->imagedata);
          for (j=0; j<k; j++) { if (*c < 0) *c = - *c; c++; }
          break;
        case VFF_TYP_2_BYTE :
          s = (short *)(img->imagedata);
          for (j=0; j<k; j++) { if (*s < 0) *s = - *s; s++; }
          break;
        case VFF_TYP_4_BYTE :
          i = (int *)(img->imagedata);
          for (j=0; j<k; j++) { if (*i < 0) *i = - *i; i++; }
          break;
        case VFF_TYP_FLOAT :
          f = (float *)(img->imagedata);
          for (j=0; j<k; j++) { if (*f < 0) *f = - *f; f++; }
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvabs: Don't know how to complement COMPLEX images (yet)\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvabs: Unknown data storage type, %d\n",img->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
