 /*
  * Khoros: $Id: lvfileinfo.c,v 1.3 1992/03/20 23:05:21 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvfileinfo.c,v 1.3 1992/03/20 23:05:21 dkhoros Exp $";
#endif

 /*
  * $Log: lvfileinfo.c,v $
 * Revision 1.3  1992/03/20  23:05:21  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvfileinfo.c
 >>>>
 >>>>      Program Name: vfileinfo
 >>>>
 >>>> Date Last Updated: Fri Feb 14 20:34:35 1992 
 >>>>
 >>>>          Routines: lvfileinfo - the library call for vfileinfo
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvfileinfo - library call for vfileinfo
*
* Purpose:
*    
*    Gives information about an Khoros Image File (xviff)
*    
*    

* Input:
*    
*         struct xvimage *image: VIFF image
*    
*         char    *input_file: Name of the VIFF image
*    
*         FILE    *printdev: Output File to output informations
*    
*    

* Output:
*    
*         FILE    *printdev: Holds the result.
*    
*    

*
* Written By: Argiro, Young, Neher, Rasure
*    
*    7-Feb-91 Scott Wilson - Added DOUBLE and DCOMPLEX data types.
*    
*    20-Feb-91 Scott Wilson - Changed output format on pixel  size  to
*    %g from %f.
*    
*    

****************************************************************/


/* -library_def */
int lvfileinfo(image, input_file, printdev)
struct xvimage *image;
char    *input_file;
FILE    *printdev;
/* -library_def_end */

/* -library_code */
{

    (void) fprintf(printdev,"\nFile Name: %s\n", input_file);

    switch (image->file_type)
    {
        case XV_FILE_TYPE_XVIFF:
            (void) fprintf(printdev,"\nFile Type: khoros image file format\n");
            break;
        default:
            (void) fprintf(printdev,"\nFile Type: Unknown\n");
            break;
    }
    (void) fprintf(printdev,"KHOROS identifier: %d\n", image->identifier);
    (void) fprintf(printdev,"KHOROS version/release: %d.%d\n",
        image->version,image->release);
    (void) fprintf(printdev,"\n\t\t\t  Description:\n\n%s\n\t\t\tEnd Description\n\n",
           image->comment);

    switch(image->data_storage_type)
    {
        case VFF_TYP_BIT :
          (void) fprintf(printdev,"  File data storage type: BIT\n");
          break;
        case VFF_TYP_1_BYTE :
          (void) fprintf(printdev,"  File data storage type: BYTE\n");
          break;
        case VFF_TYP_2_BYTE :
          (void) fprintf(printdev,"  File data storage type: SHORT\n");
          break;
        case VFF_TYP_4_BYTE :
          (void) fprintf(printdev,"  File data storage type: INTEGER\n");
          break;
        case VFF_TYP_FLOAT :
          (void) fprintf(printdev,"  File data storage type: FLOAT\n");
          break;
        case VFF_TYP_DOUBLE :
          (void) fprintf(printdev,"  File data storage type: DOUBLE\n");
          break;
        case VFF_TYP_COMPLEX :
          (void) fprintf(printdev,"  File data storage type: COMPLEX\n");
          break;
        case VFF_TYP_DCOMPLEX :
          (void) fprintf(printdev,"  File data storage type: DCOMPLEX\n");
          break;
        default :
          (void) fprintf(printdev," File data storage type: Unknown\n");
          break;
    }
    (void) fprintf(printdev,"  Number of pixels per band: \
%d rows by %d columns or %d pixels\n",
        image->col_size,image->row_size,
        (image->col_size*image->row_size));
    (void) fprintf(printdev,"  Pixel subrow size: %d\n",image->subrow_size);
    (void) fprintf(printdev,"  Number of images per file: %d\n", image->num_of_images);
    (void) fprintf(printdev,"  Number of bands per image pixel: %d\n",
        image->num_data_bands);
    if (image->startx != VFF_NOTSUB && image->starty != VFF_NOTSUB)
    {
        (void) fprintf(printdev,"  Subimage: YES (coordinates in original \
File: (%d,%d) to (%d,%d)).\n",
               image->startx,image->starty,
               image->startx+image->row_size-1,
               image->starty+image->col_size-1);
    }
    else
    {
        (void) fprintf(printdev,"  Subimage: NO\n");
    }
    switch(image->data_encode_scheme)
    {
        case VFF_DES_RAW :
          (void) fprintf(printdev,"  File Data Compression: NONE\n");
          break;
        case VFF_DES_COMPRESS :
          (void) fprintf(printdev,"  File Data Compression: compress(1)\n");
          break;
        case VFF_DES_RLE :
          (void) fprintf(printdev,"  File Data Compression: RLE\n");
          break;
        case VFF_DES_TRANSFORM :
          (void) fprintf(printdev,"  File Data Compression: Transform based\n");
          break;
        case VFF_DES_CCITT :
          (void) fprintf(printdev,"  File Data Compression: CCITT\n");
          break;
        case VFF_DES_ADPCM :
          (void) fprintf(printdev,"  File Data Compression: ADPCM\n");
          break;
        case VFF_DES_GENERIC :
          (void) fprintf(printdev,"  File Data Compression: User-specified\n");
          break;
        default :
          (void) fprintf(printdev,"  File Data Compression: Unknown\n");
          break;
    }
    (void) fprintf(printdev,"  Pixel size: %g (x) by %g (y) meters\n",
        image->pixsizx,image->pixsizy);
    switch(image->machine_dep)
    {
        case VFF_DEP_IEEEORDER :
            (void) fprintf(printdev,"  Machine dependency: IEEE\n");
            break;
        case VFF_DEP_DECORDER :
            (void) fprintf(printdev,"  Machine dependency: DEC\n");
            break;
        case VFF_DEP_NSORDER :
            (void) fprintf(printdev,"  Machine dependency: NS32000 or MIPS(DEC 3100)\n");
            break;
        case VFF_DEP_CRAYORDER :
            (void) fprintf(printdev,"  Machine dependency: CRAY\n");
            break;
        default:
            (void) fprintf(printdev,"  Machine dependency: Unknown\n");
            break;
    }
    switch(image->color_space_model)
    {
         case VFF_CM_NONE :
           (void) fprintf(printdev,"  Color space model: NONE\n");
           break;
         case VFF_CM_ntscRGB :
           (void) fprintf(printdev,"  Color space model: ntscRGB\n");
           break;
         case VFF_CM_ntscCMY :
           (void) fprintf(printdev,"  Color space model: ntscCMY\n");
           break;
         case VFF_CM_ntscYIQ :
           (void) fprintf(printdev,"  Color space model: ntscYIQ\n");
           break;
         case VFF_CM_HSV :
           (void) fprintf(printdev,"  Color space model: HSV\n");
           break;
         case VFF_CM_HLS :
           (void) fprintf(printdev,"  Color space model: HLS\n");
           break;
         case VFF_CM_IHS :
           (void) fprintf(printdev,"  Color space model: IHS\n");
           break;
         case VFF_CM_cieRGB :
           (void) fprintf(printdev,"  Color space model: cieRGB\n");
           break;
         case VFF_CM_cieUVW :
           (void) fprintf(printdev,"  Color space model: cieUVW\n");
           break;
         case VFF_CM_cieXYZ :
           (void) fprintf(printdev,"  Color space model: cieXYZ\n");
           break;
         case VFF_CM_cieucsUVW :
           (void) fprintf(printdev,"  Color space model: cieucsUVW\n");
           break;
         case VFF_CM_cieucsSOW :
           (void) fprintf(printdev,"  Color space model: cieucsSOW\n");
           break;
         case VFF_CM_cieucsLab :
           (void) fprintf(printdev,"  Color space model: cieucsLab\n");
           break;
         case VFF_CM_cieucsLuv :
           (void) fprintf(printdev,"  Color space model: cieucsLuv\n");
           break;
         case VFF_CM_GENERIC :
           (void) fprintf(printdev,"  Color space model: GENERIC\n");
           break;
         case VFF_CM_genericRGB :
           (void) fprintf(printdev,"  Color space model: genericRGB\n");
           break;
         default :
           (void) fprintf(printdev," Color space model: Unknown\n");
           break;
    }
    switch (image->map_scheme)
    {
        case VFF_MS_NONE:
            (void) fprintf(printdev,"  Data Band Mapping scheme: NONE\n");
            break;
        case VFF_MS_ONEPERBAND:
            (void) fprintf(printdev,"  Data Band Mapping scheme: ONE PER BAND\n");
            break;
        case VFF_MS_CYCLE:
            (void) fprintf(printdev,"  Data Band Mapping scheme: CYCLE \n");
            break;
        case VFF_MS_SHARED:
            (void) fprintf(printdev,"  Data Band Mapping scheme: SHARED \n");
            break;
        case VFF_MS_GROUP:
            (void) fprintf(printdev,"  Data Band Mapping scheme: GROUP \n");
            break;
        default:
            (void) fprintf(printdev,"  Data Band Mapping scheme: Unknown\n");
            break;
    }
    if (image->map_scheme == VFF_MS_NONE)
    {
        (void) fprintf(printdev,"\nThe following map fields are not used because the \
map scheme is set to none\n\n");
    }
    switch (image->map_storage_type)
    {
        case VFF_MAPTYP_NONE:
            (void) fprintf(printdev,"   Map storage type: NONE\n");
            break;
        case VFF_MAPTYP_1_BYTE:
            (void) fprintf(printdev,"   Map storage type: BYTE\n");
            break;
        case VFF_MAPTYP_2_BYTE:
            (void) fprintf(printdev,"   Map storage type:  TWO BYTE\n");
            break;
        case VFF_MAPTYP_4_BYTE:
            (void) fprintf(printdev,"   Map storage type:  FOUR BYTE\n");
            break;
        case VFF_MAPTYP_FLOAT:
            (void) fprintf(printdev,"   Map storage type:  FLOAT (single precision)\n");
            break;
        case VFF_MAPTYP_DOUBLE:
            (void) fprintf(printdev,"   Map storage type:  DOUBLE (double precision)\n");
            break;
        case VFF_MAPTYP_COMPLEX:
            (void) fprintf(printdev,"   Map storage type:  COMPLEX FLOAT\n");
            break;
        default:
            (void) fprintf(printdev,"   Map storage type:  Unknown\n");
            break;
    }
    (void) fprintf(printdev,"   Map row size: %d\n", image->map_row_size);
    (void) fprintf(printdev,"   Map col size: %d\n", image->map_col_size);
    (void) fprintf(printdev,"   Map subrow size: %d\n", image->map_subrow_size);
    (void) fprintf(printdev,"   Maps per cycle: %d\n", image->maps_per_cycle);
    switch (image->map_enable)
    {
        case VFF_MAP_OPTIONAL:
            (void) fprintf(printdev,"   Enable the Map: OPTIONAL\n");
            break;
        case VFF_MAP_FORCE:
            (void) fprintf(printdev,"   Enable the Map: FORCE\n");
            break;
        default:
            (void) fprintf(printdev,"   Enable the Map: Unknown\n");
            break;
    }
    (void) fprintf(printdev,"\n");

    switch (image->location_type)
    {
        case VFF_LOC_IMPLICIT:
            (void) fprintf(printdev,"  Location of Data: IMPLICIT\n");
            break;
        case VFF_LOC_EXPLICIT:
            (void) fprintf(printdev,"  Location of Data: EXPLICIT\n");
            break;
        default:
            (void) fprintf(printdev,"  Location of Data: Unknown\n");
            break;
    }
    if (image->location_type == VFF_LOC_IMPLICIT)
    {
        (void) fprintf(printdev,"\nThe following fields are not used because the \
location type is implicit\n\n");
    }
    switch (image->location_dim)
    {
        case 0:
            (void) fprintf(printdev,"   Dimension Location: 0D (NONE)\n");
            break;
        case 1:
            (void) fprintf(printdev,"   Dimension Location: 1D\n");
            break;
        case 2:
            (void) fprintf(printdev,"   Dimension Location: 2D\n");
            break;
        case 3:
            (void) fprintf(printdev,"   Dimension Location: 3D\n");
            break;
        default:
            (void) fprintf(printdev,"   Dimension Location: Unknown\n");
            break;
    }

#ifdef DEBUG
    (void) fprintf(stderr,"\n");
    (void) fprintf(stderr,"identifier: %d\n", image->identifier);
    (void) fprintf(stderr,"file_type: %d\n", image->file_type);
    (void) fprintf(stderr,"version: %d\n", image->version);
    (void) fprintf(stderr,"relase: %d\n", image->release);
    (void) fprintf(stderr,"machine_dep: %d\n", image->machine_dep);
    (void) fprintf(stderr,"comment: %s\n", image->comment);
    (void) fprintf(stderr,"row_size: %d\n", image->row_size);
    (void) fprintf(stderr,"column size: %d\n", image->col_size);
    (void) fprintf(stderr,"startx: %d\n", image->startx);
    (void) fprintf(stderr,"starty: %d\n", image->starty);
    (void) fprintf(stderr,"pixsizx: %g\n", image->pixsizx);
    (void) fprintf(stderr,"pixsizy: %g\n", image->pixsizy);
    (void) fprintf(stderr,"location_type: %d\n", image->location_type);
    (void) fprintf(stderr,"location_dim: %d\n", image->location_dim);
    (void) fprintf(stderr,"num_of_images: %d\n", image->num_of_images);
    (void) fprintf(stderr,"num_data_bands: %d\n", image->num_data_bands);
    (void) fprintf(stderr,"data_storage_type: %d\n", image->data_storage_type);
    (void) fprintf(stderr,"data_encode_scheme: %d\n", image->data_encode_scheme);
    (void) fprintf(stderr,"map_scheme: %d\n", image->map_scheme);
    (void) fprintf(stderr,"map_storage_type: %d\n", image->map_storage_type);
    (void) fprintf(stderr,"map_row_size: %d\n", image->map_row_size);
    (void) fprintf(stderr,"map_col_size: %d\n", image->map_col_size);
    (void) fprintf(stderr,"map_subrow_size: %d\n", image->map_subrow_size);
    (void) fprintf(stderr,"map_enable: %d\n", image->map_enable);
    (void) fprintf(stderr,"maps_per_cycle: %d\n", image->maps_per_cycle);
    (void) fprintf(stderr,"color_space_model: %d\n", image->color_space_model);
    (void) fprintf(stderr,"ispare1: %d\n", image->ispare1);
    (void) fprintf(stderr,"ispare2: %d\n", image->ispare2);
    (void) fprintf(stderr,"fspare1: %g\n", image->fspare1);
    (void) fprintf(stderr,"fspare2: %g\n", image->fspare2);
    (void) fprintf(stderr,"reserve: %s\n", image->reserve);
    (void) fprintf(stderr,"");
#endif
    (void) printf("\n\n");
    return(1);
}
/* -library_code_end */
