 /*
  * Khoros: $Id: lvgcirc.c,v 1.2 1991/12/18 09:23:43 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgcirc.c,v 1.2 1991/12/18 09:23:43 dkhoros Exp $";
#endif

 /*
  * $Log: lvgcirc.c,v $
 * Revision 1.2  1991/12/18  09:23:43  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgcirc.c
 >>>>
 >>>>      Program Name: vgcirc
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:22:52 1991 
 >>>>
 >>>>          Routines: lvgcirc - the library call for vgcirc
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgcirc - library call for vgcirc
*
* Purpose:
*    
*    Creates an image of a filled circle
*    
*    

* Input:
*    
*    image          input image structure
*    
*    rows           the desired number of rows in output image
*    
*    cols           the desired number of columns in output image
*    
*    type           the data storage type of the resulting image
*    
*    bgnd           the background intensity
*    
*    fgnd           the forground intensity
*    
*    x              the X coordinate of the center of the circle
*    
*    y              the Y coordinate of the center of the circle
*    
*    d              diameter of circle (in pixels)
*    
*    

* Output:
*    
*    image          holds the resulting output image.
*    
*    

*
* Written By: Scott Wilson
*    
*    

****************************************************************/


/* -library_def */
int
lvgcirc (image, rows, cols, type, bgnd, fgnd, x, y, d)
struct xvimage **image;
int rows, cols, type;
float bgnd,fgnd,x,y,d;
/* -library_def_end */

/* -library_code */
{
  int i,j;
  unsigned char *c;
  float *f,r;
  struct xvimage *img, *createimage();

  img   = createimage((unsigned long) rows,  /* number of rows */
                     (unsigned long) cols,   /* number of columns */
                     (unsigned long) type,   /* data storage type */
                     (unsigned long) 1,      /* num_of_images */
                     (unsigned long) 1,      /* num_data_bands */
                     "created by vgcirc",    /* comment */
                     (unsigned long) 0,      /* map_row_size */
                     (unsigned long) 0,      /* map_col_size */
                     (unsigned long)
                     VFF_MS_NONE,            /* map_scheme */
                     (unsigned long)
                     VFF_MAPTYP_NONE,        /* map_storage_type */
                     (unsigned long)
                     VFF_LOC_IMPLICIT,       /* location_type */
                     (unsigned long) 0);     /* location_dim */


  if (img == NULL)
    {
      fprintf(stderr,"lvgcirc: Unable to allocate new image!\n");
      *image = NULL;
      return(0);
    }

  *image = img;
  r = d/2.0;
  r = r*r;

  switch(type)
    {
      case VFF_TYP_1_BYTE:
        c = (unsigned char *)(img->imagedata);
        for (i=0; i<rows; i++)
          for (j=0; j<cols; j++)
            if ((i-y)*(i-y)+(j-x)*(j-x) <= r) *c++ = fgnd;
            else *c++ = bgnd;
        break;
      case VFF_TYP_FLOAT:
        f = (float *)(img->imagedata);
        for (i=0; i<rows; i++)
          for (j=0; j<cols; j++)
            if ((i-y)*(i-y)+(j-x)*(j-x) <= r) *f++ = fgnd;
            else *f++ = bgnd;
        break;
      default:
        fprintf(stderr,"lvgcirc: Unsupported data storage type requested\n");
        fprintf(stderr,"         Supported types: BYTE and FLOAT\n");
        return(0);
    }

  return(1);
}
/* -library_code_end */
