 /*
  * Khoros: $Id: vcltrans.c,v 1.1 1991/05/10 15:46:25 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcltrans.c,v 1.1 1991/05/10 15:46:25 khoros Exp $";
#endif

 /*
  * $Log: vcltrans.c,v $
 * Revision 1.1  1991/05/10  15:46:25  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcltrans.c
 >>>>
 >>>>      Program Name: vcltrans
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Tristimulus to tristimulus color space conversions
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner, Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:21:41 1991
 >>>>
 >>>>          Routines: main- the main program for vcltrans
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcltrans.h"


/****************************************************************
 *
 * Routine Name:  main program for vcltrans
 *
 *       Input:  
 *          -i  input image 
 *          -o  output resulting image 
 *
 *
 *          [-n] specifies normalization factor  (value > 0.0)
 *          [-t] lets user chose color space model
 *		1 (ntscRGB),
 *		2 (genericRGB),
 *		3 (ntscYIQ),
 *		4 (ntscCMY),
 *		5 (cieXYZ),
 *		or 6 (cieUVW)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *dummy=NULL, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READINPUT (image);
CHECKINPUT (program, image);
CHECKCOLORMODEL (program, image);
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvcltrans(image, vcltrans->t_toggle, vcltrans->t_flag, vcltrans->n_float, vcltrans->n_flag, 0, dummy))
 {
    (void) fprintf(stderr, "lvcltrans Failed\\n");
    exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vcltrans->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcltrans 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcltrans :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTristimulus to tristimulus color space conversions\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  specifies normalization factor (float, > 0.0) [255]\n");
	fprintf(stderr, "\t[-t]  lets user chose color space model\n");
	fprintf(stderr, "\t\t1  (ntscRGB),\n");
	fprintf(stderr, "\t\t2  (genericRGB),\n");
	fprintf(stderr, "\t\t3  (ntscYIQ),\n");
	fprintf(stderr, "\t\t4  (ntscCMY),\n");
	fprintf(stderr, "\t\t5  (cieXYZ),\n");
	fprintf(stderr, "\t\tor 6  (cieUVW)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcltrans\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcltrans\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcltrans.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcltrans.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcltrans
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output resulting image \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies normalization factor \n        {float, > 0.0 [255.000000] }: "; 
char	*t_pstr = "\nEnter: (t) lets user chose color space model -- \n      \t\t1 (ntscRGB)\n\t\t2 (genericRGB)\n\t\t3 (ntscYIQ)\n\t\t4 (ntscCMY)\n\t\t5 (cieXYZ)\n\t\tor 6 (cieUVW)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcltrans", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcltrans.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcltrans: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcltrans.ans");
		}

	     }

	}

	/*
	 * allocate the vcltrans structure
	 */
	vcltrans = (vcltrans_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcltrans_struct));

	/*
	 * get required arguments for vcltrans
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcltrans->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vcltrans->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcltrans->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vcltrans->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vcltrans->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcltrans->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vcltrans->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcltrans->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vcltrans->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vcltrans->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcltrans
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcltrans->n_flag = vget_float(fid, prompt_flag,
	"-n", n_pstr, &(vcltrans->n_float),
	255.000000, 2.000000, 2.000000);


	/*
	 * get optional toggles for vcltrans
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vcltrans->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vcltrans->t_toggle),
		1, 0, 0);

		if ((vcltrans->t_toggle == 1 ) || 
		    (vcltrans->t_toggle == 2 ) || 
		    (vcltrans->t_toggle == 3 ) || 
		    (vcltrans->t_toggle == 4 ) || 
		    (vcltrans->t_toggle == 5 ) || 
		    (vcltrans->t_toggle == 6 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vcltrans->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vcltrans->t_toggle),
		1, 0, 0);

		if ((vcltrans->t_toggle != 1 ) && 
		    (vcltrans->t_toggle != 2 ) && 
		    (vcltrans->t_toggle != 3 ) && 
		    (vcltrans->t_toggle != 4 ) && 
		    (vcltrans->t_toggle != 5 ) && 
		    (vcltrans->t_toggle != 6 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



