 /*
  * Khoros: $Id: vhpf.h,v 1.1 1991/05/10 15:47:53 khoros Exp $
  */

 /*
  * $Log: vhpf.h,v $
 * Revision 1.1  1991/05/10  15:47:53  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhpf.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Thu Mar 28 00:02:09 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vhpf_h_
#define _vhpf_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vhpf Argument Structure
*
****************************************************************/

typedef struct _vhpf  {

/*
 *  first input image (Required infile)
 */
char	*i_file;	/* first input image FILENAME */
int	 i_flag;	/* first input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  selects the order of the filter (Required integer)
 */
int	 n_int; 	/* selects the order of the filter INT */
int	 n_flag;	/* selects the order of the filter FLAG */

/*
 *  selects the cut off radius (Required float)
 */
float	 c_float;	/* selects the cut off radius FLOAT */
int	 c_flag;   	/* selects the cut off radius FLAG */

/*
 *  Choose Exponential Filter [False] or Butterworth Filter [True] (Optional logical)
 */
int	 t_logic;	/* Choose Exponential Filter [False] or Butterworth Filter [True] LOGIC */
int	 t_flag;  	/* Choose Exponential Filter [False] or Butterworth Filter [True] FLAG */

}  vhpf_struct;

vhpf_struct *vhpf;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
data_storage_type = VFF_TYP_COMPLEX
map_enable = VFF_MAP_OPTIONAL
*/

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        \
        (void) propertype(program,img1,VFF_TYP_COMPLEX,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
