 /*
  * Khoros: $Id: vinsert.c,v 1.1 1991/05/10 15:51:21 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vinsert.c,v 1.1 1991/05/10 15:51:21 khoros Exp $";
#endif

 /*
  * $Log: vinsert.c,v $
 * Revision 1.1  1991/05/10  15:51:21  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vinsert.c
 >>>>
 >>>>      Program Name: vinsert
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Insert a (sub)image into another image.
 >>>>	
 >>>>	
 >>>>            Author: John Rasure, Tom Sauer, Mark Young
 >>>>
 >>>> Date Last Updated: Thu Mar  7 15:56:05 1991
 >>>>
 >>>>          Routines: main- the main program for vinsert
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinsert.h"


/****************************************************************
 *
 * Routine Name:  main program for vinsert
 *
 *       Input:  
 *         -i1  input image 
 *         -i2  second input image 
 *         -o  resulting combined image 
 *
 *
 *         [-x] insert subimage beginning at upper left x coordinate  (value >= 0)
 *         [-y] insert subimage beginning at upper left y coordinate  (value >= 0)
 *         [-l] image real constant pad level  (value >= 0.0)
 *         [-m] image imaginary constant pad level  (value >= 0.0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1,*img2,*images[2], *readimage();
int  num_images, up_type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

num_images = 0;      /* initialize counter */

READINPUT1(img1, program);
images[num_images++] = img1;
READINPUT2(img2, program);
images[num_images++] = img2;

CHECKINPUT(program, img1, img2);

up_type = -1;       /* call lvcast with auto upconvert set */

if (! lvcast(images, num_images, up_type) )
{
  (void) fprintf(stderr, "ERROR: images could not be cast to the same type\n");
  exit(1);
}

/*  The default placement is where the subimage came from */
if (vinsert->x_flag == 0 && img2->startx >= 0) 
    vinsert->x_int = img2->startx;
if (vinsert->y_flag == 0 && img2->starty >= 0) 
    vinsert->y_int = img2->starty;

/* -main_before_lib_call_end */

/* -main_library_call */
/* Call the procedure that does the work */

if(! lvinsert(img1,img2,vinsert->x_int,vinsert->y_int, vinsert->l_float, vinsert->m_float) )
 {
    (void) fprintf(stderr, "lvinsert Failed\n");
    exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(vinsert->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vinsert 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vinsert :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tInsert a (sub)image into another image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  second input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting combined image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  insert subimage beginning at upper left x coordinate (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-y]  insert subimage beginning at upper left y coordinate (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-l]  image real constant pad level (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-m]  image imaginary constant pad level (float, >= 0.0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vinsert\n");
	fprintf(stderr, "\t[-U] Gives the usage for vinsert\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vinsert.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vinsert.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vinsert
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) second input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting combined image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) insert subimage beginning at upper left x coordinate \n        {integer, >= 0 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) insert subimage beginning at upper left y coordinate \n        {integer, >= 0 [0] }: "; 
char	*l_pstr = 
	"\nEnter: (l) image real constant pad level \n        {float, >= 0.0 [0.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) image imaginary constant pad level \n        {float, >= 0.0 [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vinsert", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vinsert.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vinsert: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vinsert.ans");
		}

	     }

	}

	/*
	 * allocate the vinsert structure
	 */
	vinsert = (vinsert_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vinsert_struct));

	/*
	 * get required arguments for vinsert
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vinsert->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vinsert->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vinsert->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vinsert->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vinsert->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vinsert->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vinsert->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vinsert->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vinsert->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vinsert->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vinsert->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vinsert->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vinsert->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vinsert->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vinsert->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vinsert
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vinsert->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vinsert->x_int),
	0, 1, 1);

	vinsert->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vinsert->y_int),
	0, 1, 1);

	vinsert->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vinsert->l_float),
	0.000000, 1.000000, 1.000000);

	vinsert->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(vinsert->m_float),
	0.000000, 1.000000, 1.000000);


}



