 /*
  * Khoros: $Id: vfht.c,v 1.1 1991/05/10 15:51:33 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vfht.c,v 1.1 1991/05/10 15:51:33 khoros Exp $";
#endif

 /*
  * $Log: vfht.c,v $
 * Revision 1.1  1991/05/10  15:51:33  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfht.c
 >>>>
 >>>>      Program Name: vfht
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Take the 2-D Fast Hadamard Transform of an image.
 >>>>	
 >>>>	
 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:41:27 1991
 >>>>
 >>>>          Routines: main- the main program for vfht
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vfht.h"


/****************************************************************
 *
 * Routine Name:  main program for vfht
 *
 *       Input:  
 *      -i  input image (xviff file) 
 *      -o  output image (xviff file) 
 *
 *
 *      [-s] scale output by 1/N (0 = no scale, 1 = scale)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    img = readimage (vfht->i_file);
    if (img==NULL) {
        fprintf (stderr,"error in vfht: could not read %s: ",vfht->i_file);
        fprintf (stderr,"exiting with an error\n");
        exit(1);
    }

    CHECKINPUT (program, img);

    if (!powtwo(img->row_size)) {
        fprintf (stderr, "error in vfht: row length of the input image must");
        fprintf (stderr, " be a power of two: exiting with an error\n");
        exit(1);
    }
    if (!powtwo(img->col_size)) {
        fprintf (stderr, "error in vfht: col length of the input image must");
        fprintf (stderr, " be a power of two: exiting with an error\n");
        exit(1);
    }

    if (img->data_storage_type != VFF_TYP_FLOAT) {
        if (!lvconvert (img, VFF_TYP_FLOAT, 0, 1, 0.0, 1.0, 0)) {
            fprintf (stderr, "error in vfht: call to lvconvert failed\n");
            exit (1);
        }
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if (lvfht(img, vfht->s_logic)!=1) {
        fprintf (stderr, "error in vfht: library call to lvfht failed: ");
        fprintf (stderr, "exiting with an error\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage (vfht->o_file, img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vfht 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vfht :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTake the 2-D Fast Hadamard Transform of an image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  output image (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  scale output by 1/N (0 = no scale, 1 = scale) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vfht\n");
	fprintf(stderr, "\t[-U] Gives the usage for vfht\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vfht.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vfht.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vfht
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image (xviff file) \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) scale output by 1/N (0 = no scale, 1 = scale) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vfht", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vfht.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vfht: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vfht.ans");
		}

	     }

	}

	/*
	 * allocate the vfht structure
	 */
	vfht = (vfht_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vfht_struct));

	/*
	 * get required arguments for vfht
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vfht->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vfht->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vfht->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vfht->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vfht->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vfht->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vfht->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vfht->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vfht->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vfht->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vfht
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vfht->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vfht->s_logic), 0);


}



