 /*
  * Khoros: $Id: box.c,v 1.2 1991/07/15 06:00:07 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: box.c,v 1.2 1991/07/15 06:00:07 khoros Exp $";
#endif

 /*
  * $Log: box.c,v $
 * Revision 1.2  1991/07/15  06:00:07  khoros
 * HellPatch1
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: box.c
   >>>>                    
   >>>>   description: This file contains routines to draw a box
   >>>>			box around the plot for both 2D and 3D    
   >>>>                  
   >>>>      routines: 	
   >>>>			draw_box_2D
   >>>>			draw_box_3D
   >>>>                
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME: draw_box_2D
*
*      PURPOSE: draws a box around the plot
*
*        INPUT: gwin - pointer to the VPGraphicsWindow structure
*
*       OUTPUT: none
*
*    CALLED BY: plot_routine
*
*   WRITTEN BY: Tom Sauer
*
*
*************************************************************/


draw_box_2D()
{
	Coord	    border[5];
        int colorindex;

        /*
         *  Reset the graphic context back to a solid line so that we can
         *  draw the box outline.
         */

	X3D_set_line_type(gwin->id, Solid);
        if (xp_device != xpX11)
	    X3D_set_line_width(gwin->id, ExtraWide);

	/* set the points for the box */	
	border[0].y = gwin_attr->disp_scale_min.y; border[0].x = gwin_attr->disp_scale_max.x;
	border[1].y = gwin_attr->disp_scale_max.y; border[1].x = gwin_attr->disp_scale_max.x;
	border[2].y = gwin_attr->disp_scale_max.y; border[2].x = gwin_attr->disp_scale_min.x;
	border[3].y = gwin_attr->disp_scale_min.y; border[3].x = gwin_attr->disp_scale_min.x;
	border[4].y = gwin_attr->disp_scale_min.y; border[4].x = gwin_attr->disp_scale_max.x;

        colorindex = gwin_attr->current_colors[GRID_COLOR];
	X2D_draw_polyline(gwin->id, border, 5, &Colors[colorindex]); 
        if (xp_device != xpX11)
	    X3D_set_line_width(gwin->id, MediumFine);

	/*
	 *  Clean up.  Reset the graphic context back to a solid line and
	 *  free up the malloc'ed grid_lines.
	 */
	XFlush(display);
}



/************************************************************
*
*  MODULE NAME: draw_box_3D
*
*      PURPOSE: draws a box around the plot
*
*        INPUT: gwin - pointer to the VPGraphicsWindow structure
*
*       OUTPUT: none
*
*    CALLED BY: plot_routine
*
*   WRITTEN BY: Tom Sauer
*
*
*************************************************************/


draw_box_3D()
{
	Coord	    border[11];
	int	    colorindex;

	/*
	 *  Reset the graphic context back to a solid line so that we can
	 *  draw the box outline.
	 */

	X3D_set_line_type(gwin->id, Solid);
        if (xp_device != xpX11)
	    X3D_set_line_width(gwin->id, ExtraWide);

	/* now draw the border for the grid (cube) */
	border[0].x = gwin_attr->disp_scale_min.x;
	border[0].y = gwin_attr->disp_scale_min.y;  
	border[0].z = gwin_attr->disp_scale_min.z;
	border[1].x = gwin_attr->disp_scale_min.x;
	border[1].y = gwin_attr->disp_scale_min.y;  
	border[1].z = gwin_attr->disp_scale_max.z;
	border[2].x = gwin_attr->disp_scale_min.x;
	border[2].y = gwin_attr->disp_scale_max.y;  
	border[2].z = gwin_attr->disp_scale_max.z;
	border[3].x = gwin_attr->disp_scale_min.x;
	border[3].y = gwin_attr->disp_scale_max.y;  
	border[3].z = gwin_attr->disp_scale_min.z;
	border[4].x = gwin_attr->disp_scale_min.x;
	border[4].y = gwin_attr->disp_scale_min.y;  
	border[4].z = gwin_attr->disp_scale_min.z;
	border[5].x = gwin_attr->disp_scale_max.x;
	border[5].y = gwin_attr->disp_scale_min.y;  
	border[5].z = gwin_attr->disp_scale_min.z;
	border[6].x = gwin_attr->disp_scale_max.x;
	border[6].y = gwin_attr->disp_scale_max.y;  
	border[6].z = gwin_attr->disp_scale_min.z;
	border[7].x = gwin_attr->disp_scale_min.x;
	border[7].y = gwin_attr->disp_scale_max.y;  
	border[7].z = gwin_attr->disp_scale_min.z;
	border[8].x = gwin_attr->disp_scale_min.x;
	border[8].y = gwin_attr->disp_scale_max.y;  
	border[8].z = gwin_attr->disp_scale_max.z;
	border[9].x = gwin_attr->disp_scale_max.x;
	border[9].y = gwin_attr->disp_scale_max.y;  
	border[9].z = gwin_attr->disp_scale_max.z;
	border[10].x = gwin_attr->disp_scale_max.x;
	border[10].y = gwin_attr->disp_scale_max.y;  
	border[10].z = gwin_attr->disp_scale_min.z;

	colorindex = gwin_attr->current_colors[GRID_COLOR];
	X3D_draw_polyline(gwin->id, border, 11, &Colors[colorindex]); 
        if (xp_device != xpX11)
	    X3D_set_line_width(gwin->id, MediumFine);

	/*
	 *  Clean up.  free up the malloc'ed grid_lines.
	 */
	XFlush(display);
}
