 /*
  * Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:44:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:44:29 dkhoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.3  1992/03/20  22:44:29  dkhoros
 * VirtualPatch5
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Fri Mar 13 14:24:09 1992
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_animate_form
*
*       Purpose: Fills in the user-specified
*                'animate_form'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'animate_form'
*
*       Output:  current values stored in  animate_form
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_animate_form(formptr, forminfo)

xvf_form *formptr;
animate_form *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'animate_form' Form Information structure *****/


	index = 4;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->previous = line_info.selected;

	index = 5;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->reverse = line_info.selected;

	index = 6;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->stop = line_info.selected;

	index = 7;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->forward = line_info.selected;

	index = 8;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->next = line_info.selected;

	index = 9;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->workspace = line_info.workspace;

	index = 12;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 14;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->file_subform_selected = line_info.selected;

	index = 27;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->options_subform_selected = line_info.selected;

}

/********************************************************
*
*  Routine Name: xvf_get_file_subform
*
*       Purpose: Fills in the user-specified
*                'animate_form_file_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'animate_form_file_subform'
*
*       Output:  current values stored in  'animate_form_file_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_file_subform(formptr, subforminfo)

xvf_form *formptr;
animate_form_file_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 15;


	/*** extracting 'animate_form->file_subform'
 	   Subform Information structure ***/


	index = 15;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->file_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_options_subform
*
*       Purpose: Fills in the user-specified
*                'animate_form_options_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'animate_form_options_subform'
*
*       Output:  current values stored in  'animate_form_options_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_options_subform(formptr, subforminfo)

xvf_form *formptr;
animate_form_options_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 28;


	/*** extracting 'animate_form->options_subform'
 	   Subform Information structure ***/


	index = 28;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->options_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_file
*
*       Purpose: Fills in the user-specified
*                'file_subform_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'file_subform_file'
*
*       Output:  current values stored in  'file_subform_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_file(formptr, paneinfo)

xvf_form *formptr;
file_subform_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 16;


	/* extracting 'animate_form->file_subform->file'
 	   Pane Information structure */

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->i = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->i = NULL;

	paneinfo->i_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->base = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->base = NULL;

	paneinfo->base_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->c = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->c = NULL;

	paneinfo->c_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->s = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->s = NULL;

	paneinfo->s_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_options
*
*       Purpose: Fills in the user-specified
*                'options_subform_options'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_subform_options'
*
*       Output:  current values stored in  'options_subform_options'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_options(formptr, paneinfo)

xvf_form *formptr;
options_subform_options *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 29;


	/* extracting 'animate_form->options_subform->options'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->control_val = line_info.toggle_val;
	paneinfo->control_selected = line_info.selected;
	index++;

	index = 34;
	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->show_band = line_info.logical_val;
	paneinfo->show_band_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->use_root = line_info.logical_val;
	paneinfo->use_root_selected = line_info.selected;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->speed = line_info.float_val;
	paneinfo->speed_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


