 /*
  * Khoros: $Id: conductor.h,v 1.1 1991/05/10 15:58:25 khoros Exp $
  */

 /*
  * $Log: conductor.h,v $
 * Revision 1.1  1991/05/10  15:58:25  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: conductor.h
 >>>>            Author: Danielle Argiro
 >>>> Date Last Updated: Tue Apr  2 15:11:09 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _conductor_h_
#define _conductor_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    conductor Argument Structure
*
****************************************************************/

typedef struct _conductor  {

/*
 *  UIS file (Required infile)
 */
char	*i;     	/* UIS file FILENAME */
int	 i_flag;	/* UIS file FLAG */

/*
 *  Level of Extraction (Required integer)
 */
int	 l;    	/* Level of Extraction INT */
int	 l_flag;	/* Level of Extraction FLAG */

/*
 *  generate program driver? (Optional logical)
 */
int	 b;      	/* generate program driver? LOGIC */
int	 b_flag;  	/* generate program driver? FLAG */

/*
 *  force output? (Optional logical)
 */
int	 f;      	/* force output? LOGIC */
int	 f_flag;  	/* force output? FLAG */

}  conductor_struct;

conductor_struct *conductor;

/* -include_additions */

static char
*cp_top    = "/*\n",
*cp_line   = " *---------------------------------------------------------------------\n",
*cp_right  = 
" *            Copyright 1990 University of New Mexico\n\
 * \n\
 * Permission to copy and modify this software and its documen- \n\
 * tation only for internal use in your organization is hereby \n\
 * granted, provided that this notice is retained thereon and \n\
 * on all copies.  UNM makes no representations as too the sui- \n\
 * tability and operability of this software for any purpose. \n\
 * It is provided 'as is' without express or implied warranty. \n\
 *  \n\
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, \n\
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- \n\
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, \n\
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- \n\
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER \n\
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS \n\
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- \n\
 * FORMANCE OF THIS SOFTWARE. \n\
 *  \n\
 * No other rights, including for example, the right to redis- \n\
 * tribute this software and its documentation or the right to \n\
 * prepare derivative works, are granted unless specifically \n\
 * provided in a separate license agreement. \n\
 * \n",

*cp_bottom = " */\n";

/*
 *      These cryptic lines are for includes 
 */

static char *include1 = "#include \"unmcopyright.h\"\n",
     *include2 = "#include \"xvforms.h\"\n",
     *include4 = "#include \"form_info.h\"\n",
     *include5 = "#include \"xvinclude.h\"\n";

/*
 *      These cryptic lines are for headers on the form_info routines
 */

static char 
*top_bdr    = "/********************************************************\n",
*bottom_bdr = "********************************************************/\n",
*single_star= "*\n",
*name       = "*  Routine Name: xvf_get_",
*purpose1   = "*       Purpose: Fills in the user-specified\n",
*purpose2   = "*                ",
*purpose3   = "*                 structure according to the info currently\n",
*purpose4   = "*                stored in the database by xvforms.\n",
*input1     = "*        Input:  formptr - pointer to the xvf_form structure\n",
*input2f    = "*                forminfo - pointer to the user-specified\n",
*input2s    = "*                subforminfo - pointer to the user-specified\n",
*input2p    = "*                paneinfo - pointer to the user-specified\n",
*output     = "*       Output:  current values stored in ",
*called_by1 = "*    Called By:  the application program when appropriate\n",
*called_by2 = "*    Called By:  xvf_get_",
*author     = "*   Automatically Generated By:  conductor";

/*
 *      These cryptic lines are for headers on the driver routines
 */

static char
*dr_name     = "*  Routine Name: ",
*dr_purpose  = "*       Purpose: ",
*dr_input    = "*         Input: ",
*dr_output   = "*        Output: ",
*dr_call_by  = "*     Called By: ";

static char *gen_comm = "\t\t/* PUT YOUR CODE HERE ! */\n";

static char *arg1       = "char *database[];\n";


static char *declar1 = "int index;\n";
static char *declar2 = "Line_Info line_info;\n";
static char *declar3 = "char **database;\n";

static char *parseI     = "xvf_parse_input_line(database[index], &line_info);\n",
     *parseO    = "xvf_parse_output_line(database[index], &line_info);\n",
     *parsei    = "xvf_parse_int_line(database[index], &line_info);\n",
     *parsef    = "xvf_parse_float_line(database[index], &line_info);\n",
     *parsel    = "xvf_parse_logic_line(database[index], &line_info);\n",
     *parses    = "xvf_parse_string_line(database[index], &line_info);\n",
     *parseT    = "xvf_parse_toggle_line(database[index], &line_info);\n",
     *parseR    = "xvf_parse_routine_line(database[index], &line_info);\n",
     *parseH    = "xvf_parse_help_line(database[index], &line_info);\n",
     *parseB    = "xvf_parse_blank_line(database[index], &line_info);\n",
     *parset    = "xvf_parse_toggle_line(database[index], &line_info);\n",
     *parseA    = "xvf_parse_pane_action_line(database[index], &line_info);\n",
     *parseP    = "xvf_parse_startpane_line(database[index], &line_info);\n",
     *parsem    = "xvf_parse_subform_action_line(database[index], &line_info);\n",
     *parsen    = "xvf_parse_master_action_line(database[index], &line_info);\n",
     *parsew    = "xvf_parse_workspace_line(database[index], &line_info);\n",
     *parseQ    = "xvf_parse_quit_line(database[index], &line_info);\n",
     *parseM    = "xvf_parse_startsubform_line(database[index], &line_info);\n",
     *parsec    = "xvf_parse_cycle_line(database[index], &line_info);\n",
     *parsex    = "xvf_parse_list_line(database[index], &line_info);\n";
                     
static char *deparseI     = "xvf_deparse_input_line(&line_info, database, index);\n",
     *deparseO    = "xvf_deparse_output_line(&line_info, database,index);\n",
     *deparsei    = "xvf_deparse_int_line(&line_info, database,index);\n",
     *deparsef    = "xvf_deparse_float_line(&line_info, database,index);\n",
     *deparsel    = "xvf_deparse_logic_line(&line_info, database,index);\n",
     *deparses    = "xvf_deparse_string_line(&line_info, database,index);\n",
     *deparseT    = "xvf_deparse_toggle_line(&line_info, database,index);\n",
     *deparseR    = "xvf_deparse_routine_line(&line_info, database,index);\n",
     *deparseH    = "xvf_deparse_help_line(&line_info, database,index);\n",
     *deparseB    = "xvf_deparse_blank_line(&line_info, database,index);\n",
     *deparset    = "xvf_deparse_toggle_line(&line_info, database,index);\n",
     *deparseA    = "xvf_deparse_pane_action_line(&line_info, database,index);\n",
     *deparseP    = "xvf_deparse_startpane_line(&line_info, database,index);\n",
     *deparsem    = "xvf_deparse_subform_action_line(&line_info, database,index);\n",
     *deparsen    = "xvf_deparse_master_action_line(&line_info,database,index);\n",
     *deparsew    = "xvf_deparse_workspace_line(&line_info,database,index);\n",
     *deparseQ    = "xvf_deparse_quit_line(&line_info, database,index);\n",
     *deparsec    = "xvf_deparse_cycle_line(&line_info, database,index);\n",
     *deparsex    = "xvf_deparse_list_line(&line_info, database,index);\n";
                     
                
static char *incr_index = "index++;\n\n";
static char *str_neq_null = "if (line_info.string_val != NULL) {\n";
static char *fil_neq_null = "if (line_info.filename != NULL) {\n";
static char *strdef_neq_null = "if (line_info.string_def != NULL) {\n";
static char *fildef_neq_null = "if (line_info.file_def != NULL) {\n";
static char *selected = "_selected = line_info.selected;\n";
static char *forminfo = "forminfo";


#define  XVF_GET_ALL_LEVELS 1
#define  XVF_GET_SUBFORMS   2
#define  XVF_GET_PANES      3


static char *filehdr_top =
"/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n",
     *filehdr_file =
" >>>>         File Name: ",
     *filehdr_name =
" >>>>      Program Name: ",
     *filehdr_date =
" >>>> Date Last Updated: ",
     *filehdr_desc =
" >>>>      Program Desc: ",
     *filehdr_comm =
" >>>>          Comments: ",
     *filehdr_auth =
" >>>>            Author: ",
     *filehdr_mods =
" >>>>          Routines: ",
     *filehdr_bottom =
" >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/";

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
