 /*
  * Khoros: $Id: form_info.c,v 1.2 1992/03/20 22:51:11 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.2 1992/03/20 22:51:11 dkhoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.2  1992/03/20  22:51:11  dkhoros
 * VirtualPatch5
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Fri Mar 13 13:47:43 1992
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_view
*
*       Purpose: Fills in the user-specified
*                'view'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'view'
*
*       Output:  current values stored in  view
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_view(formptr, forminfo)

xvf_form *formptr;
view *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'view' Form Information structure *****/


	index = 2;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->plot_workspace = line_info.workspace;

	index = 8;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->change_bands = line_info.selected;

	index = 22;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 24;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->lut_subform_selected = line_info.selected;

	index = 43;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->pseudo_subform_selected = line_info.selected;

	index = 60;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->thres_subform_selected = line_info.selected;

	index = 75;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->files_subform_selected = line_info.selected;

	index = 89;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->persp_subform_selected = line_info.selected;

	index = 105;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->colormap_subform_selected = line_info.selected;

	index = 130;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->plot_subform_selected = line_info.selected;

}

/********************************************************
*
*  Routine Name: xvf_get_lut_subform
*
*       Purpose: Fills in the user-specified
*                'view_lut_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_lut_subform'
*
*       Output:  current values stored in  'view_lut_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_lut_subform(formptr, subforminfo)

xvf_form *formptr;
view_lut_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 25;


	/*** extracting 'view->lut_subform'
 	   Subform Information structure ***/


	index = 25;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->lut_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_pseudo_subform
*
*       Purpose: Fills in the user-specified
*                'view_pseudo_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_pseudo_subform'
*
*       Output:  current values stored in  'view_pseudo_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pseudo_subform(formptr, subforminfo)

xvf_form *formptr;
view_pseudo_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 44;


	/*** extracting 'view->pseudo_subform'
 	   Subform Information structure ***/


	index = 44;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->pseudo_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_thres_subform
*
*       Purpose: Fills in the user-specified
*                'view_thres_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_thres_subform'
*
*       Output:  current values stored in  'view_thres_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_thres_subform(formptr, subforminfo)

xvf_form *formptr;
view_thres_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 61;


	/*** extracting 'view->thres_subform'
 	   Subform Information structure ***/


	index = 61;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->thres_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_files_subform
*
*       Purpose: Fills in the user-specified
*                'view_files_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_files_subform'
*
*       Output:  current values stored in  'view_files_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_files_subform(formptr, subforminfo)

xvf_form *formptr;
view_files_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 76;


	/*** extracting 'view->files_subform'
 	   Subform Information structure ***/


	index = 76;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->file_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_persp_subform
*
*       Purpose: Fills in the user-specified
*                'view_persp_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_persp_subform'
*
*       Output:  current values stored in  'view_persp_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_persp_subform(formptr, subforminfo)

xvf_form *formptr;
view_persp_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 90;


	/*** extracting 'view->persp_subform'
 	   Subform Information structure ***/


	index = 90;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->persp_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_colormap_subform
*
*       Purpose: Fills in the user-specified
*                'view_colormap_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_colormap_subform'
*
*       Output:  current values stored in  'view_colormap_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_colormap_subform(formptr, subforminfo)

xvf_form *formptr;
view_colormap_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 106;


	/*** extracting 'view->colormap_subform'
 	   Subform Information structure ***/


	index = 106;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->colormap_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_plot_subform
*
*       Purpose: Fills in the user-specified
*                'view_plot_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'view_plot_subform'
*
*       Output:  current values stored in  'view_plot_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_plot_subform(formptr, subforminfo)

xvf_form *formptr;
view_plot_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 131;


	/*** extracting 'view->plot_subform'
 	   Subform Information structure ***/


	index = 131;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->plot_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_lut
*
*       Purpose: Fills in the user-specified
*                'lut_subform_lut'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'lut_subform_lut'
*
*       Output:  current values stored in  'lut_subform_lut'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_lut(formptr, paneinfo)

xvf_form *formptr;
lut_subform_lut *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 26;


	/* extracting 'view->lut_subform->lut'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 36;
	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->histogram = line_info.logical_val;
	paneinfo->histogram_selected = line_info.selected;
	index++;

	xvf_parse_cycle_line(database[index], &line_info);
	paneinfo->hist_type = line_info.cycle_val;
	paneinfo->hist_type_selected = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->lut_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_pseudo
*
*       Purpose: Fills in the user-specified
*                'pseudo_subform_pseudo'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'pseudo_subform_pseudo'
*
*       Output:  current values stored in  'pseudo_subform_pseudo'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_pseudo(formptr, paneinfo)

xvf_form *formptr;
pseudo_subform_pseudo *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 45;


	/* extracting 'view->pseudo_subform->pseudo'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 55;
	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->pseudo_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_thres
*
*       Purpose: Fills in the user-specified
*                'thres_subform_thres'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'thres_subform_thres'
*
*       Output:  current values stored in  'thres_subform_thres'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_thres(formptr, paneinfo)

xvf_form *formptr;
thres_subform_thres *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 62;


	/* extracting 'view->thres_subform->thres'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->thresholding_val = line_info.toggle_val;
	paneinfo->thresholding_selected = line_info.selected;
	index++;

	index = 66;
	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->accept = line_info.logical_val;
	paneinfo->accept_selected = line_info.selected;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->fill_pixel = line_info.int_val;
	paneinfo->fill_pixel_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->invert = line_info.logical_val;
	paneinfo->invert_selected = line_info.selected;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->non_zero_pixel = line_info.int_val;
	paneinfo->non_zero_pixel_selected = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->thres_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_file
*
*       Purpose: Fills in the user-specified
*                'files_subform_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'files_subform_file'
*
*       Output:  current values stored in  'files_subform_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_file(formptr, paneinfo)

xvf_form *formptr;
files_subform_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 77;


	/* extracting 'view->files_subform->file'
 	   Pane Information structure */

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->image = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->image = NULL;

	paneinfo->image_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->elev = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->elev = NULL;

	paneinfo->elev_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->colormap = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->colormap = NULL;

	paneinfo->colormap_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->outfile = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->outfile = NULL;

	paneinfo->outfile_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_persp
*
*       Purpose: Fills in the user-specified
*                'persp_subform_persp'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'persp_subform_persp'
*
*       Output:  current values stored in  'persp_subform_persp'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_persp(formptr, paneinfo)

xvf_form *formptr;
persp_subform_persp *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 91;


	/* extracting 'view->persp_subform->persp'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->views_val = line_info.toggle_val;
	paneinfo->views_selected = line_info.selected;
	index++;

	index = 100;
	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->persp_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_colormap
*
*       Purpose: Fills in the user-specified
*                'colormap_subform_colormap'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'colormap_subform_colormap'
*
*       Output:  current values stored in  'colormap_subform_colormap'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_colormap(formptr, paneinfo)

xvf_form *formptr;
colormap_subform_colormap *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 107;


	/* extracting 'view->colormap_subform->colormap'
 	   Pane Information structure */

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_type_val = line_info.toggle_val;
	paneinfo->color_type_selected = line_info.selected;
	index++;

	index = 126;
	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_plot
*
*       Purpose: Fills in the user-specified
*                'plot_subform_plot'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'plot_subform_plot'
*
*       Output:  current values stored in  'plot_subform_plot'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_plot(formptr, paneinfo)

xvf_form *formptr;
plot_subform_plot *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 132;


	/* extracting 'view->plot_subform->plot'
 	   Pane Information structure */

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->use_imagery = line_info.logical_val;
	paneinfo->use_imagery_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->interp_imagery = line_info.logical_val;
	paneinfo->interp_imagery_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->proportional = line_info.logical_val;
	paneinfo->proportional_selected = line_info.selected;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->subsample = line_info.float_val;
	paneinfo->subsample_selected = line_info.selected;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->height = line_info.float_val;
	paneinfo->height_selected = line_info.selected;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->plot_type_val = line_info.toggle_val;
	paneinfo->plot_type_selected = line_info.selected;
	index++;

	index = 150;
	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


