 /*
  * Khoros: $Id: run_plot.c,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_plot.c,v 1.1 1991/05/10 15:59:03 khoros Exp $";
#endif

 /*
  * $Log: run_plot.c,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"
#include "viewimage.h"


/********************************************************
*
*  Routine Name:  run_plot_subform
*
*       Purpose:  drives the subform 'plot_subform'
*
*         Input:  form - pointer to the form tree 
*		  plot_subform_info  - information structure for subform 'plot_subform'
*        Output:  action of the application program
*
*     Called By:  run_view()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_plot_subform(form, plot_subform_info)

xvf_form *form;
view_plot_subform *plot_subform_info;
{

	_xvf_get_plot_subform(form, plot_subform_info);

	/*
	 * action came from the 'plot' pane
	 */
	if (plot_subform_info->plot_selected)
	    run_plot(form, plot_subform_info->plot);


}   /* end run_plot_subform */





/********************************************************
*
*  Routine Name:  run_plot
*
*       Purpose:  drives the pane 'plot'
*
*         Input:  form - pointer to the form tree 
*		  plot_info  - information structure for pane 'plot'
*        Output:  action of the application program
*
*     Called By:  run_plot_subform()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_plot(form, plot_info)

xvf_form *form;
plot_subform_plot *plot_info;
{
	int	i, width, height;
	Arg	args[MaxArgs];

	_xvf_get_plot(form, plot_info);


	/* plot fields that affect the plot object */

	/*
	 * user clicked on 'live' toggle selection 'plot_type'
	 */
	i = 0;
	if (plot_info->plot_type_selected)
	{
	   XClearWindow(XtDisplay(plot->workspace), XtWindow(plot->workspace));
	   XtSetArg(args[i], XtNplot, plot_info->plot_type_val);	i++;
	}

	/*
	 * user clicked on 'live' logical selection 'subsample'
	 */
	if (plot_info->subsample_selected)
	{
	   width =  elevation->row_size/plot_info->subsample;
	   height = elevation->col_size/plot_info->subsample;

	   if (width  < 2) width  = 2;
	   if (height < 2) height = 2;
	   XtSetArg(args[i], XtNplotwidth, width);			i++;
	   XtSetArg(args[i], XtNplotheight, height);			i++;
	}

	/*
	 * user clicked on 'live' logical selection 'use_imagery'
	 */
	if (plot_info->use_imagery_selected)
	{
	   XtSetArg(args[i], XtNuse_image, plot_info->use_imagery);	i++;
	}

	/*
	 * user clicked on 'live' logical selection 'interp_imagery'
	 */
	if (plot_info->interp_imagery_selected)
	{
	   XtSetArg(args[i], XtNinterp_image, plot_info->interp_imagery); i++;
	}

	if (i > 0)
	   XtSetValues(plot->plotobj, args, i);


	/* plot fields that affect the plot workspace */

	/*
	 * user clicked on 'live' logical selection 'proportional'
	 */
	i = 0;
	if (plot_info->proportional_selected)
	{
	   XtSetArg(args[i], XtNproportional, plot_info->proportional);	i++;
	}

	/*
	 * user clicked on 'live' float selection 'height'
	 */
	if (plot_info->height_selected)
	{
	   set_floatarg(args, i, XtNhfactor, &plot_info->height);	i++;
	}

	if (i > 0)
	   XtSetValues(plot->workspace, args, i);
}

