 /*
  * Khoros: $Id: run_opts3.c,v 1.3 1992/03/20 22:41:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_opts3.c,v 1.3 1992/03/20 22:41:29 dkhoros Exp $";
#endif

 /*
  * $Log: run_opts3.c,v $
 * Revision 1.3  1992/03/20  22:41:29  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include 	"xprism3.h"



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_opt3.c
   >>>>               
   >>>>   description: utilities for running the options
   >>>>			subform.
   >>>>              
   >>>>      routines:
   >>>>			run_options_3D
   >>>>			run_labels
   >>>>			run_tics
   >>>>			run_colors
   >>>>			update_colors
   >>>>			update_tics
   >>>>			run_contours
   >>>>			update_contour
   >>>>			run_plot_data
   >>>>			assign_band
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#define MaxFontString 20
#define MaxColorString 30

/************************************************************
*
*  MODULE NAME: run_options_3D
*
*      PURPOSE: Drives the options form -- 
*		Called after the user clicks on an "options" action
*		button.
*
*         INPUT: form - pointer to the form tree
*                options_info - pointer to the Options Subform
*                               information structure
*       OUTPUT: none
*
*    CALLED BY: run_master
*
*   WRITTEN BY: Mark Young & Mike Lang & Danielle Argiro
*
*
*************************************************************/

run_options_3D(form, options_info)

xvf_form	*form;
Master_options  *options_info;
{
	char *mesg;
	 
	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */

	_xvf_get_options(form, options_info);

	/* call the appropriate routine to set the options */
	if (options_info->quit)
	   xvf_change_active(form, false);

	else if (gwin == NULL)
        {
             mesg = xvf_strcpy("Please use the 'Plot' form to create a graphics workspace\n");
             xvf_error_wait(mesg, "run_options_3D", NULL);
             free(mesg);
	     update_tics(form, options_info->tics);
             return;
        }

	else if (options_info->label_selected )
	   run_labels(form, options_info->label);

	else if (options_info->tics_selected )
	   run_tics(form, options_info->tics);

	else if (options_info->colors_selected )
	   run_colors(form, options_info->colors);

	 else if (options_info->contours_selected)
	   run_contours(form, options_info->contours);

	 else if (options_info->plot_data_selected )
           run_plot_data(form, options_info->plot_data);

        else if (options_info->attributes_selected)
            run_attributes(form, options_info->attributes);


	 update_tics(form, options_info->tics);
}



/************************************************************
*
*   MODULE NAME: run_labels
*
*       PURPOSE: Drives the Labels pane of the options form --
*           	 Called after the user clicks on the "Change Labels"
*		 button, this allow the user to set the labels
*		 for the plot title, x-axis, y-axis, and if there is 
*		 one the z-axis.
*
*         INPUT: form - pointer to the form tree
*                label_info - pointer to the Label Pane information structure
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Danielle Argiro & Mark Young & Mike Lang
*
*************************************************************/


run_labels(form, label_info)

xvf_form	*form;
options_label   *label_info;

{
	int i, plot_type, current = 0;
	int fontnum, col_num = 1;
	XawListReturnStruct *font_list_return;
	char *prompt1 = "Pick Font for Label";
	char *label1 = "Font Options";
	char *space = " ";
        char *fontstring, **fontnames, **X3D_inquire_fonts();
	char temp[50], *prompts[20], *answers[20];
	XPlot *plot;


	_xvf_get_label(form, label_info);

        fontnames = X3D_inquire_fonts(&fontnum);
	plot_type = gwin->plot_type;


	/* change any labels that are different */
	if (label_info->title_selected)
	{
             if (label_info->title != NULL)
             {
     	    	if (strcmp(label_info->title, gwin_attr->title) != NULL)
     	            gwin_attr->title = xvf_strcpy(label_info->title);
     	     }
	     else
	     {
                gwin_attr->title = xvf_strcpy(space);
	     }
	     plot_routine();
	}
	else if (label_info->xaxis_selected)
	{
     	    if (label_info->xaxis != NULL)
            {
     	        if(strcmp(label_info->xaxis, gwin_attr->xaxis) != NULL)
     	        {
     	            gwin_attr->xaxis = xvf_strcpy(label_info->xaxis);
     	        }
     	    }
	    else
	    {
                gwin_attr->xaxis = xvf_strcpy(space);
	    }
	    plot_routine();
	}
	else if (label_info->yaxis_selected)
	{
     	    if (label_info->yaxis != NULL)
            {
     	        if(strcmp(label_info->yaxis, gwin_attr->yaxis) != NULL)
     	        {
     	            gwin_attr->yaxis = xvf_strcpy(label_info->yaxis);
     	        }
     	    }
	    else
	    {
                gwin_attr->yaxis = xvf_strcpy(space);
	    }
	    plot_routine();
	}
	else if (label_info->zaxis_selected)
	{
     	    if (label_info->zaxis != NULL)
            {
     	         if(strcmp(label_info->zaxis, gwin_attr->zaxis) != NULL)
     	         {
     	             gwin_attr->zaxis = xvf_strcpy(label_info->zaxis);
     	         }
     	     }
	    else
	    {
                gwin_attr->zaxis = xvf_strcpy(space);
	    }
	    plot_routine();
	}

	else if (label_info->change_legend)
        {

             plot = gwin->plist;
             i = 0;
             while (plot != NULL)
             {
                if (plot->active == true)
                {
                    sprintf(temp, "Legend Label for Plot %d:", plot->id);
                    prompts[i] = xvf_strcpy(temp);
                    answers[i] = xvf_strcpy(plot->legend_str);
                    i++;
                }
                plot = plot->next;
             }
             xvf_query_wait("Legend Labels (10 character MAX)", prompts,
                            "OK",answers, i, 10);

             i = 0;
             plot = gwin->plist;
             while (plot != NULL)
             {
                if (plot->active == true)
                {
                   plot->legend_str = xvf_strcpy(answers[i]);
                   i++;
                }
                plot = plot->next;
             }
             plot_routine();
        }


	/* here we bring up a list of fonts and set the font for the label */
	else if(label_info->title_font)
	{
	    font_list_return = xvf_run_list_wait(fontnames, fontnum, col_num,
				      prompt1, label1, current, FALSE);
	    if (font_list_return == NULL) return;

	    fontstring = VStrcpy(font_list_return->string);

	    free(gwin_attr->font[TITLE]);
	    gwin_attr->font[TITLE] = VStrcpy(fontstring);
	    xvf_change_input(form,label_info->title_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString);

	    clear_label(plot_type,TITLE, gwin_attr->title);
            if (! gwin_attr->clear_labels)
	       write_label(plot_type,TITLE, gwin_attr->title, 
			gwin_attr->current_colors[TITLE_COLOR]);
	}
	else if(label_info->xaxis_font)
	{
	    font_list_return = xvf_run_list_wait(fontnames, fontnum, col_num, 
						 prompt1, label1, 
						 current, FALSE);
	    if (font_list_return == NULL) return;

	    fontstring = VStrcpy(font_list_return->string);

	    free(gwin_attr->font[XAXIS]);
	    gwin_attr->font[XAXIS] = VStrcpy(fontstring);
	    xvf_change_input(form,label_info->xaxis_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString);

	    plot_routine();
	}
	else if(label_info->yaxis_font)
	{
	    font_list_return = xvf_run_list_wait(fontnames, fontnum, col_num,
				 prompt1, label1, current, FALSE);
	    if (font_list_return == NULL) return;

	    fontstring = VStrcpy(font_list_return->string);

	    free(gwin_attr->font[YAXIS]);
	    gwin_attr->font[YAXIS] = VStrcpy(fontstring);
	    xvf_change_input(form,label_info->yaxis_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString); 

	    plot_routine();
	}
	else if(label_info->zaxis_font)
	{
		font_list_return = xvf_run_list_wait(fontnames, fontnum, 
					col_num, prompt1, label1, current, 
					FALSE);
	        if (font_list_return == NULL) return;

	        fontstring = VStrcpy(font_list_return->string);

		free(gwin_attr->font[ZAXIS]);
		gwin_attr->font[ZAXIS] = VStrcpy(fontstring);
		xvf_change_input(form,label_info->zaxis_font_index+1,
				 xvf_title_chng,fontstring,MaxFontString); 

	        plot_routine();
	}
	else if(label_info->num_font)
	{
		font_list_return = xvf_run_list_wait(fontnames, fontnum, 
					col_num, prompt1, label1, current, 
					FALSE);
	        if (font_list_return == NULL) return;

	        fontstring = VStrcpy(font_list_return->string);

		free(gwin_attr->font[NUMBERS]);
		gwin_attr->font[NUMBERS] = VStrcpy(fontstring);
		xvf_change_input(form,label_info->num_font_index+1,
				 xvf_title_chng,fontstring,MaxFontString);

		if (gwin_attr->draw_axes == TRUE)
	 	    plot_routine();
	}
	else if (label_info->legend_font)
        {
            font_list_return = xvf_run_list_wait(fontnames, fontnum, col_num,
                                 prompt1, label1, &current, FALSE);
            if (font_list_return == NULL) return;

            fontstring = VStrcpy(font_list_return->string);

            free(gwin_attr->font[LEGEND]);
            gwin_attr->font[LEGEND] = VStrcpy(fontstring);
            xvf_change_input(form,label_info->legend_font_index+1,
                             xvf_title_chng,fontstring,MaxFontString);
            if (gwin_attr->draw_axes == TRUE)
               plot_routine();
        }

	else if (label_info->all_fonts)
	{
	    font_list_return = xvf_run_list_wait(fontnames, fontnum, col_num,
                                 prompt1, label1, &current, FALSE);
            if (font_list_return == NULL) return;

	    fontstring = VStrcpy(font_list_return->string);
	    for (i = 0; i < 6; i++)
	        free(gwin_attr->font[i]);

            gwin_attr->font[TITLE]   = VStrcpy(fontstring);
            gwin_attr->font[XAXIS]   = VStrcpy(fontstring);
            gwin_attr->font[YAXIS]   = VStrcpy(fontstring);
            gwin_attr->font[ZAXIS]   = VStrcpy(fontstring);
            gwin_attr->font[NUMBERS] = VStrcpy(fontstring);
            gwin_attr->font[LEGEND]  = VStrcpy(fontstring);

	    xvf_change_input(form,label_info->title_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString); 
	    xvf_change_input(form,label_info->xaxis_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString); 
	    xvf_change_input(form,label_info->yaxis_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString); 
	    xvf_change_input(form,label_info->zaxis_font_index+1,
			     xvf_title_chng,fontstring,MaxFontString); 
            xvf_change_input(form,label_info->num_font_index+1,
                             xvf_title_chng,fontstring,MaxFontString);
            xvf_change_input(form,label_info->legend_font_index+1,
                             xvf_title_chng,fontstring,MaxFontString);

	    if (gwin_attr->draw_axes == TRUE)
	        plot_routine();
	    else
            {
                clear_label(plot_type,TITLE, gwin_attr->title);
                if (! gwin_attr->clear_labels)
                   write_label(plot_type,TITLE, gwin_attr->title,
                            gwin_attr->current_colors[TITLE_COLOR]);
            }

	}

	XFlush(display);
		
}  /* end run_labels */



/************************************************************
*
*   MODULE NAME: run_tics
*
*       PURPOSE: Drives the Tics pane of the options form --
*           	 Called after the user clicks on the "Change Tics"
*		 button, this allow the user to set the scale of
*		 the axis to log-log, log-linear .....
*		 You can also change the spacing of the tics by giving 
*		 the min max and the step increment.
*
*
*         INPUT: form - pointer to the form tree
*                tics_info - pointer to the Tics Pane information structure
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Mike Lang, Mark Young & Danielle Argiro
*
*    MODIFICATION: Tom, Mar 5, 1992  put in a kludge to auto scale
*		   so that is one axes' values are changed, it
*		   does not change the other axes's values.
*		   This probably will not work for all cases.
*
*************************************************************/


run_tics(form, tics_info)

xvf_form	*form;
options_tics    *tics_info;
{
	double step_size,minimum,maximum;
	float number_steps;
	char temp[MaxLength];
	int calc_x, calc_y, calc_z;

	
	_xvf_get_tics (form, tics_info);

        /* Turn the box for axes on or off */
        if (tics_info->box_selected)
        {
           if (gwin_attr->draw_box == TRUE) gwin_attr->draw_box = FALSE;
           else gwin_attr->draw_box = TRUE;
        }

	/* Turn the grid on or off */
        else if (tics_info->grid_selected)
        {
           if (gwin_attr->draw_grid == TRUE) gwin_attr->draw_grid = FALSE;
           else gwin_attr->draw_grid = TRUE;
        }

	/* Turn the axes on or off */
        else if (tics_info->axes_selected)
        {
           if (gwin_attr->draw_axes == TRUE) gwin_attr->draw_axes = FALSE;
           else gwin_attr->draw_axes = TRUE;
        }

        /* Turn the labels on the axes on or off */
        else if (tics_info->num_labels_selected)
        {
           if (gwin_attr->draw_numlabels == TRUE)
               gwin_attr->draw_numlabels = FALSE;
           else gwin_attr->draw_numlabels = TRUE;
        }
        else if (tics_info->clear_labels_selected)
        {
           if (gwin_attr->clear_labels == TRUE)
           {
                gwin_attr->clear_labels = FALSE;
           }
           else
           {
                gwin_attr->clear_labels = TRUE;
           }
        }

	/* Turn the legend on or off */
        else if (tics_info->legend_selected)
        {
           if (gwin_attr->draw_legend == TRUE) 
	   {
		gwin_attr->draw_legend = FALSE;
		X3D_set_viewport(gwin->id, 0.1, 0.9, 0.1, 0.9, 0.1, 0.9);
	   }
           else 
	   {
		gwin_attr->draw_legend = TRUE;
		X3D_set_viewport(gwin->id, 0.2, 0.9, 0.2, 0.9, 0.2, 0.9);
	   }
        }

           /* auto_scale was selected */
	else if (tics_info->auto_scale_selected)
        {

            if((!gwin_attr->auto_scale) && (tics_info->auto_scale))
            {
               gwin_attr->auto_scale = tics_info->auto_scale;
               reset_world_coordinates();
            }
            else
               gwin_attr->auto_scale = tics_info->auto_scale;
	       find_wc_min_max();
	       reset_world_coordinates();
        }

        else if (tics_info->change_labeling_selected)
        {
           if (gwin_attr->rescale_relabel != tics_info->change_labeling_val)
              if (gwin_attr->rescale_relabel == RELABEL)
              {
                  set_disp_min_max_step(gwin_attr->disp_scale_min,
                                        gwin_attr->disp_scale_max,
                                        gwin_attr->disp_scale_major_intv,
                                        gwin_attr->disp_scale_num_tics);
              }
              gwin_attr->rescale_relabel = tics_info->change_labeling_val;
        }

	   /* change workspace max/min points in which plot is displayed */
        else if (tics_info->change_max_min)
        {
	    if(   (tics_info->max_xpt > tics_info->min_xpt)
	       && (tics_info->max_ypt > tics_info->min_ypt)
	       && (tics_info->max_zpt > tics_info->min_zpt))
	    {
		calc_x = True;
                calc_y = True;
                calc_z = True;
                if (gwin_attr->disp_label_min.x == tics_info->min_xpt &&
                    gwin_attr->disp_label_max.x == tics_info->max_xpt)
                {
                    calc_x = False;
                }
                else
                {
                   gwin_attr->disp_label_min.x = tics_info->min_xpt;
                   gwin_attr->disp_label_max.x = tics_info->max_xpt;
                }

                if (gwin_attr->disp_label_min.y == tics_info->min_ypt &&
                    gwin_attr->disp_label_max.y == tics_info->max_ypt)
                {
                    calc_y = False;
                }
                else
                {
                   gwin_attr->disp_label_min.y = tics_info->min_ypt;
                   gwin_attr->disp_label_max.y = tics_info->max_ypt;
                }

                if (gwin_attr->disp_label_min.z == tics_info->min_zpt &&
                    gwin_attr->disp_label_max.z == tics_info->max_zpt)
                {
                    calc_z = False;
                }
                else
                {
                   gwin_attr->disp_label_min.z = tics_info->min_zpt;
                   gwin_attr->disp_label_max.z = tics_info->max_zpt;
                }

                if(gwin_attr->auto_scale)
                {
                  if (calc_x)
                  {
                     step_size = (double) gwin_attr->disp_label_major_intv.x;
                     maximum = (double) gwin_attr->disp_label_max.x;
                     minimum = (double) gwin_attr->disp_label_min.x;

                     get_number_steps(step_size,&number_steps,minimum,maximum);
                     set_step(&step_size,&number_steps,minimum,maximum);

                     gwin_attr->disp_label_major_intv.x = (float) step_size;
                     gwin_attr->disp_label_num_tics.x = (int)number_steps;
		  }

                  if (calc_y)
                  {
                     step_size = (double) gwin_attr->disp_label_major_intv.y;
                     maximum = (double) gwin_attr->disp_label_max.y;
                     minimum = (double) gwin_attr->disp_label_min.y;

                     get_number_steps(step_size,&number_steps,minimum,maximum);
                     set_step(&step_size,&number_steps,minimum,maximum);
   
                     gwin_attr->disp_label_major_intv.y = (float) step_size;
                     gwin_attr->disp_label_num_tics.y = (int)number_steps;
   		  }

                  if (calc_y)
                  {
                     step_size = (double) gwin_attr->disp_label_major_intv.z;
                     maximum = (double) gwin_attr->disp_label_max.z;
                     minimum = (double) gwin_attr->disp_label_min.z;

                     get_number_steps(step_size,&number_steps,minimum,maximum);
                     set_step(&step_size,&number_steps,minimum,maximum);

                     gwin_attr->disp_label_major_intv.z = (float) step_size;
                     gwin_attr->disp_label_num_tics.z = (int)number_steps;
		 }

                }
                else
                {
                   step_size = (double) gwin_attr->disp_label_major_intv.x;
                   maximum = (double) gwin_attr->disp_label_max.x;
                   minimum = (double) gwin_attr->disp_label_min.x;
 
                      /* this is in case the min and max are changed and
                       * the step size is real small
                       */
                   if ((((maximum - minimum) / step_size) > 100.0) ||
		       (((maximum - minimum) / step_size) < 1.0))
                   {
		      number_steps = 3.0;
                      set_step(&step_size,&number_steps,minimum,maximum);
                      gwin_attr->disp_label_major_intv.x = (float) step_size;
                   }
                   else
                      get_number_steps(step_size,&number_steps,minimum,maximum);
 
                   gwin_attr->disp_label_num_tics.x = (int)number_steps;
 
                   step_size = (double) gwin_attr->disp_label_major_intv.y;
                   maximum = (double) gwin_attr->disp_label_max.y;
                   minimum = (double) gwin_attr->disp_label_min.y;
 
                      /* this is in case the min and max are changed and
                       * the step size is real small
                       */
                   if ((((maximum - minimum) / step_size) > 100.0) ||
		       (((maximum - minimum) / step_size) < 1.0))
                   {
		      number_steps = 3.0;
                      set_step(&step_size,&number_steps,minimum,maximum);
                      gwin_attr->disp_label_major_intv.y = (float) step_size;
                   }
                   else
                      get_number_steps(step_size,&number_steps,minimum,maximum);

                   gwin_attr->disp_label_num_tics.y = (int)number_steps;

                   step_size = (double) gwin_attr->disp_label_major_intv.z;
                   maximum = (double) gwin_attr->disp_label_max.z;
                   minimum = (double) gwin_attr->disp_label_min.z;
 
                      /* this is in case the min and max are changed and
                       * the step size is real small
                       */
                   if ((((maximum - minimum) / step_size) > 100.0) ||
		       (((maximum - minimum) / step_size) < 1.0))
                   {
		      number_steps = 4.0;
                      set_step(&step_size,&number_steps,minimum,maximum);
                      gwin_attr->disp_label_major_intv.z = (float) step_size;
                   }
                   else
                      get_number_steps(step_size,&number_steps,minimum,maximum);

                   gwin_attr->disp_label_num_tics.z = (int)number_steps;
                }

                if (gwin_attr->rescale_relabel == RESCALE)
                {
                   set_disp_min_max_step(gwin_attr->disp_label_min,
                                         gwin_attr->disp_label_max,
                                         gwin_attr->disp_label_major_intv,
                                         gwin_attr->disp_label_num_tics);
                   X3D_set_wc_min_max (gwin->id, gwin_attr->disp_scale_min,
                                        gwin_attr->disp_scale_max);
                }
            }
            else
               xvf_error_wait( "The interval has to be less than the maximum minus the minimum ( interval < (maximum - minimum))",
                              "xprism_options_tics", NULL);
        }

	else if (tics_info->change_interval)
	{
	    if ((tics_info->major_xintv > 0) && 
		(tics_info->major_xintv < 
                  (gwin_attr->disp_label_max.x - gwin_attr->disp_label_min.x)))
	    {
	       gwin_attr->disp_label_major_intv.x = tics_info->major_xintv;
               step_size = (double) gwin_attr->disp_label_major_intv.x;
               maximum = (double) gwin_attr->disp_label_max.x;
               minimum = (double) gwin_attr->disp_label_min.x;
               if ((((maximum - minimum) / step_size) > 100.0) ||
		   (((maximum - minimum) / step_size) < 1.0))
               {
	          number_steps = 3.0;
                  set_step(&step_size,&number_steps,minimum,maximum);
                  gwin_attr->disp_label_major_intv.x = (float) step_size;
		  sprintf(temp,"The X interval size is too small for the current X-axis range. Setting the interval to %g", (float) step_size);
                   xvf_error_wait(temp, "Xprism2 Warning", NULL);
               }
	       if(gwin_attr->auto_scale)
	          step_size_linear(step_size,&number_steps,&minimum,&maximum);
	       else
	          get_number_steps(step_size,&number_steps,minimum,maximum);
	       gwin_attr->disp_label_max.x = (float) maximum;
	       gwin_attr->disp_label_min.x = (float) minimum;
	       gwin_attr->disp_label_num_tics.x = (int)number_steps;
	    }
	    else
	       xvf_error_wait("The interval has to be < (max - min)",
			      "xprism_options_tics", NULL);

	    if ((tics_info->major_yintv > 0) &&
		(tics_info->major_yintv < 
                  (gwin_attr->disp_label_max.y - gwin_attr->disp_label_min.y)))
	    {
	       gwin_attr->disp_label_major_intv.y = tics_info->major_yintv;
               step_size = (double) gwin_attr->disp_label_major_intv.y;
               maximum = (double) gwin_attr->disp_label_max.y;
               minimum = (double) gwin_attr->disp_label_min.y;
               if ((((maximum - minimum) / step_size) > 100.0) ||
		   (((maximum - minimum) / step_size) < 1.0))

               {
	          number_steps = 3.0;
                  set_step(&step_size,&number_steps,minimum,maximum);
                  gwin_attr->disp_label_major_intv.y = (float) step_size;
		  sprintf(temp,"The Y interval size is too small for the current Y-axis range. Setting the interval to %g", (float) step_size);
                   xvf_error_wait(temp, "Xprism2 Warning", NULL);
               }
	       if(gwin_attr->auto_scale)
	          step_size_linear(step_size,&number_steps,&minimum,&maximum);
	       else
	          get_number_steps(step_size,&number_steps,minimum,maximum);
	       gwin_attr->disp_label_max.y = (float) maximum;
	       gwin_attr->disp_label_min.y = (float) minimum;
	       gwin_attr->disp_label_num_tics.y = (int)number_steps;
	    }
	    else
	       xvf_error_wait("The interval has to be < (max - min)",
			      "xprism_options_tics", NULL);

	    if ((tics_info->major_zintv > 0) &&
		(tics_info->major_zintv < 
                  (gwin_attr->disp_label_max.z - gwin_attr->disp_label_min.z)))
	    {
	       gwin_attr->disp_label_major_intv.z = tics_info->major_zintv;
               step_size = (double) gwin_attr->disp_label_major_intv.z;
               maximum = (double) gwin_attr->disp_label_max.z;
               minimum = (double) gwin_attr->disp_label_min.z;
               if ((((maximum - minimum) / step_size) > 100.0) ||
		   (((maximum - minimum) / step_size) < 1.0))
               {
	          number_steps = 4.0;
                  set_step(&step_size,&number_steps,minimum,maximum);
                  gwin_attr->disp_label_major_intv.z = (float) step_size;
		  sprintf(temp,"The Z interval size is too small for the current Z-axis range. Setting the interval to %g", (float) step_size);
                   xvf_error_wait(temp, "Xprism2 Warning", NULL);
               }
	       if(gwin_attr->auto_scale)
	          step_size_linear(step_size,&number_steps,&minimum,&maximum);
	       else
	          get_number_steps(step_size,&number_steps,minimum,maximum);
	       gwin_attr->disp_label_max.z = (float) maximum;
	       gwin_attr->disp_label_min.z = (float) minimum;
	       gwin_attr->disp_label_num_tics.z = (int)number_steps;
	    }
	    else
	       xvf_error_wait("The interval has to be < (max - min)",
			      "xprism_options_tics", NULL);

	    if(tics_info->minor_xtics < 21)
	       gwin_attr->minor_tics.x = tics_info->minor_xtics;
	    else
	       xvf_error_wait("The max number of minor tics is 20",
			       "xprism_options_tics", NULL);
	    if(tics_info->minor_ytics < 21)
	       gwin_attr->minor_tics.y = tics_info->minor_ytics;
	    else
	       xvf_error_wait("The max number of minor tics is 20",
			      "xprism_options_tics", NULL);
	    if(tics_info->minor_ztics < 21)
	       gwin_attr->minor_tics.z = tics_info->minor_ztics;
	    else
	       xvf_error_wait("The max number of minor tics is 20",
			      "xprism_options_tics", NULL);

            if (gwin_attr->rescale_relabel == RESCALE)
            {
                set_disp_min_max_step(gwin_attr->disp_label_min, 
                                 gwin_attr->disp_label_max, 
                                 gwin_attr->disp_label_major_intv,
                                 gwin_attr->disp_label_num_tics);
	        X3D_set_wc_min_max (gwin->id, gwin_attr->disp_scale_min, 
                                              gwin_attr->disp_scale_max);
            }
	}

/*  All scale code commented out until it is reworked

	    * set the sxes scale (log ln linear ...) *
	
	else if (tics_info->change_xaxes_scale_selected)
        {

      	    if(gwin->WCmin.x > 0 )
	    {
	       gwin_attr->scale.x = tics_info->xaxes_scale_val;
	    }
	    if(gwin->WCmin.y > 0 )
	    {
	       gwin_attr->scale.y = tics_info->yaxes_scale_val;
	    }
	    if(gwin_attr->WCmin.z > 0 )
	    {
	       gwin_attr->scale.z = tics_info->zaxes_scale_val;
	    }
	    X3D_set_wc_scale(gwin->id, gwin_attr->scale);
	    reset_world_coordinates();
	    update_tics(form, tics_info);  
	}
	else if (tics_info->change_yaxes_scale_selected)
        {
      	    if(gwin->WCmin.x > 0 )
	    {
	       gwin_attr->scale.x = tics_info->xaxes_scale_val;
	    }
	    if(gwin->WCmin.y > 0 )
	    {
	       gwin_attr->scale.y = tics_info->yaxes_scale_val;
	    }
	    if(gwin_attr->WCmin.z > 0 )
	    {
	       gwin_attr->scale.z = tics_info->zaxes_scale_val;
            }
            X3D_set_wc_scale(gwin->id, gwin_attr->scale);
            reset_world_coordinates();
            update_tics(form, tics_info);
       }
       else if (tics_info->change_zaxes_scale_selected)
        {
      	    if(gwin->WCmin.x > 0 )
	    {
	       gwin_attr->scale.x = tics_info->xaxes_scale_val;
	    }
	    if(gwin->WCmin.y > 0 )
	    {
	       gwin_attr->scale.y = tics_info->yaxes_scale_val;
	    }
	    if(gwin_attr->WCmin.z > 0 )
	    {
	       gwin_attr->scale.z = tics_info->zaxes_scale_val;
            }
            X3D_set_wc_scale(gwin->id, gwin_attr->scale);
            reset_world_coordinates();
            update_tics(form, tics_info);
       }
*/


	plot_routine();
	update_tics(form, tics_info);

} /* end run_tics */



/********************************************************
*
*  Routine Name:  run_attributes
*
*       Purpose:  drives the pane 'attributes'
*
*         Input:  form - pointer to the form tree 
*		  attributes_info  - information structure for pane 'attributes'
*        Output:  action of the application program
*
*     Called By:  run_xprism()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_attributes(form, attributes_info)

xvf_form *form;
options_attributes *attributes_info;
{

	_xvf_get_attributes(form, attributes_info);

	/*
	 * user clicked on 'live' toggle selection 'change_plot_type'
	 */
	if (attributes_info->change_plot_type_selected)
	{
            if (change_plot_type(attributes_info->change_plot_type_val))
              plot_routine();
	}

	/*
	 * user clicked on 'live' toggle selection 'change_line_type'
	 */
	else if (attributes_info->change_line_type_selected)
	{
            if (change_line_type(attributes_info->change_line_type_val))
               plot_routine();

	}

	/*
	 * user clicked on 'live' toggle selection 'change_marker_type'
	 */
	else if (attributes_info->change_marker_type_selected)
	{
            if (change_marker_type(attributes_info->change_marker_type_val))
              plot_routine();
	}

	/*
	 * user clicked on pane action button 'data_sampling'
	 */
	else if (attributes_info->data_sampling)
	{
             if (change_sampling(attributes_info->step_size_x,
                                 attributes_info->begin_point_x,
                                 attributes_info->end_point_x,
             			 attributes_info->step_size_y,
                                 attributes_info->begin_point_y,
                                 attributes_info->end_point_y, PLOT_3D))
                plot_routine();
	}
}


/************************************************************
*
*   MODULE NAME: run_colors
*
*       PURPOSE: Drives the Colors pane of the options form --
*		 Allows user to change colors of labels, axes, and plots
*
*         INPUT: form - pointer to the form tree
*                color_info - pointer to the Color Pane information structure
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Danielle Argiro & Mike Lang & Mark Young
*
*************************************************************/


run_colors(form, color_info)

xvf_form        *form;
options_colors  *color_info;
{
	int colornum  = 24, col_num = 3; 
	char *prompt1="Pick Color for Label", *label1="Color Options"; 
	char *prompt2="Plot to Change Color:", *label2="Current Plots"; 
	char *prompt3="Pick Color for Plot:", *label3="Current Plots"; 
	char *colorstring;
	XawListReturnStruct *list_return;
	int colorindex, current, plot_type;
	XPlot *plot;

	_xvf_get_colors (form, color_info);

	/*
	 *   first, if the user is not changing all the colors 
	 *   or changing plot colors (a special case), put up a list widget
	 *   with the available colors 
	 */
	if(!(color_info->plots))
        {
                plot_type = gwin->plot_type;
                list_return = xvf_run_list_wait(colornames, colornum, col_num,
                                           prompt1, label1, &current, FALSE);
                if (list_return == NULL) return;
                colorstring = VStrcpy(list_return->string);
                colorindex  = list_return->list_index;
        }


	/*
	 *  change the color of the main plot title
	 */
	if (color_info->title)
	{
		gwin_attr->current_colors[TITLE_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->title_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
                if (! gwin_attr->clear_labels)
	           write_label(plot_type,TITLE, gwin_attr->title, 
			    gwin_attr->current_colors[TITLE_COLOR]);
	}

	/*
	 *  change the color of the legend label
	 */
	if (color_info->legend)
	{
		gwin_attr->current_colors[LEGEND_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->legend_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		if (gwin_attr->draw_legend)
		   draw_legend(gwin->plot_type);
	}

	/*
	 *  change the color of the X axis title
	 */
	else if (color_info->xaxis_label)
	{
	     gwin_attr->current_colors[XTITLE_COLOR] = list_return->list_index;

	     xvf_change_input(form, color_info->xaxis_label_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 

	     plot_routine();
	}

	/*
	 *  change the color of the Y Axis title
	 */
	else if (color_info->yaxis_label)
	{
		gwin_attr->current_colors[YTITLE_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->yaxis_label_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 

	        plot_routine();
	}

	/*
	 *  change the color of the Z Axis title
	 */
	else if (color_info->zaxis_label)
	{
		gwin_attr->current_colors[ZTITLE_COLOR] = list_return->list_index;
		xvf_change_input(form, color_info->zaxis_label_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
	        plot_routine();
	}

	/*
	 *  change the color of the X axis  & tic marks
	 */
	else if(color_info->xaxis)
	{
		gwin_attr->current_colors[XAXIS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->xaxis_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the Y axis & tic marks
	 */
	else if(color_info->yaxis)
	{
		gwin_attr->current_colors[YAXIS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->yaxis_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the Z axis & tic marks
	 */
	else if (color_info->zaxis) 
	{
		gwin_attr->current_colors[ZAXIS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->zaxis_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the numbers on the X axis 
	 */
	else if(color_info->xaxis_nums)
	{
		gwin_attr->current_colors[XNUMS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->xaxis_nums_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the numbers on the Y axis 
	 */
	else if(color_info->yaxis_nums)
	{
	        colorstring = VStrcpy(list_return->string);
		gwin_attr->current_colors[YNUMS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->yaxis_nums_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the Z axis & tic marks
	 */
	else if(color_info->zaxis_nums)
	{
		gwin_attr->current_colors[ZNUMS_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->zaxis_nums_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	/*
	 *  change the color of the grid
	 */
	else if(color_info->grid)
	{
		gwin_attr->current_colors[GRID_COLOR] = list_return->list_index;

		xvf_change_input(form, color_info->grid_index+1,
			         xvf_title_chng, colorstring, MaxColorString); 
		plot_routine();
	}

	else if(color_info->plots)
	{
		/*
		 * get the right plot
	   	 */

		plot = get_a_plot(label2, prompt2, APPEND_COLOR);
		if (plot == NULL) return;

		if (plot->plot_type == PLOT_CONTOUR_3D ||
		    plot->plot_type == PLOT_CONTOUR_2D ||
		    plot->plot_type == PLOT_COLORMESH ||
		    plot->plot_type == PLOT_SURFACE)
		{
		   xvf_error_wait("The color the selected plot can not be \
changed. Colors can not be changed for CONTOUR plots, COLOR MESH plots \
or SURFACE plots", 
		        "run_colors", NULL);
		   return;
		}

		/*
		 * get the right color
		 */

		list_return = xvf_run_list_wait(colornames, colornum, 
						 col_num, prompt3, label3, 
						 &current, FALSE);
	        if (list_return == NULL) return;
		colorstring = VStrcpy(list_return->string);
                colorindex  = list_return->list_index;
                free(list_return);

		/*
		 * set the plot color to be the right one
		 */
		plot->colorindex = list_return->list_index;
		plot->color = xvf_strcpy(colornames[colorindex]);

		/*
		 * redraw the plot(s)
		 */
		plot_routine();
	}
	XFlush(display);
}



/************************************************************
*
*   MODULE NAME: update_colors
*
*       PURPOSE: Updates the Colors pane of the options form --
*		 changes color values in "-b" lines to have the
*		 current values
*
*         INPUT: form - pointer to the form tree
*                color_info - pointer to the Colors Pane
*                                  information structure
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Danielle Argiro & Mike Lang & Mark Young
*
*************************************************************/

update_colors(form, color_info) 

xvf_form	*form; 		/* NOTE THIS BETTER BE THE OPTIONS FORM */
options_colors  *color_info;
{
	
	char *colorstring;
	int  colorindex;

	colorindex = gwin_attr->current_colors[TITLE_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->title_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[XTITLE_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->xaxis_label_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[YTITLE_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->yaxis_label_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[ZTITLE_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->zaxis_label_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[XAXIS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->xaxis_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[YAXIS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->yaxis_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[ZAXIS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->zaxis_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[XNUMS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->xaxis_nums_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[YNUMS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->yaxis_nums_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

	colorindex = gwin_attr->current_colors[ZNUMS_COLOR];
	colorstring = xvf_strcpy(colornames[colorindex]);
	xvf_change_input(form, color_info->zaxis_nums_index+1,
		         xvf_title_chng, colorstring, MaxColorString); 

}



/************************************************************
*
*   MODULE NAME: update_tics
*
*       PURPOSE: Updates the Tics pane of the options form --
*		 changes tic values 
*
*	 OUTPUT: none
*
*     CALLED BY:
*
*    WRITTEN BY: Danielle Argiro & Mike Lang & Mark Young
*
*************************************************************/

update_tics(form, tics_info)
xvf_form  *form;
options_tics *tics_info;
{
	char temp[50];

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_min.x);
	xvf_change_input(form, tics_info->min_xpt_index,
			 xvf_floatval_chng,temp,0);
  
	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_min.y);
	xvf_change_input(form, tics_info->min_ypt_index,
			 xvf_floatval_chng,temp,0);
   
	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_min.z);
	xvf_change_input(form, tics_info->min_zpt_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_max.x);
	xvf_change_input(form, tics_info->max_xpt_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_max.y);
	xvf_change_input(form, tics_info->max_ypt_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_max.z);
	xvf_change_input(form, tics_info->max_zpt_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_major_intv.x);
	xvf_change_input(form, tics_info->major_xintv_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_major_intv.y);
	xvf_change_input(form, tics_info->major_yintv_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->disp_label_major_intv.z);
	xvf_change_input(form, tics_info->major_zintv_index,
			 xvf_floatval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->minor_tics.x);
	xvf_change_input(form, tics_info->minor_xtics_index,
			 xvf_intval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->minor_tics.y);
	xvf_change_input(form, tics_info->minor_ytics_index,
			 xvf_intval_chng,temp,0);

	bzero(temp, 50);
	(void) sprintf(temp, "%g", gwin_attr->minor_tics.z);
	xvf_change_input(form, tics_info->minor_ztics_index,
			 xvf_intval_chng,temp,0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->rescale_relabel);
        xvf_change_input(form, tics_info->change_labeling_index,
                         xvf_toggleval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->auto_scale);
        xvf_change_input(form, tics_info->auto_scale_index,
                         xvf_logicalval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->draw_legend);
        xvf_change_input(form, tics_info->legend_index,
                         xvf_logicalval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->draw_grid);
        xvf_change_input(form, tics_info->grid_index,
                         xvf_logicalval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->draw_box);
        xvf_change_input(form, tics_info->box_index,
                         xvf_logicalval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->draw_axes);
        xvf_change_input(form, tics_info->axes_index,
                         xvf_logicalval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->draw_numlabels);
        xvf_change_input(form, tics_info->num_labels_index,
                         xvf_logicalval_chng,temp, 0);

/* all scale code is commented out until it is reworked

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->scale.x);
        xvf_change_input(form, tics_info->change_xaxes_scale_index,
                         xvf_toggleval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->scale.y);
        xvf_change_input(form, tics_info->change_yaxes_scale_index,
                         xvf_toggleval_chng,temp, 0);

        bzero(temp, 50);
        (void) sprintf(temp, "%d", (int)gwin_attr->scale.z);
        xvf_change_input(form, tics_info->change_zaxes_scale_index,
                         xvf_toggleval_chng,temp, 0);

*/
}



/************************************************************
*
*   MODULE NAME: run_contours
*
*       PURPOSE: Drives the Contours pane of the options form --
*		 Allows the user to set the contour values, 
*		 generate contours automatically, input contour
*		 levels manually, or reset default contours.
*
*         INPUT: form - pointer to the form tree
*                contour_info - pointer to the Contour Pane infostructure
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Danielle Argiro & Mark Young 
*
*************************************************************/

run_contours(form, contour_info)

xvf_form	*form;
options_contours *contour_info;
{
	XPlot *plot;
	char  *prompt1="Plot to Change Contours:", *label1="Current Plots"; 
	char  temp[512];
	char  *prompts[100], *answers[100];
	int   i, linelength = 80;
	float con_level;
	Real  *X3D_get_contour_levels();
	double atof();

	_xvf_get_contours(form, contour_info);

	if ((plot = get_a_plot(label1, prompt1, APPEND_COLOR)) == NULL)
	   return;

	/* get information on contours for plot, fill in parameter boxes */
	if (contour_info->set_info_cont)
		update_contour(form, contour_info, plot);


	/* generate contours automatically given min, max, # levels, offset */
	else if (contour_info->gen_cont)
	{
	    if (plot->levels != NULL)
	        free(plot->levels);
	    plot->levels = X3D_get_contour_levels(contour_info->cont_min,
						  contour_info->cont_max,
						  contour_info->cont_offset,
						  contour_info->cont_num);
	    plot->contour_num = contour_info->cont_num;
	    plot->contour_offset = contour_info->cont_offset;

	}

	/* allow the user to input their own contour levels */
	else if (contour_info->spec_cont)
	{
	    if (plot->levels == NULL)
	    {
	       plot->contour_num = contour_info->cont_num;  
	       plot->contour_offset = 0.0;
	       plot->levels = X3D_get_contour_levels(plot->WCmin.z,
						     plot->WCmax.z,
						     0.0, plot->contour_num);
	    }
	
	    for (i = 0; i < plot->contour_num; i++)
	    {
	        sprintf(temp, "Contour Level %d:", i+1);
		prompts[i] = xvf_strcpy(temp);

		answers[i] = (char *) calloc(1, linelength*sizeof(char));
		sprintf(answers[i], "%f", plot->levels[i]);
	    }

	    xvf_query_wait("Enter Contour Levels", prompts, "OK", 
			   answers, plot->contour_num, 15);

	    for(i = 0; i < plot->contour_num; i++)
	    {
	       con_level = atof(answers[i]);
	       plot->levels[i] = (Real) con_level;
	    }

	    update_contour(form, contour_info, plot);

	}

	/* reset the default contour levels for the plot */
	else if (contour_info->reset_cont)
	{
	    if (plot->levels != NULL)
	        free(plot->levels);
	    plot->levels = X3D_get_contour_levels(plot->WCmin.z,
					  plot->WCmax.z, 0.0, CONTOUR_COLORNUM);
	    plot->contour_num = CONTOUR_COLORNUM;
	    plot->contour_offset = 0.0;

	    update_contour(form, contour_info, plot);

	}

	else if (contour_info->plot_cont_3D)
	{
	   plot->plot_type = PLOT_CONTOUR_3D;
	   plot_routine();

	}

	else if (contour_info->plot_cont_2D)
	{
	   plot->plot_type = PLOT_CONTOUR_2D;
	   plot_routine();

	}
}


/************************************************************
*
*	MODULE NAME: update_contour
*
*	PURPOSE:  updates parameter boxes on Contour Pane
*
*	INPUT:  plot
*
*	OUTPUT: none
*	
************************************************************/

update_contour(form, contour_info, plot)
xvf_form *form;
options_contours *contour_info;
XPlot *plot;
{
     char  temp[512];
     float min_contour, max_contour;
     int   i;

     if (plot->levels == NULL)
     {
	min_contour = plot->WCmin.z;
	max_contour = plot->WCmax.z;
     }
     else
     {
	min_contour = max_contour = plot->levels[0];
	for (i = 1; i < plot->contour_num; i++)
	{
	    if (plot->levels[i] > max_contour)
		max_contour = plot->levels[i];
	    
	    else if (plot->levels[i] < min_contour)
		min_contour = plot->levels[i];
	}
     }

     (void) sprintf (temp, "Info for plot # %d", plot->id);
     xvf_change_input(form, contour_info->set_info_cont_index + 1,
		      xvf_title_chng,temp,0);
     
     (void) sprintf (temp, "Z Data Minimum:   %f", plot->WCmin.z);
     xvf_change_input(form, contour_info->set_info_cont_index + 2,
		      xvf_title_chng,temp,0);

     (void) sprintf (temp, "Z Data Maximum:   %f", plot->WCmax.z);
     xvf_change_input(form, contour_info->set_info_cont_index + 3,
		      xvf_title_chng,temp,0);

     (void) sprintf (temp, "%d", plot->contour_num);
     xvf_change_input(form, contour_info->cont_num_index,
		      xvf_intval_chng,temp,0);

     (void) sprintf (temp, "%f", min_contour);
     xvf_change_input(form, contour_info->cont_min_index,
		      xvf_floatval_chng,temp,0);

     (void) sprintf (temp, "%f", max_contour);
     xvf_change_input(form, contour_info->cont_max_index,
		      xvf_floatval_chng,temp,0);

     (void) sprintf (temp, "%f", plot->contour_offset);
     xvf_change_input(form, contour_info->cont_offset_index,
		      xvf_floatval_chng,temp,0);
}



/************************************************************
*
*   MODULE NAME: run_plot_data
*
*       PURPOSE: Drives the plot data pane of the options form --
*		 Allows user to assign bands of an (iff only) file
*		 to X Y or Z.
*
*		 The types of data the user is allowed to manipulate
*		 are:
*			image data     (image bands)
*			location data  (explicit vector information)
*			constant value (assigns a constant value to a
*					dimension).
*			image map data (NOT IMPLEMENTED YET).
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Danielle Argiro & Mike Lang & Mark Young & R. Jordan
*
*************************************************************/

run_plot_data(form, plot_data_info)

xvf_form		*form;
options_plot_data	*plot_data_info;
{ 
	int	i, j, current = 0, col_num = 1, num_bands, num_loc, num;
	char	temp[512];
	caddr_t *dimensions;	

	XPlot	*plot, *tmp_plot;
	struct	xvimage *image, *readimage(); 
	char	*label1 = "Select a plot:",
		*labelx = "Select a dimension for X",
		*labely = "Select a dimension for Y",
		*labelz = "Select a dimension for Z",
		*prompt = "Options Plot Dimension",
		*mesg;
	XawListReturnStruct *dimen_list;

	_xvf_get_plot_data(form, plot_data_info);

	if ((! plot_data_info->zband) && (! plot_data_info->yband) 
		&& (! plot_data_info->xband))
	{
             sprintf(temp, "No Axes have been specified to change. Please specify which Axes that you want to change.");
	     xvf_error_wait(temp, "run_plot_data", NULL);
             return;
	}
	if (!plot_data_info->dimensions)
	   return;

	if ((plot = get_a_plot(label1, prompt, APPEND_COLOR)) == NULL)
	   return;

	 /* open file and make sure it does exist before going further */
	if (plot->input_type != XVIFF_IMPL && plot->input_type != XVIFF_EXP)
	{
             sprintf(temp, "Plot specified did not originate as an image, so we cannot change bands on it.\n"); 
	     xvf_error_wait(temp, "run_plot_data", NULL);
             return;
        }

		
	if((image = readimage(plot->filename)) == NULL) /* read in the image information */
        {
   	   (void) sprintf(temp, "Not valid image file '%s' \n", plot->filename);
           xvf_error_wait(temp, "run_plot_data", NULL);
	   return;  
        }
	
	num_bands = image->num_data_bands;
	num_loc   = image->location_dim;

	/* add one for the constant entry */
	dimensions = (caddr_t *) malloc(num_bands*(sizeof(caddr_t)) + 1);

	/*
	 *  Build the list entries for the image data bands.
	 *  ie) "image->imagedata"
	 */
	j = 0;
	for(i = 0; i < num_bands; i++)
	{
	   sprintf(temp,"band data %d", i);
	   dimensions[j++] = (caddr_t) xvf_strcpy(temp);
	}

	/*
	 *  Build the list entries for the location data.
	 *  ie) "image->location"
	 */
	for(i = 0; i < num_loc; i++)
	{
	   sprintf(temp,"location data %d", i);
	   dimensions[j++] = (caddr_t) xvf_strcpy(temp);
	}

	/*
	 *  Build the list entry for the constant field.
	 */
	(void) sprintf(temp,"constant value %f", plot_data_info->constant);
	dimensions[j++] = (caddr_t) xvf_strcpy(temp);
	num = j;


	/*
	 *  Check to see if the user wants to change the X band data.  If so
	 *  then bring up a list widget and change the data to the desired
	 *  band.
	 */
	if (plot_data_info->xband)
	{
	   dimen_list = xvf_run_list_wait(dimensions, num, col_num, prompt,
					  labelx, current, FALSE);
	   if(dimen_list != NULL)
	   {
	      assign_band(plot, image, dimen_list->list_index, num_bands, num_loc,
			  num, XAXIS, plot_data_info->constant);
	   }
	}

	/*
	 *  Check to see if the user wants to change the Y band data.  If so
	 *  then bring up a list widget and change the data to the desired
	 *  band.
	 */
	if (plot_data_info->yband)
	{
	   dimen_list = xvf_run_list_wait(dimensions, num, col_num, prompt,
					  labely, current, FALSE);
	   if(dimen_list != NULL)
	   {
	      assign_band(plot, image, dimen_list->list_index, num_bands, num_loc,
			  num, YAXIS, plot_data_info->constant);
	   }
	}

	/*
	 *  Check to see if the user wants to change the Z band data.  If so
	 *  then bring up a list widget and change the data to the desired
	 *  band.
	 */
	if (plot_data_info->zband)
	{
	   dimen_list = xvf_run_list_wait(dimensions, num, col_num, prompt,
					  labelz, current, FALSE);
	   if(dimen_list != NULL)
	   {
	      assign_band(plot, image, dimen_list->list_index, num_bands, num_loc,
			  num, ZAXIS, plot_data_info->constant);
	   }
	}

	if (plot_data_info->xband || plot_data_info->yband || 
	    plot_data_info->zband)
	{
	     find_min_max (plot, gwin->plot_type);
	     tmp_plot = gwin->plist;
             while ((tmp_plot->active == false) && (tmp_plot->next != NULL))
                tmp_plot = tmp_plot->next;

             if (tmp_plot == NULL)
             {
                 mesg = xvf_strcpy("Cannot reset window unless plot(s) are displayed!\n");
                 xvf_error_wait(mesg, "run_plot_data", NULL);
                 free(mesg);
                 return;
             }

             gwin->WCmin = tmp_plot->WCmin;
             gwin->WCmax = tmp_plot->WCmax;

	     reset_world_coordinates();
	     plot_routine();
	}
}



/************************************************************
*
*   MODULE NAME: assign_band
*
*       PURPOSE: Assigns a band to a given plot dimension (ie.
*		 X axis, Y axis, Z axis).
*
*	 OUTPUT: none
*
*     CALLED BY: run_options
*
*    WRITTEN BY: Mike Lang & Danielle Argiro
*
*************************************************************/

assign_band(plot, image, which_band, num_bands, num_loc, num, axis, constant)

XPlot	*plot;
struct	xvimage *image;
int	which_band, num_bands, num_loc, num, axis;
float	constant;
{
	int i, index, dsize, dcount, msize, mcount, lsize, lcount, size;
        int com_type, current;
	char *data;
	char *bandnames[4], *prompt, *label;
        XawListReturnStruct *band_list_return;

	index = which_band +1;

	/*
	 *  Check to see if the user wants to assign a constant to
	 *  an axis.
	 */
	if(index == num)
	{
	   if(axis == XAXIS)
	      for (i = 0; i < plot->size; i++)
		 plot->points[i].x = constant;

	   else if(axis == YAXIS)
	      for (i = 0; i < plot->size; i++)
		 plot->points[i].y = constant;

	   else
	      for (i = 0; i < plot->size; i++)
		 plot->points[i].z = constant;
	}
   	else if(index > num_bands) 
   	{
	   /*
	    *  User choose location data for a dimension.
	    */
           imagesize(image,&dsize, &dcount, &msize, &mcount,&lsize, &lcount);
	   index = which_band - num_bands;
           size = lsize/image->location_dim;
      	   data = (char *) &image->location[index * size];
      	   assign_data(plot->points, data, plot->size, axis, VFF_TYP_FLOAT);
	}
	else
	{
	   /*
	    *  User choose image band data for a dimension.
	    */
           if (image->data_storage_type == VFF_TYP_COMPLEX)
           {
              prompt = xvf_strcpy("Choose Plot Type");
              label = xvf_strcpy("Complex Plot Type");
              bandnames[0] = xvf_strcpy("Real");
              bandnames[1] = xvf_strcpy("Imaginary");
              bandnames[2] = xvf_strcpy("Magnitude");
              bandnames[3] = xvf_strcpy("Phase");

              /*
               *  Prompt the user for which band they want using a list widget
               */

              com_type = 1;
              band_list_return = xvf_run_list_wait(bandnames, 4, 1, prompt,
                                                   label, &current, False);
             if (band_list_return != NULL)
                com_type = band_list_return->list_index + 1;

              for (i = 0; i < 4; i++)
                 free(bandnames[i]);
              free(prompt);
              free(label);

              if (! lvctor(image, com_type))
              {
                   xvf_error_wait(
           "Cannot convert the COMPLEX image data to the desired REAL data type",
                          "get_image", NULL);
                   freeimage(image);
                   return;
              }
           }
           imagesize(image,&dsize, &dcount, &msize, &mcount,&lsize, &lcount);
           size = dsize/image->num_data_bands;
      	   data = (char *) &image->imagedata[which_band * size];
      	   assign_data(plot->points, data, plot->size, axis, plot->data_type);
	}
}
