.\" @(#)rdrstrip.3t	1.2 5/2/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFReadRawStrip 3T "May 2, 1990"
.SH NAME
TIFFReadRawStrip \- return the undecoded contents of a strip from an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFReadRawStrip(TIFF* tif, u_int strip, u_char* buf, u_int size)"
.SH DESCRIPTION
Return the contents of the specified strip of data into the
(user supplied) data buffer.
The actual number of bytes of data that were placed in
.I buf
is returned;
.IR TIFFReadEncodedStrip ()
returns \-1 if an error was encountered.
Note that the value of
.I strip
is a ``raw strip number.''
That is, the caller must take into account whether or not the
data is organized in separate planes (\c
.IR PlanarConfiguration =2).
To read a full strip of data the data buffer should typically be
at least
.I RowsPerStrip
times the number returned by
.IR TIFFScanlineSize ().
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFReadEncodedStrip (3T),
.IR TIFFReadScanline (3T)
