.\" @(#)readdir.3t	1.2 5/2/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFReadDirectory 3T "May 2, 1990"
.SH NAME
TIFFReadDirectory \- get the contents of the next directory in an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFReadDirectory(TIFF* tif)"
.SH DESCRIPTION
Read the next directory in the specified file and make it the
current directory.
If the current directory has been modified and the file is opened for writing,
the current directory is first written out.
.IR TIFFReadDirectory ()
returns 1 if the next directory was successfully read.
Otherwise 0 is returned if an error was encountered,
or if there are no more directories to be read.
Applications only need to call
.IR TIFFReadDirectory ()
to read multiple subfiles in a single
.SM TIFF
file.
Normally the first directory in a file is automatically when
.IR TIFFOpen ()
is called.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
All warning messages are directed to the
.IR TIFFWarning (3T)
routine.
.PP
.BR "Seek error accessing TIFF directory" .
An error occurred while positioning to the location of the
directory.
.PP
\fBWrong data type %d for field "%s"\fP.
The tag entry in the directory had an incorrect data type.
For example, an
.I ImageDescription
tag with a
.SM SHORT
data type.
.PP
\fBTIFF directory is missing required "%s" field\fP.
The specified tag is required to be present by the
.SM TIFF
5.0 specification, but is missing.
The directory is (usually) unusable.
.PP
.BR "%s: Rational with zero denominator" .
A directory tag has a
.SM RATIONAL
value whose denominator is zero.
.PP
\fBIncorrect count %d for field "%s"\fP.
The specified tag's count field is bad.
For example, a count other than 1 for a
.I SubFileType
tag.
.PP
\fBCannot handle different per-sample values for field "%s"\fP.
The image has different
.I BitsPerSample
values for each of its samples.
.PP
\fBCount mismatch for field "%s"; expecting %d, got %d\fP.
The count field in a
.I StripByteCounts
or
.I StripOffsets
tag does not agree with the expected number of strips calculated
by the library (from other tags).
This should never happen, so if it does, the library refuses to
read the directory.
.PP
.BR "Invalid TIFF directory; tags are not sorted in ascending order" .
The directory tags are not properly sorted as specified
in the
.SM TIFF
5.0 specification.
This error is not fatal.
.PP
.BR "ignoring unknown field with tag %d (0x%x)"
An unknown tag was encountered in the directory;
the library ignores all such tags.
.PP
\fBTIFF directory is missing required "StripByteCounts" field, calculating from imagelength\fP.
The image violates the specification by not having a necessary field.
The library will calculate the value from the file size if
the image has a single strip.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFWriteDirectory (3T),
.IR TIFFSetDirectory (3T)
