 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "spectrum.h"

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>  		     	Input Utilities
 >>>>
 >>>>			input_new_image()
 >>>>			get_new_image()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name:  input_new_image
*
*       Purpose:  displays a new image when the user enters
*		  the filename of a new VIFF file and hits <cr>
*
*         Input:  infile - filename of then new VIFF file
*
*        Output:  changes image displayed
*
*     Called By:  run_files()
*
*    Written By:  Danielle Argiro
*
********************************************************/

int input_new_image(infile)

char *infile;
{
	float min, max; 
	int  index, first_time;
	char temp[MaxLength];

        /*
         * make sure they've provided a filename
         */
        if (infile == NULL)
        {
             xvf_error_wait("Error! No filename specified.",
                            "Spectrum", NULL);
             return(false);
        }

	if (spc_image == NULL) 
	    first_time = true;
	else 
	    first_time = false;

        /*
         * get new image, store in spc_image
         */
	if (!(get_new_image(infile))) return(false);
      
	if (first_time)
	{
	   if (!(init_spectrum()))
           {
              fprintf(stderr, "Spectrum:\n");
              fprintf(stderr, "couldn't perform initializations.\n");
              return(false);
           }
           register_image_classes();
   	   if (!(init_workspace()))
           {
              fprintf(stderr, "Spectrum:\n");
              fprintf(stderr, "couldn't initialize workspace.\n");
              return(false);
           }

	}

	/*
	 *  free the old data & input new
	 */
	else
	{
           spc_set_image_and_maps();

	   /*
            *  update with the new image & map data
            */
           if (!(xvd_update_image(xvdisplay, spc_image)))
              return(false);

	   change_band_function(current_red_func, SpcRed);
	   change_band_function(current_green_func, SpcGreen);
	   change_band_function(current_blue_func, SpcBlue);
	   update_xcolors_from_legend();
	   xvd_update_xcolors(xvdisplay);
	}

	xvd_set_colormap(xvdisplay->raster, xvdisplay->colormap);
	xvd_set_colormap(plot_workspace, xvdisplay->colormap);

        find_min_max_col_data(spc_map[0], spc_map_rownum, &min, &max);
	spc_wcmin.x = min; spc_wcmax.x = max;
	plot_x_focus = (max - min)/2.0;
        find_min_max_col_data(spc_map[1], spc_map_rownum, &min, &max);
	spc_wcmin.y = min; spc_wcmax.y = max;
	plot_y_focus = (max - min)/2.0;
	
	init_plot_info();
	draw_plot();
	index = master_info.scatter_plot->scatter->x_column_index+1;
	xvf_change_input(form, index, xvf_title_chng, "M0", 30);
	index = master_info.scatter_plot->scatter->y_column_index+1;
	xvf_change_input(form, index, xvf_title_chng, "M1", 30);
	index = master_info.scatter_plot->scatter->x_func_index;
	xvf_change_input(form, index, xvf_stringval_chng, "M0", 30);
	index = master_info.scatter_plot->scatter->y_func_index;
	xvf_change_input(form, index, xvf_stringval_chng, "M1", 30);

	index = master_info.scatter_plot->scatter->select_index;
	sprintf(temp, "none");
	xvf_change_input(form, index+1, xvf_title_chng, temp, 30);

	/* update printclass event handler */
        XtInsertEventHandler(xvdisplay->raster, ExposureMask |
                             PointerMotionMask | PointerMotionHintMask,
                             FALSE, update_printclass, NULL, XtListHead);

	return(true);
}


/********************************************************
*
*  Routine Name:  get_new_image
*
*       Purpose:  given a filename, attempts to gets the image 
*         Input:  filename - name of the VIFF file
*        Output:  changes spc_image if filename is valid
*     Called By:  run_files()
*    Written By:  Danielle Argiro
*
********************************************************/
int get_new_image(filename)
char *filename;
{
	struct xvimage *tmp_image;
	int  *mapping, final_num, scale, global_scale, calc_hist;
	char *alg, *filepath, temp[MaxLength];
	
	/* filename NULL - don't complain, just return */
	if (filename == NULL) return(false);
	if ((filepath = vfullpath(filename, NULL, NULL)) == NULL)
	{
	    sprintf(temp, "File '%s' not found", filename);
	    xvf_error_wait(temp, "Spectrum", NULL);
	    return(false);
	}

	/* attempt to read the image */
        if ((tmp_image = readimage(filepath)) == NULL)
        {
               sprintf(temp, "WARNING: Unable to read input image '%s'.\n",
		       filepath);
	       xvf_error_wait(temp, "Spectrum", NULL);
	       return(false);
        }

	if (tmp_image->data_storage_type != VFF_TYP_1_BYTE)
	{
               sprintf(temp, "SORRY: Unable to process images that are not of data type BYTE.\n");
	       xvf_error_wait(temp, "Spectrum", NULL);
	       return(false);
	}

	/* if we have more than 256 columns, call lvrdclust to reduce number */
        if (tmp_image->map_col_size > 256)
        {
              final_num = 256;
              alg = xvf_strcpy("1");
              scale = true;
              global_scale = false;
              calc_hist = false;
              mapping = NULL;
              lvrdclust(tmp_image, &spc_image, final_num, alg, scale,
                        global_scale, calc_hist, mapping);
              free(tmp_image);
        }

        else spc_image = tmp_image;

	return(true);
}
