
/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * cabezon.c - create a set of images with a left to rigth pull
 *
 * Author:      Raul Rivero
 *              Vicerrectorado de Estudiantes 
 *              University of Oviedo
 * Date:        Thu Jan 06 1993
 * Copyright (c) 1993, Raul Rivero
 *
 */
/*
 * Dedicated to Enrique Marcos :-).
 */

extern int LUGverbose;
extern char *MY_NAME; 

main( argc, argv )
int argc;
char **argv;
{
  int i;
  bitmap_hdr in;

  MY_NAME = argv[0];

   /*
   * Get options ( some day I'll build a procedure ).
   */
  if ( argc > 1 ) {             /* else core on SGI */
    while ( argv[1][0] == '-' ) {
      for ( i = 1; argv[1][i]; i++ ) {
        switch ( argv[1][i] ) {
                case 'v':
                        LUGverbose++;
                        break;
                default :
                        fprintf( stderr, "Usage: %s [-v] <input_image> <output_base_name> <#_of_frames>\n",
                                 MY_NAME );
                        exit( 0 );
                        break;
        }
      }
      argv++;
      argc--;
    }
  }

  if ( argc < 4 ) {
    fprintf( stderr, "Usage: %s [-v] <input_image> <output_base_name> <#_of_frames>\n",
             MY_NAME );
    exit( 0 );
  }

  /* Read the input file */
  read_lug_file( argv[1], &in );

  /* We wanna a true color image. Why?. Ok, it's my program! :-) */
  if ( in.depth < 24 )
   error( 7 ); 

  /* Calculate the images */ 
  displacement( &in, Atoi(argv[3]), argv[2] ); 
}

displacement( in, no_frames, base_name )
bitmap_hdr *in;
int no_frames;
char *base_name;
{
  bitmap_hdr base_image;
  bitmap_hdr cutted;
  int i, j;
  char name[132];
  double inc_x;

  if ( no_frames < 2 ) {
    fprintf( stderr, "%s: a # of frames lower than 2?. Try again!", MY_NAME );
    exit( 0 );
  } 

  /* Create the first/base image ... */
  create_solid_image( &base_image, in->xsize, in->ysize, 0, 0, 0 ); 
  /* ... and write it. */ 
  sprintf( name, "%s.%d", base_name, 1 );
  write_lug_file( name, &base_image );

  /* The step per frame */
  inc_x = ((double)in->xsize) / ((double)(no_frames-1));

  /* The loop! */
  for ( i = 1; i < no_frames-1; i++ ) {
    /* Set the current border, ... */
    j = (int) (((double)i)*inc_x);
    /* ... cut it, ...  */
    cut_bitmap( in, &cutted, 0, 0, j, in->ysize );
    /* ... and paste it. */ 
    paste( &base_image, &cutted, 0, 0 );
    /* What now?. Write it! */
    sprintf( name, "%s.%d", base_name, i+1 );
    write_lug_file( name, &base_image );
    /* Free the cutted image */
    freebitmap( &cutted );
  }

  /* Write the last image */
  sprintf( name, "%s.%d", base_name, no_frames );
  write_lug_file( name, in );

  /* Free the base image */
  freebitmap( &base_image );

}
