/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * showhp.c - Show images on HP 9000 using Starbase Library.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Sat Jan 4 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>


/*
 * Look here !!!
 * =============
 *
 * This code is valid only if we have defined the iHP
 * macro ( read the root Makefile for more information ).
 *
 */

#ifdef iHP

#include <starbase.c.h>

show_bitmap( name, image, ditherflag )
char *name;
bitmap_hdr *image;
int ditherflag;
{
  int fildes;
  int flag = 0;
  char aux[80];
  int planes;
  bitmap_hdr aux_bitmap;
  char *device = ( getenv("SB_OUTDEV") ? getenv("SB_OUTDEV") : "/dev/crt" );

  /*
   * Open the graphics display.
   */
  if ((fildes = gopen(device, OUTDEV, NULL, INIT | MODEL_XFORM)) == -1)
    error(16);
  planes = gethpplanes( fildes );
  vdc_extent(fildes, 0., 0., 0., 1.25, 1., 0.);

  if ( image->depth > planes ) {
    int colors;
    /*
     * We have an image with more colors than display,
     * dither the image and then display it.
     */
    flag++;
    /* Number of colors supported */
    colors = ( (2 << planes) < 256 ? 256 : (2 << planes) );  
    /* Ok, dither it and ... */
    if ( ditherflag )
      dither_image( image, &aux_bitmap, compute_levels(colors), (double) 1.0 );
    else quantize( image, &aux_bitmap, colors );
    /* ... show it */
    show_8_planes( fildes, &aux_bitmap );
  }else {
    /*
     * Our display have sufficient colors, only check
     * if the image has 24 palnes or not.
     */
    if ( image->depth < 24 )
      show_8_planes( fildes, image);
    else show_24_planes( fildes, image );
  }

  if ( flag ) {
    /* We use an auxiliar bitmap */
    free( aux_bitmap.r );
    free( aux_bitmap.cmap );
  }

  /*
   * Wait for a <return> and close the graphics display.
   */
  fgets(aux, 80, stdin);
  gclose(fildes);
}

show_8_planes( fildes, image )
int fildes;
bitmap_hdr *image;
{
  register int i;
  float aux[3];
  byte *ptr;

  /* Set the graphics mode */
  shade_mode(fildes, INIT | CMAP_NORMAL, FALSE);

  /* Define the cmap */
  ptr = image->cmap;
  for (i = 0; i< image->colors; i++) {
    aux[0]= ((float)*ptr++) / 255.;
    aux[1]= ((float)*ptr++) / 255.;
    aux[2]= ((float)*ptr++) / 255.;
    define_color_table(fildes, i, 1, &aux);
  }
  make_picture_current(fildes);

  /* Write the component */
  dcblock_write( fildes, 640-(image->xsize>>1), 512-(image->ysize>>1), 
                 image->xsize, image->ysize,
                 image->r, FALSE);
}

show_24_planes( fildes, image )
int fildes;
bitmap_hdr *image;
{
  /*
   * Show a 24 planes images on a 24/32 bits display,
   * full color.
   */

  /* Set the graphics mode */
  shade_mode(fildes, INIT | CMAP_FULL, FALSE);

  /* Write each component */
  bank_switch( fildes, 0, 0);
  dcblock_write( fildes, 640-(image->xsize>>1), 512-(image->ysize>>1), 
                 image->xsize, image->ysize,
                 image->b, FALSE);
  bank_switch( fildes, 1, 0);
  dcblock_write( fildes, 640-(image->xsize>>1), 512-(image->ysize>>1), 
                 image->xsize, image->ysize,
                 image->g, FALSE);
  bank_switch( fildes, 2, 0);
  dcblock_write( fildes, 640-(image->xsize>>1), 512-(image->ysize>>1),
                 image->xsize, image->ysize,
                 image->r, FALSE);
}

gethpplanes( fildes )
int fildes;
{
  int image_banks;
  int image_planes;
  int planes_per_bank;
  int overlay_planes;

  inquire_fb_configuration( fildes, &image_banks, &image_planes,
                            &planes_per_bank, &overlay_planes);
  return image_planes;
}

gethpsizes( fildes, xmax, ymax )
int fildes;
int *xmax, *ymax;
{
  float physical_limits[2][3];
  float resolution[3];
  float p1[3], p2[3];
  int cmap_size;

  inquire_sizes( fildes, physical_limits, resolution, p1, p2, &cmap_size );

  *xmax = MAX( physical_limits[0][0], physical_limits[1][0] );
  *ymax = MAX( physical_limits[0][1], physical_limits[1][1] );
}


#endif  /* iHP */

