/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * blur.c - blur function.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Mon Jan 6 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;

/*
 * We'll define the next blurring matrix
 *
 *                   |  1  2  1 |
 *           (1/16)  |  2  4  2 |
 *                   |  1  2  1 |
 *
 */
double blur_matrix[9] = {   .0625,   .125,   .0625,
			    .125,    .25,    .125,
			    .0625,   .125,   .0625   };


blur_bitmap(inbitmap, outbitmap)
bitmap_hdr *inbitmap;
bitmap_hdr *outbitmap;
{
  VPRINTF( stderr, "Blurring...\n" );
  convolve_bitmap( inbitmap, outbitmap, blur_matrix );
}

byte *
blur(buffer, xsize, ysize)
byte *buffer;
int xsize, ysize;
{
  return convolve( buffer, xsize, ysize, blur_matrix );
}
