#include "config.h"


#if !defined(PORTAB_H)
#define PORTAB_H

#if defined(ATARI_ST)
typedef unsigned char  UBYTE;  /* one byte, unsigned */
typedef char           BYTE;   /* one byte, signed */
typedef unsigned int   UWORD;  /* two bytes, unsigned */
typedef int            WORD;   /* two bytes, signed */
typedef unsigned long  ULONG;  /* four bytes, unsigned */
typedef long           LONG;   /* four bytes, signed */

#elif defined(MSDOS)
typedef unsigned char  UBYTE;  /* one byte, unsigned */
typedef char           BYTE;   /* one byte, signed */
typedef unsigned int   UWORD;  /* two bytes, unsigned */
typedef int            WORD;   /* two bytes, signed */
typedef unsigned long  ULONG;  /* four bytes, unsigned */
typedef long           LONG;   /* four bytes, signed */

#elif defined(SUN)
typedef unsigned char  UBYTE;  /* one byte, unsigned */
typedef char           BYTE;   /* one byte, signed */
typedef unsigned short UWORD;  /* two bytes, unsigned */
typedef short          WORD;   /* two bytes, signed */
typedef unsigned int   ULONG;  /* four bytes, unsigned */
typedef int            LONG;   /* four bytes, signed */

#elif defined(SEQUENT386)
typedef unsigned char  UBYTE;  /* one byte, unsigned */
typedef char           BYTE;   /* one byte, signed */
typedef unsigned short UWORD;  /* two bytes, unsigned */
typedef short          WORD;   /* two bytes, signed */
typedef unsigned int   ULONG;  /* four bytes, unsigned */
typedef int            LONG;   /* four bytes, signed */

#elif defined(AVIION)
typedef unsigned char  UBYTE;  /* one byte, unsigned */
typedef char           BYTE;   /* one byte, signed */
typedef unsigned short UWORD;  /* two bytes, unsigned */
typedef short          WORD;   /* two bytes, signed */
typedef unsigned int   ULONG;  /* four bytes, unsigned */
typedef int            LONG;   /* four bytes, signed */

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif /* machine type */


#if defined(MSDOS) || defined(SEQUENT386)
#define SWAP2(a) (a)
#define NSWAP2(a) ((((a) >> 8) & 0x00ff) + \
                   (((a) << 8) & 0xff00)   )

#define SWAP4(a) (a)
#define NSWAP4(a) ((((a) >> 24) & 0x000000ff) + \
                   (((a) >> 8)  & 0x0000ff00) + \
                   (((a) << 8)  & 0x00ff0000) + \
                   (((a) << 24) & 0xff000000)   )

#else
#define SWAP2(a) ((((a) >> 8) & 0x00ff) + \
                  (((a) << 8) & 0xff00)   )
#define NSWAP2(a) (a)

#define SWAP4(a) ((((a) >> 24) & 0x000000ff) + \
                  (((a) >> 8)  & 0x0000ff00) + \
                  (((a) << 8)  & 0x00ff0000) + \
                  (((a) << 24) & 0xff000000)   )
#define NSWAP4(a) (a)

#endif


#endif /* PORTAB_H */
