/*
 * dtr_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `dtr.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "dtr_ui.h"

/*
 * Create object `documentMenu' in the specified instance.
 */
Xv_opaque
dtr_documentMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	OpenFileHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveSoundFileMenuOption(Menu_item, Menu_generate);
	extern Menu_item	SaveSoundFileAsMenuOption(Menu_item, Menu_generate);
	extern Menu_item	InfoHandler(Menu_item, Menu_generate);
	extern Menu_item	CloseHandler(Menu_item, Menu_generate);
	extern Menu_item	QuitDtr(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open Sound File",
			MENU_GEN_PROC, OpenFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Sound File",
			MENU_GEN_PROC, SaveSoundFileMenuOption,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Sound File As...",
			MENU_GEN_PROC, SaveSoundFileAsMenuOption,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "About DTR ... ",
			MENU_GEN_PROC, InfoHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close",
			MENU_GEN_PROC, CloseHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Quit",
			MENU_GEN_PROC, QuitDtr,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Document",
		NULL);
	return obj;
}

/*
 * Create object `editMenu' in the specified instance.
 */
Xv_opaque
dtr_editMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	CutHandler(Menu_item, Menu_generate);
	extern Menu_item	CopyHandler(Menu_item, Menu_generate);
	extern Menu_item	UndoHandler(Menu_item, Menu_generate);
	extern Menu_item	PasteHandler(Menu_item, Menu_generate);
	extern Menu_item	ClearAllHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cut",
			MENU_GEN_PROC, CutHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Copy",
			MENU_GEN_PROC, CopyHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Undo",
			MENU_GEN_PROC, UndoHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Paste",
			MENU_GEN_PROC, PasteHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear All",
			MENU_GEN_PROC, ClearAllHandler,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "",
		NULL);
	return obj;
}

/*
 * Create object `audioOutputOptionsMenu' in the specified instance.
 */
Xv_opaque
dtr_audioOutputOptionsMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	SetSpeakerOutput(Menu_item, Menu_generate);
	extern Menu_item	SetHeadphoneOutput(Menu_item, Menu_generate);
	Xv_opaque	obj;
	Xv_opaque		audioOutputOptionsMenu_image0;
	static unsigned short	audioOutputOptionsMenu_bits0[] = {
#include "icons/speaker.icon"
	};
	Xv_opaque		audioOutputOptionsMenu_image1;
	static unsigned short	audioOutputOptionsMenu_bits1[] = {
#include "icons/headphone.icon"
	};
	
	audioOutputOptionsMenu_image0 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, audioOutputOptionsMenu_bits0,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	audioOutputOptionsMenu_image1 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, audioOutputOptionsMenu_bits1,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(XV_NULL, MENU_CHOICE_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_IMAGE, audioOutputOptionsMenu_image0,
			MENU_GEN_PROC, SetSpeakerOutput,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_IMAGE, audioOutputOptionsMenu_image1,
			MENU_GEN_PROC, SetHeadphoneOutput,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "",
		NULL);
	return obj;
}

/*
 * Create object `optionsMenu' in the specified instance.
 */
Xv_opaque
dtr_optionsMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	ResetMarkersHandler(Menu_item, Menu_generate);
	extern Menu_item	SizeToFitHandler(Menu_item, Menu_generate);
	extern Menu_item	GlobalWaveCanvasHandler(Menu_item, Menu_generate);
	extern Menu_item	ToggleSoundEditing(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Options",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear Selection",
			MENU_GEN_PROC, ResetMarkersHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Size To Fit",
			MENU_GEN_PROC, SizeToFitHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Global Wave Canvas",
			MENU_GEN_PROC, GlobalWaveCanvasHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Enable Sound Editing",
			MENU_GEN_PROC, ToggleSoundEditing,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Audio Output Options",
			MENU_PULLRIGHT, dtr_audioOutputOptionsMenu_create(ip, owner),
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Options",
		NULL);
	return obj;
}

/*
 * Create object `editListDocumentMenu' in the specified instance.
 */
Xv_opaque
dtr_editListDocumentMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	OpenEditListHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveEditListHandler(Menu_item, Menu_generate);
	extern Menu_item	EditListSaveAsHandler(Menu_item, Menu_generate);
	extern Menu_item	NewEditListHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open Edit List",
			MENU_GEN_PROC, OpenEditListHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Edit List",
			MENU_GEN_PROC, SaveEditListHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Edit List As...",
			MENU_GEN_PROC, EditListSaveAsHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "New",
			MENU_GEN_PROC, NewEditListHandler,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `mainWindow'.
 */
dtr_mainWindow_objects *
dtr_mainWindow_objects_initialize(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (dtr_mainWindow_objects *) calloc(1, sizeof (dtr_mainWindow_objects))))
		return (dtr_mainWindow_objects *) NULL;
	if (!ip->mainWindow)
		ip->mainWindow = dtr_mainWindow_mainWindow_create(ip, owner);
	if (!ip->menuControlPanel)
		ip->menuControlPanel = dtr_mainWindow_menuControlPanel_create(ip, ip->mainWindow);
	if (!ip->documentButton)
		ip->documentButton = dtr_mainWindow_documentButton_create(ip, ip->menuControlPanel);
	if (!ip->editButton)
		ip->editButton = dtr_mainWindow_editButton_create(ip, ip->menuControlPanel);
	if (!ip->optionsButton)
		ip->optionsButton = dtr_mainWindow_optionsButton_create(ip, ip->menuControlPanel);
	if (!ip->openEditListButton)
		ip->openEditListButton = dtr_mainWindow_openEditListButton_create(ip, ip->menuControlPanel);
	if (!ip->durationLabelMessage)
		ip->durationLabelMessage = dtr_mainWindow_durationLabelMessage_create(ip, ip->menuControlPanel);
	if (!ip->durationMessage)
		ip->durationMessage = dtr_mainWindow_durationMessage_create(ip, ip->menuControlPanel);
	if (!ip->sizeLabelMessage)
		ip->sizeLabelMessage = dtr_mainWindow_sizeLabelMessage_create(ip, ip->menuControlPanel);
	if (!ip->sizeMessage)
		ip->sizeMessage = dtr_mainWindow_sizeMessage_create(ip, ip->menuControlPanel);
	if (!ip->spaceLeftOnTmpLabelMessage)
		ip->spaceLeftOnTmpLabelMessage = dtr_mainWindow_spaceLeftOnTmpLabelMessage_create(ip, ip->menuControlPanel);
	if (!ip->spaceLeftOnTmpMessage)
		ip->spaceLeftOnTmpMessage = dtr_mainWindow_spaceLeftOnTmpMessage_create(ip, ip->menuControlPanel);
	if (!ip->recordButton)
		ip->recordButton = dtr_mainWindow_recordButton_create(ip, ip->menuControlPanel);
	if (!ip->pauseButton)
		ip->pauseButton = dtr_mainWindow_pauseButton_create(ip, ip->menuControlPanel);
	if (!ip->stopButton)
		ip->stopButton = dtr_mainWindow_stopButton_create(ip, ip->menuControlPanel);
	if (!ip->playButton)
		ip->playButton = dtr_mainWindow_playButton_create(ip, ip->menuControlPanel);
	if (!ip->playGain)
		ip->playGain = dtr_mainWindow_playGain_create(ip, ip->menuControlPanel);
	if (!ip->recordGain)
		ip->recordGain = dtr_mainWindow_recordGain_create(ip, ip->menuControlPanel);
	if (!ip->vuMeterCanvas)
		ip->vuMeterCanvas = dtr_mainWindow_vuMeterCanvas_create(ip, ip->mainWindow);
	if (!ip->selectionInfoControlPanel)
		ip->selectionInfoControlPanel = dtr_mainWindow_selectionInfoControlPanel_create(ip, ip->mainWindow);
	if (!ip->selectionDurationLabelMessage)
		ip->selectionDurationLabelMessage = dtr_mainWindow_selectionDurationLabelMessage_create(ip, ip->selectionInfoControlPanel);
	if (!ip->selectionDurationMessage)
		ip->selectionDurationMessage = dtr_mainWindow_selectionDurationMessage_create(ip, ip->selectionInfoControlPanel);
	if (!ip->selectionSizeLabelMessage)
		ip->selectionSizeLabelMessage = dtr_mainWindow_selectionSizeLabelMessage_create(ip, ip->selectionInfoControlPanel);
	if (!ip->selectionSizeMessage)
		ip->selectionSizeMessage = dtr_mainWindow_selectionSizeMessage_create(ip, ip->selectionInfoControlPanel);
	if (!ip->waveCanvas)
		ip->waveCanvas = dtr_mainWindow_waveCanvas_create(ip, ip->mainWindow);
	if (!ip->scaleCanvas)
		ip->scaleCanvas = dtr_mainWindow_scaleCanvas_create(ip, ip->mainWindow);
	if (!ip->zoomControlPanel)
		ip->zoomControlPanel = dtr_mainWindow_zoomControlPanel_create(ip, ip->mainWindow);
	if (!ip->canvasRewind2Button)
		ip->canvasRewind2Button = dtr_mainWindow_canvasRewind2Button_create(ip, ip->zoomControlPanel);
	if (!ip->canvasRewind1Button)
		ip->canvasRewind1Button = dtr_mainWindow_canvasRewind1Button_create(ip, ip->zoomControlPanel);
	if (!ip->canvasFastForward1Button)
		ip->canvasFastForward1Button = dtr_mainWindow_canvasFastForward1Button_create(ip, ip->zoomControlPanel);
	if (!ip->canvasFastForward2Button)
		ip->canvasFastForward2Button = dtr_mainWindow_canvasFastForward2Button_create(ip, ip->zoomControlPanel);
	if (!ip->zoomLevelTextField)
		ip->zoomLevelTextField = dtr_mainWindow_zoomLevelTextField_create(ip, ip->zoomControlPanel);
	if (!ip->zoomTimesMessage)
		ip->zoomTimesMessage = dtr_mainWindow_zoomTimesMessage_create(ip, ip->zoomControlPanel);
	if (!ip->zoomSlider)
		ip->zoomSlider = dtr_mainWindow_zoomSlider_create(ip, ip->zoomControlPanel);
	return ip;
}

/*
 * Create object `mainWindow' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_mainWindow_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		mainWindow_image;
	static unsigned short	mainWindow_bits[] = {
#include "icons/dtr.icon"
	};
	
	mainWindow_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, mainWindow_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 600,
		XV_HEIGHT, 460,
		XV_LABEL, "Digital Tape Recorder",
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, mainWindow_image,
			NULL),
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	return obj;
}

/*
 * Create object `menuControlPanel' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_menuControlPanel_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 115,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, NULL, NULL);
	return obj;
}

/*
 * Create object `documentButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_documentButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, dtr_documentMenu_create((caddr_t) ip, ip->mainWindow),
		NULL);
	return obj;
}

/*
 * Create object `editButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_editButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 120,
		XV_Y, 8,
		PANEL_LABEL_WIDTH, 24,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Edit",
		PANEL_ITEM_MENU, dtr_editMenu_create((caddr_t) ip, ip->mainWindow),
		NULL);
	return obj;
}

/*
 * Create object `optionsButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_optionsButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Options",
		PANEL_ITEM_MENU, dtr_optionsMenu_create((caddr_t) ip, ip->mainWindow),
		NULL);
	return obj;
}

/*
 * Create object `openEditListButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_openEditListButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		ShowEditListPanelHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 280,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Edit List...",
		PANEL_NOTIFY_PROC, ShowEditListPanelHandler,
		NULL);
	return obj;
}

/*
 * Create object `durationLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_durationLabelMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 365,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Duration:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `durationMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_durationMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 438,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `sizeLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_sizeLabelMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 397,
		XV_Y, 32,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Size:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `sizeMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_sizeMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 438,
		XV_Y, 32,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `spaceLeftOnTmpLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_spaceLeftOnTmpLabelMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 44,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Space left on /tmp:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `spaceLeftOnTmpMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_spaceLeftOnTmpMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 148,
		XV_Y, 44,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `recordButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_recordButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		RecordButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		recordButton_image;
	static unsigned short	recordButton_bits[] = {
#include "icons/record.icon"
	};
	
	recordButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, recordButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 4,
		XV_Y, 68,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_IMAGE, recordButton_image,
		PANEL_NOTIFY_PROC, RecordButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `pauseButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_pauseButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		PauseButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		pauseButton_image;
	static unsigned short	pauseButton_bits[] = {
#include "icons/pause.icon"
	};
	
	pauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, pauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 68,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_IMAGE, pauseButton_image,
		PANEL_NOTIFY_PROC, PauseButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `stopButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_stopButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		StopButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		stopButton_image;
	static unsigned short	stopButton_bits[] = {
#include "icons/stop.icon"
	};
	
	stopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, stopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 68,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_IMAGE, stopButton_image,
		PANEL_NOTIFY_PROC, StopButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `playButton' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_playButton_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		PlayButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		playButton_image;
	static unsigned short	playButton_bits[] = {
#include "icons/play.icon"
	};
	
	playButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, playButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 244,
		XV_Y, 68,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_IMAGE, playButton_image,
		PANEL_NOTIFY_PROC, PlayButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `playGain' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_playGain_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		PlayGainSlider(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 336,
		XV_Y, 68,
		PANEL_SLIDER_WIDTH, 200,
		PANEL_TICKS, 10,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Play ",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, PlayGainSlider,
		NULL);
	return obj;
}

/*
 * Create object `recordGain' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_recordGain_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		RecordGainSlider(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 324,
		XV_Y, 92,
		PANEL_SLIDER_WIDTH, 200,
		PANEL_TICKS, 10,
		PANEL_LABEL_STRING, "Record",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, RecordGainSlider,
		NULL);
	return obj;
}

/*
 * Create object `vuMeterCanvas' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_vuMeterCanvas_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void	VUMeterCanvasRepaintHandler(Canvas, Xv_window, Rectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->menuControlPanel, XV_Y) +
		      (int)xv_get(ip->menuControlPanel, XV_HEIGHT) + 2,
		XV_WIDTH, 147,
		XV_HEIGHT, 32,
		CANVAS_REPAINT_PROC, VUMeterCanvasRepaintHandler,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `selectionInfoControlPanel' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_selectionInfoControlPanel_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, (int)xv_get(ip->vuMeterCanvas, XV_X) +
		      (int)xv_get(ip->vuMeterCanvas, XV_WIDTH),
		XV_Y, (int)xv_get(ip->menuControlPanel, XV_Y) +
		      (int)xv_get(ip->menuControlPanel, XV_HEIGHT) + 2,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 32,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, NULL, NULL);
	return obj;
}

/*
 * Create object `selectionDurationLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_selectionDurationLabelMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Selection Duration :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `selectionDurationMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_selectionDurationMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 152,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `selectionSizeLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_selectionSizeLabelMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 312,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Size :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `selectionSizeMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_selectionSizeMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 356,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `waveCanvas' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_waveCanvas_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern Notify_value	WaveCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	WaveCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->vuMeterCanvas, XV_Y) +
		      (int)xv_get(ip->vuMeterCanvas, XV_HEIGHT),
		XV_WIDTH, 596,
		XV_HEIGHT, 200,
		CANVAS_REPAINT_PROC, WaveCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG3", "White");
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) WaveCanvasEventHandler, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `scaleCanvas' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_scaleCanvas_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void	ScaleCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->waveCanvas, XV_Y) +
		      (int)xv_get(ip->waveCanvas, XV_HEIGHT),
		XV_WIDTH, 596,
		XV_HEIGHT, 64,
		CANVAS_REPAINT_PROC, ScaleCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Highlight", NULL);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `zoomControlPanel' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_zoomControlPanel_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 410,
		XV_WIDTH, 597,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, NULL, NULL);
	return obj;
}

/*
 * Create object `canvasRewind2Button' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_canvasRewind2Button_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		CanvasRewind2Handler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		canvasRewind2Button_image;
	static unsigned short	canvasRewind2Button_bits[] = {
#include "icons/rewind2.icon"
	};
	
	canvasRewind2Button_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, canvasRewind2Button_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 8,
		PANEL_LABEL_IMAGE, canvasRewind2Button_image,
		PANEL_NOTIFY_PROC, CanvasRewind2Handler,
		NULL);
	return obj;
}

/*
 * Create object `canvasRewind1Button' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_canvasRewind1Button_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		CanvasRewind1Handler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		canvasRewind1Button_image;
	static unsigned short	canvasRewind1Button_bits[] = {
#include "icons/rewind1.icon"
	};
	
	canvasRewind1Button_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, canvasRewind1Button_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 8,
		PANEL_LABEL_IMAGE, canvasRewind1Button_image,
		PANEL_NOTIFY_PROC, CanvasRewind1Handler,
		NULL);
	return obj;
}

/*
 * Create object `canvasFastForward1Button' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_canvasFastForward1Button_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		CanvasFastForward1Handler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		canvasFastForward1Button_image;
	static unsigned short	canvasFastForward1Button_bits[] = {
#include "icons/fastfrwd1.icon"
	};
	
	canvasFastForward1Button_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, canvasFastForward1Button_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 8,
		PANEL_LABEL_IMAGE, canvasFastForward1Button_image,
		PANEL_NOTIFY_PROC, CanvasFastForward1Handler,
		NULL);
	return obj;
}

/*
 * Create object `canvasFastForward2Button' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_canvasFastForward2Button_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		CanvasFastForward2Handler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		canvasFastForward2Button_image;
	static unsigned short	canvasFastForward2Button_bits[] = {
#include "icons/fastfrwd2.icon"
	};
	
	canvasFastForward2Button_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, canvasFastForward2Button_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 8,
		PANEL_LABEL_IMAGE, canvasFastForward2Button_image,
		PANEL_NOTIFY_PROC, CanvasFastForward2Handler,
		NULL);
	return obj;
}

/*
 * Create object `zoomLevelTextField' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_zoomLevelTextField_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	ZoomLevelTextFieldHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 340,
		XV_Y, 8,
		PANEL_VALUE_DISPLAY_LENGTH, 6,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Zoom :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, ZoomLevelTextFieldHandler,
		NULL);
	return obj;
}

/*
 * Create object `zoomTimesMessage' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_zoomTimesMessage_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 460,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "time(s)",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `zoomSlider' in the specified instance.
 */
Xv_opaque
dtr_mainWindow_zoomSlider_create(dtr_mainWindow_objects *ip, Xv_opaque owner)
{
	extern void		ZoomSliderHandler(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 260,
		XV_Y, 28,
		PANEL_SLIDER_WIDTH, 280,
		PANEL_TICKS, 0,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, TRUE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 100,
		PANEL_MAX_VALUE, 500,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, ZoomSliderHandler,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `globalWaveCanvasPopUp'.
 */
dtr_globalWaveCanvasPopUp_objects *
dtr_globalWaveCanvasPopUp_objects_initialize(dtr_globalWaveCanvasPopUp_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (dtr_globalWaveCanvasPopUp_objects *) calloc(1, sizeof (dtr_globalWaveCanvasPopUp_objects))))
		return (dtr_globalWaveCanvasPopUp_objects *) NULL;
	if (!ip->globalWaveCanvasPopUp)
		ip->globalWaveCanvasPopUp = dtr_globalWaveCanvasPopUp_globalWaveCanvasPopUp_create(ip, owner);
	if (!ip->globalWaveCanvas)
		ip->globalWaveCanvas = dtr_globalWaveCanvasPopUp_globalWaveCanvas_create(ip, ip->globalWaveCanvasPopUp);
	if (!ip->globalWaveControlPanel)
		ip->globalWaveControlPanel = dtr_globalWaveCanvasPopUp_globalWaveControlPanel_create(ip, ip->globalWaveCanvasPopUp);
	if (!ip->globalWaveCanvasDoneButton)
		ip->globalWaveCanvasDoneButton = dtr_globalWaveCanvasPopUp_globalWaveCanvasDoneButton_create(ip, ip->globalWaveControlPanel);
	return ip;
}

/*
 * Create object `globalWaveCanvasPopUp' in the specified instance.
 */
Xv_opaque
dtr_globalWaveCanvasPopUp_globalWaveCanvasPopUp_create(dtr_globalWaveCanvasPopUp_objects *ip, Xv_opaque owner)
{
	extern Notify_value	GlobalWaveCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 707,
		XV_HEIGHT, 236,
		XV_LABEL, "Global Wave Canvas",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	xv_set(obj, WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(obj,
		(Notify_func) GlobalWaveCanvasEventHandler, NOTIFY_SAFE);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `globalWaveCanvas' in the specified instance.
 */
Xv_opaque
dtr_globalWaveCanvasPopUp_globalWaveCanvas_create(dtr_globalWaveCanvasPopUp_objects *ip, Xv_opaque owner)
{
	extern Notify_value	GlobalWaveCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	GlobalWaveCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 17,
		XV_Y, 0,
		XV_WIDTH, 669,
		XV_HEIGHT, 194,
		CANVAS_REPAINT_PROC, GlobalWaveCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG3", "White");
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) GlobalWaveCanvasEventHandler, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `globalWaveControlPanel' in the specified instance.
 */
Xv_opaque
dtr_globalWaveCanvasPopUp_globalWaveControlPanel_create(dtr_globalWaveCanvasPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 17,
		XV_Y, (int)xv_get(ip->globalWaveCanvas, XV_Y) +
		      (int)xv_get(ip->globalWaveCanvas, XV_HEIGHT),
		XV_WIDTH, 623,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	return obj;
}

/*
 * Create object `globalWaveCanvasDoneButton' in the specified instance.
 */
Xv_opaque
dtr_globalWaveCanvasPopUp_globalWaveCanvasDoneButton_create(dtr_globalWaveCanvasPopUp_objects *ip, Xv_opaque owner)
{
	extern void		GlobalWaveCanvasDoneHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 328,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Done",
		PANEL_EVENT_PROC, GlobalWaveCanvasDoneHandler,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `editListPanelPopUp'.
 */
dtr_editListPanelPopUp_objects *
dtr_editListPanelPopUp_objects_initialize(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (dtr_editListPanelPopUp_objects *) calloc(1, sizeof (dtr_editListPanelPopUp_objects))))
		return (dtr_editListPanelPopUp_objects *) NULL;
	if (!ip->editListPanelPopUp)
		ip->editListPanelPopUp = dtr_editListPanelPopUp_editListPanelPopUp_create(ip, owner);
	if (!ip->editListUpperControlPanel)
		ip->editListUpperControlPanel = dtr_editListPanelPopUp_editListUpperControlPanel_create(ip, ip->editListPanelPopUp);
	if (!ip->editListFileButton)
		ip->editListFileButton = dtr_editListPanelPopUp_editListFileButton_create(ip, ip->editListUpperControlPanel);
	if (!ip->totalNumberOfEditsLabelMessage)
		ip->totalNumberOfEditsLabelMessage = dtr_editListPanelPopUp_totalNumberOfEditsLabelMessage_create(ip, ip->editListUpperControlPanel);
	if (!ip->totalNumberOfEditsMessage)
		ip->totalNumberOfEditsMessage = dtr_editListPanelPopUp_totalNumberOfEditsMessage_create(ip, ip->editListUpperControlPanel);
	if (!ip->editListMessage)
		ip->editListMessage = dtr_editListPanelPopUp_editListMessage_create(ip, ip->editListUpperControlPanel);
	if (!ip->editListScrollListHeaderMessagePart1)
		ip->editListScrollListHeaderMessagePart1 = dtr_editListPanelPopUp_editListScrollListHeaderMessagePart1_create(ip, ip->editListUpperControlPanel);
	if (!ip->editListScrollListHeaderMessagePart2)
		ip->editListScrollListHeaderMessagePart2 = dtr_editListPanelPopUp_editListScrollListHeaderMessagePart2_create(ip, ip->editListUpperControlPanel);
	if (!ip->editListScrollList)
		ip->editListScrollList = dtr_editListPanelPopUp_editListScrollList_create(ip, ip->editListUpperControlPanel);
	if (!ip->editListLowerControlPanel)
		ip->editListLowerControlPanel = dtr_editListPanelPopUp_editListLowerControlPanel_create(ip, ip->editListPanelPopUp);
	if (!ip->currentEditLabelMessage)
		ip->currentEditLabelMessage = dtr_editListPanelPopUp_currentEditLabelMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->currentEditMessage)
		ip->currentEditMessage = dtr_editListPanelPopUp_currentEditMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->soundFileTextField)
		ip->soundFileTextField = dtr_editListPanelPopUp_soundFileTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->labelTextField)
		ip->labelTextField = dtr_editListPanelPopUp_labelTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->startingTimeMessage)
		ip->startingTimeMessage = dtr_editListPanelPopUp_startingTimeMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->startingTimeMinuteTextField)
		ip->startingTimeMinuteTextField = dtr_editListPanelPopUp_startingTimeMinuteTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->startingTimeMinuteMessage)
		ip->startingTimeMinuteMessage = dtr_editListPanelPopUp_startingTimeMinuteMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->startingTimeSecondTextField)
		ip->startingTimeSecondTextField = dtr_editListPanelPopUp_startingTimeSecondTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->startingTimeSecondMessage)
		ip->startingTimeSecondMessage = dtr_editListPanelPopUp_startingTimeSecondMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->endingTimeMessage)
		ip->endingTimeMessage = dtr_editListPanelPopUp_endingTimeMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->endingTimeMinuteTextField)
		ip->endingTimeMinuteTextField = dtr_editListPanelPopUp_endingTimeMinuteTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->endingTimeMinuteMessage)
		ip->endingTimeMinuteMessage = dtr_editListPanelPopUp_endingTimeMinuteMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->endingTimeSecondTextField)
		ip->endingTimeSecondTextField = dtr_editListPanelPopUp_endingTimeSecondTextField_create(ip, ip->editListLowerControlPanel);
	if (!ip->endingTimeSecondMessage)
		ip->endingTimeSecondMessage = dtr_editListPanelPopUp_endingTimeSecondMessage_create(ip, ip->editListLowerControlPanel);
	if (!ip->editListVolumeSlider)
		ip->editListVolumeSlider = dtr_editListPanelPopUp_editListVolumeSlider_create(ip, ip->editListLowerControlPanel);
	if (!ip->previewEditButton)
		ip->previewEditButton = dtr_editListPanelPopUp_previewEditButton_create(ip, ip->editListLowerControlPanel);
	if (!ip->addButton)
		ip->addButton = dtr_editListPanelPopUp_addButton_create(ip, ip->editListLowerControlPanel);
	if (!ip->modifyButton)
		ip->modifyButton = dtr_editListPanelPopUp_modifyButton_create(ip, ip->editListLowerControlPanel);
	if (!ip->deleteButton)
		ip->deleteButton = dtr_editListPanelPopUp_deleteButton_create(ip, ip->editListLowerControlPanel);
	if (!ip->deleteAllButton)
		ip->deleteAllButton = dtr_editListPanelPopUp_deleteAllButton_create(ip, ip->editListLowerControlPanel);
	return ip;
}

/*
 * Create object `editListPanelPopUp' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListPanelPopUp_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 466,
		XV_HEIGHT, 460,
		XV_LABEL, "Edit List Panel",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `editListUpperControlPanel' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListUpperControlPanel_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 261,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, NULL, NULL);
	return obj;
}

/*
 * Create object `editListFileButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListFileButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 12,
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, dtr_editListDocumentMenu_create((caddr_t) ip, ip->editListPanelPopUp),
		NULL);
	return obj;
}

/*
 * Create object `totalNumberOfEditsLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_totalNumberOfEditsLabelMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 248,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Number of Edits :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `totalNumberOfEditsMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_totalNumberOfEditsMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 372,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 120,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListScrollListHeaderMessagePart1' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListScrollListHeaderMessagePart1_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Edit #               Label               ",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListScrollListHeaderMessagePart2' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListScrollListHeaderMessagePart2_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 280,
		XV_Y, 60,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Duration (min : sec . 10ths)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListScrollList' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListScrollList_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern int		DumpEntry(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		PANEL_LIST_WIDTH, 420,
		PANEL_LIST_DISPLAY_ROWS, 8,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, DumpEntry,
		NULL);
	return obj;
}

/*
 * Create object `editListLowerControlPanel' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListLowerControlPanel_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 260,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, NULL, NULL);
	return obj;
}

/*
 * Create object `currentEditLabelMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_currentEditLabelMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Current Selection :  ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `currentEditMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_currentEditMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 284,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `soundFileTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_soundFileTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 10,
		XV_Y, 32,
		PANEL_VALUE_DISPLAY_LENGTH, 45,
		PANEL_VALUE_STORED_LENGTH, 1024,
		PANEL_LABEL_STRING, "Sound File :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `labelTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_labelTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	LabelTextFieldHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 10,
		XV_Y, 59,
		PANEL_VALUE_DISPLAY_LENGTH, 45,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Label         :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, LabelTextFieldHandler,
		NULL);
	return obj;
}

/*
 * Create object `startingTimeMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_startingTimeMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 9,
		XV_Y, 87,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Starting Time :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `startingTimeMinuteTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_startingTimeMinuteTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 125,
		XV_Y, 87,
		PANEL_VALUE_DISPLAY_LENGTH, 6,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `startingTimeMinuteMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_startingTimeMinuteMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 189,
		XV_Y, 87,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "m.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `startingTimeSecondTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_startingTimeSecondTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 87,
		PANEL_VALUE_DISPLAY_LENGTH, 6,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `startingTimeSecondMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_startingTimeSecondMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 285,
		XV_Y, 87,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "s.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `endingTimeMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_endingTimeMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 107,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Ending   Time :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `endingTimeMinuteTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_endingTimeMinuteTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 125,
		XV_Y, 107,
		PANEL_VALUE_DISPLAY_LENGTH, 6,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `endingTimeMinuteMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_endingTimeMinuteMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 189,
		XV_Y, 107,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "m.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `endingTimeSecondTextField' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_endingTimeSecondTextField_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 107,
		PANEL_VALUE_DISPLAY_LENGTH, 6,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `endingTimeSecondMessage' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_endingTimeSecondMessage_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 285,
		XV_Y, 107,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "s.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListVolumeSlider' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_editListVolumeSlider_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		PlayGainSlider(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 128,
		PANEL_SLIDER_WIDTH, 200,
		PANEL_TICKS, 10,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Volume",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, PlayGainSlider,
		NULL);
	return obj;
}

/*
 * Create object `previewEditButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_previewEditButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		PreviewEditButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 341,
		XV_Y, 128,
		PANEL_LABEL_WIDTH, 57,
		PANEL_LABEL_STRING, "Preview",
		PANEL_NOTIFY_PROC, PreviewEditButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `addButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_addButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		AddButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 11,
		XV_Y, 164,
		PANEL_LABEL_WIDTH, 57,
		PANEL_LABEL_STRING, "    Add",
		PANEL_NOTIFY_PROC, AddButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `modifyButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_modifyButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		ModifyButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 121,
		XV_Y, 164,
		PANEL_LABEL_WIDTH, 57,
		PANEL_LABEL_STRING, "  Modify",
		PANEL_NOTIFY_PROC, ModifyButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `deleteButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_deleteButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		DeleteButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 231,
		XV_Y, 164,
		PANEL_LABEL_WIDTH, 57,
		PANEL_LABEL_STRING, "  Delete",
		PANEL_NOTIFY_PROC, DeleteButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `deleteAllButton' in the specified instance.
 */
Xv_opaque
dtr_editListPanelPopUp_deleteAllButton_create(dtr_editListPanelPopUp_objects *ip, Xv_opaque owner)
{
	extern void		DeleteAllButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 341,
		XV_Y, 164,
		PANEL_LABEL_WIDTH, 70,
		PANEL_LABEL_STRING, "Delete All",
		PANEL_NOTIFY_PROC, DeleteAllButtonHandler,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `infoPopUp'.
 */
dtr_infoPopUp_objects *
dtr_infoPopUp_objects_initialize(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (dtr_infoPopUp_objects *) calloc(1, sizeof (dtr_infoPopUp_objects))))
		return (dtr_infoPopUp_objects *) NULL;
	if (!ip->infoPopUp)
		ip->infoPopUp = dtr_infoPopUp_infoPopUp_create(ip, owner);
	if (!ip->infoControlPanel)
		ip->infoControlPanel = dtr_infoPopUp_infoControlPanel_create(ip, ip->infoPopUp);
	if (!ip->appNameMessage)
		ip->appNameMessage = dtr_infoPopUp_appNameMessage_create(ip, ip->infoControlPanel);
	if (!ip->appVersionMessage)
		ip->appVersionMessage = dtr_infoPopUp_appVersionMessage_create(ip, ip->infoControlPanel);
	if (!ip->appDescriptionMessage)
		ip->appDescriptionMessage = dtr_infoPopUp_appDescriptionMessage_create(ip, ip->infoControlPanel);
	if (!ip->appDescription2Message)
		ip->appDescription2Message = dtr_infoPopUp_appDescription2Message_create(ip, ip->infoControlPanel);
	if (!ip->developerMessage)
		ip->developerMessage = dtr_infoPopUp_developerMessage_create(ip, ip->infoControlPanel);
	if (!ip->developerMessage1)
		ip->developerMessage1 = dtr_infoPopUp_developerMessage1_create(ip, ip->infoControlPanel);
	if (!ip->copyrightMessage)
		ip->copyrightMessage = dtr_infoPopUp_copyrightMessage_create(ip, ip->infoControlPanel);
	if (!ip->copyright2Message)
		ip->copyright2Message = dtr_infoPopUp_copyright2Message_create(ip, ip->infoControlPanel);
	if (!ip->copyright3Message)
		ip->copyright3Message = dtr_infoPopUp_copyright3Message_create(ip, ip->infoControlPanel);
	if (!ip->moreinfoMessage)
		ip->moreinfoMessage = dtr_infoPopUp_moreinfoMessage_create(ip, ip->infoControlPanel);
	return ip;
}

/*
 * Create object `infoPopUp' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_infoPopUp_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 475,
		XV_HEIGHT, 270,
		XV_LABEL, "DTR Info",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `infoControlPanel' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_infoControlPanel_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `appNameMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_appNameMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Digital Tape Recorder",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `appVersionMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_appVersionMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 204,
		XV_Y, 36,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Version 2.01",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `appDescriptionMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_appDescriptionMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 65,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "An audio application for use with",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `appDescription2Message' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_appDescription2Message_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 92,
		XV_Y, 85,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `developerMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_developerMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 152,
		XV_Y, 112,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Developed by Derek Lai",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `developerMessage1' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_developerMessage1_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 132,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Modifications by George Drapeau",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyrightMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_copyrightMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 156,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyright2Message' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_copyright2Message_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 176,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyright3Message' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_copyright3Message_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 196,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `moreinfoMessage' in the specified instance.
 */
Xv_opaque
dtr_infoPopUp_moreinfoMessage_create(dtr_infoPopUp_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 232,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "for more info, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

